/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.DynamicCommandChooser;
import oracle.jdeveloper.vcs.properties.PropertiesCommand;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSContextMenuListener;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdevimpl.vcs.generic.GenericClient;
import oracle.jdevimpl.vcs.generic.GenericHistoryAction;
import oracle.jdevimpl.vcs.generic.changelist.ViewPendingChangesAction;
import oracle.jdevimpl.vcs.generic.profile.MenusInfo;
import oracle.jdevimpl.vcs.generic.profile.ProfileInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionsInfo;

public class GenericContextMenuListener
extends VCSContextMenuListener {
    private final GenericClient _client;
    private final ProfileInfo _profileInfo;
    private final Logger _logger;

    public GenericContextMenuListener(GenericClient client, ProfileInfo profile, Logger logger) {
        super(client.getId());
        this._client = client;
        this._profileInfo = profile;
        this._logger = logger;
    }

    @Override
    protected Component[] getContextMenuItems(Context context) {
        if (!this.handlesViewType(context)) {
            return null;
        }
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        MenusInfo menus = this._profileInfo.getMenus();
        try {
            Command dynamicCommand = this.createDynamicCommand(context, menus);
            if (dynamicCommand != null) {
                menuItems.add(VCSMenuUtils.createMenuItem(dynamicCommand.getId(), 0.1f));
            }
        }
        catch (ClassNotFoundException cfne) {
            this._logger.severe("unable to load dynamic command chooser class");
        }
        catch (Exception e) {
            this._logger.severe("unable to instantiate dynamic command chooser class");
        }
        SectionsInfo menuInfo = menus.getMenu("oracle.jdeveloper.vcs.menus.MAIN_CONTEXT_MENU");
        if (menuInfo != null) {
            for (SectionInfo sectionInfo : menuInfo.getSections()) {
                for (String actionRef : sectionInfo.getActionRefs()) {
                    Integer cmdId = Ide.findCmdID((String)actionRef);
                    if (cmdId == null) {
                        this._logger.warning("unsatisfied action reference: " + actionRef);
                        continue;
                    }
                    IdeAction action = IdeAction.find((int)cmdId);
                    action.updateAction(context);
                    if (!action.isEnabled()) continue;
                    menuItems.add(VCSMenuUtils.createMenuItem(cmdId, 0.1f));
                }
            }
        }
        JMenu vMenu = null;
        boolean itemsAdded = false;
        float[] section = new float[]{1.0f};
        menuInfo = menus.getMenu("oracle.jdeveloper.vcs.menus.OPERATIONS_MENU");
        if (menuInfo != null) {
            vMenu = VCSMenuUtils.createVersioningSubmenu();
            itemsAdded = this.addDynamicMenuItems(menuInfo, vMenu, section, context, null);
        } else {
            if (menus.getMenu("oracle.jdeveloper.vcs.menus.VERSIONING_MENU") != null || menus.getMenu("oracle.jdeveloper.vcs.menus.VERSIONING_CONTEXT_MENU") != null) {
                vMenu = VCSMenuUtils.createVersioningSubmenu();
            }
            HashSet<String> actionRefs = new HashSet<String>();
            menuInfo = menus.getMenu("oracle.jdeveloper.vcs.menus.VERSIONING_CONTEXT_MENU");
            itemsAdded = this.addDynamicMenuItems(menuInfo, vMenu, section, context, actionRefs);
        }
        if (vMenu == null && this._profileInfo.getPendingChanges() != null) {
            vMenu = VCSMenuUtils.createVersioningSubmenu();
        }
        if (vMenu != null) {
            if (this._profileInfo.getHistoryProvider() != null) {
                float f = section[0];
                section[0] = f + 1.0f;
                float historySection = f;
                IdeAction versionHistoryAction = GenericHistoryAction.getAction(this._client);
                JMenuItem item = VCSMenuUtils.addDynamicMenuItem(vMenu, versionHistoryAction.getCommandId(), historySection, context);
                itemsAdded = itemsAdded || item != null;
                try {
                    IdeAction versionTreeAction;
                    if (this._profileInfo.getHistoryProvider().getVersionTreeActionClass() != null && (versionTreeAction = IdeAction.find((String)this._profileInfo.getHistoryProvider().getVersionTreeActionClass().getName())) != null) {
                        item = VCSMenuUtils.addDynamicMenuItem(vMenu, versionTreeAction.getCommandId(), historySection, context);
                        itemsAdded = itemsAdded || item != null;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    FeedbackManager.reportException((Throwable)cnfe);
                }
            }
            if (!this._profileInfo.getPropertyProvider().isEmpty()) {
                float f = section[0];
                section[0] = f + 1.0f;
                JMenuItem item = VCSMenuUtils.addDynamicMenuItem(vMenu, PropertiesCommand.PROPERTIES_CMD_ID, f, context);
                boolean bl = itemsAdded = itemsAdded || item != null;
            }
            if (this._profileInfo.getPendingChanges() != null) {
                JMenuItem item = VCSMenuUtils.addDynamicMenuItem(vMenu, ViewPendingChangesAction.getCommandId(this._profileInfo.getID()), section[0], context);
                boolean bl = itemsAdded = itemsAdded || item != null;
            }
        }
        if (itemsAdded) {
            menuItems.add(vMenu);
        }
        return !menuItems.isEmpty() ? menuItems.toArray(new Component[menuItems.size()]) : null;
    }

    private Command createDynamicCommand(Context context, MenusInfo menus) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class chooserClass;
        Class clazz = chooserClass = menus != null ? menus.getDynamicChooserClass() : null;
        if (chooserClass == null) {
            return null;
        }
        DynamicCommandChooser chooser = (DynamicCommandChooser)chooserClass.newInstance();
        String id = chooser.getDynamicCommandId(this._client, context);
        if (id == null) {
            return null;
        }
        Command command = CommandProcessor.createCommand((String)IdeAction.find((String)id).getCommand(), (Context)context);
        if (command instanceof ActionCommand) {
            ((ActionCommand)command).setProfile(this._client);
        }
        return ((VCSCommand)command).isAvailable() ? command : null;
    }

    private boolean addDynamicMenuItems(SectionsInfo menuInfo, JMenu vMenu, float[] section, Context context, Collection<String> actionRefs) {
        boolean itemsAdded = false;
        if (menuInfo != null) {
            for (SectionInfo sectionInfo : menuInfo.getSections()) {
                for (String actionRef : sectionInfo.getActionRefs()) {
                    if (actionRefs != null && actionRefs.contains(actionRef)) continue;
                    actionRefs.add(actionRef);
                    Integer cmdId = Ide.findCmdID((String)actionRef);
                    if (cmdId == null) {
                        this._logger.warning("unsatisfied vcs action reference: " + actionRef);
                        continue;
                    }
                    JMenuItem item = VCSMenuUtils.addDynamicMenuItem(vMenu, cmdId, section[0], context);
                    itemsAdded = itemsAdded || item != null;
                }
                section[0] = section[0] + 1.0f;
            }
        }
        return itemsAdded;
    }

    private boolean handlesViewType(Context context) {
        String viewType = VCSContextUtils.getContextViewType(context);
        if (viewType != null) {
            return viewType.indexOf("VCSNavigatorWindow") <= -1;
        }
        return true;
    }
}

