/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Displayable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.Navigable;
import oracle.javatools.history.HistoryProperty;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Log;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetRegistry;
import oracle.jdeveloper.vcs.generic.BaseStatusResolver;
import oracle.jdeveloper.vcs.generic.CheckOutProvider;
import oracle.jdeveloper.vcs.generic.ConflictsFinder;
import oracle.jdeveloper.vcs.generic.MultiChangeList;
import oracle.jdeveloper.vcs.generic.PendingChangesAdapter;
import oracle.jdeveloper.vcs.generic.ProfileListener;
import oracle.jdeveloper.vcs.generic.StatusResolver;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.properties.PropertiesPanelRegistry;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSCommandType;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSExtensionInformation;
import oracle.jdeveloper.vcs.spi.VCSHistoryProvider;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSProgress;
import oracle.jdeveloper.vcs.spi.VCSPropertyCustomizer;
import oracle.jdeveloper.vcs.spi.VCSPropertyDescriptor;
import oracle.jdeveloper.vcs.spi.VCSPropertyKey;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdeveloper.vcs.spi.VCSSingleNodeObserver;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSURLFileSystemHelper;
import oracle.jdeveloper.vcs.util.VCSDefaultUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSKeyboardUtils;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdeveloper.vcs.versiontree.VersionTreeCommand;
import oracle.jdevimpl.vcs.generic.GLazyIdeAction;
import oracle.jdevimpl.vcs.generic.GenericContextMenuListener;
import oracle.jdevimpl.vcs.generic.GenericController;
import oracle.jdevimpl.vcs.generic.GenericHistoryAction;
import oracle.jdevimpl.vcs.generic.GenericHistoryProvider;
import oracle.jdevimpl.vcs.generic.GenericPropertyPanelProvider;
import oracle.jdevimpl.vcs.generic.SearchNavigable;
import oracle.jdevimpl.vcs.generic.VCSActionInfoImpl;
import oracle.jdevimpl.vcs.generic.changelist.ChangeListViewId;
import oracle.jdevimpl.vcs.generic.changelist.GenericChangeListDockableFactory;
import oracle.jdevimpl.vcs.generic.changelist.StatusBasedChangeListWindow;
import oracle.jdevimpl.vcs.generic.changelist.StatusBasedMultiChangeList;
import oracle.jdevimpl.vcs.generic.changelist.ViewPendingChangesAction;
import oracle.jdevimpl.vcs.generic.profile.ActionInfo;
import oracle.jdevimpl.vcs.generic.profile.ActionsInfo;
import oracle.jdevimpl.vcs.generic.profile.AutomaticActionInfo;
import oracle.jdevimpl.vcs.generic.profile.ChangeListInfo;
import oracle.jdevimpl.vcs.generic.profile.ClientSettingInfo;
import oracle.jdevimpl.vcs.generic.profile.EventBusInfo;
import oracle.jdevimpl.vcs.generic.profile.FileSystemHelperInfo;
import oracle.jdevimpl.vcs.generic.profile.FileSystemInfo;
import oracle.jdevimpl.vcs.generic.profile.HistoryProviderInfo;
import oracle.jdevimpl.vcs.generic.profile.PendingChangesInfo;
import oracle.jdevimpl.vcs.generic.profile.PreferencesInfo;
import oracle.jdevimpl.vcs.generic.profile.ProfileInfo;
import oracle.jdevimpl.vcs.generic.profile.PropertyProviderInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionsInfo;
import oracle.jdevimpl.vcs.generic.profile.StatusInfo;
import oracle.jdevimpl.vcs.generic.profile.StatusesInfo;
import oracle.jdevimpl.vcs.generic.res.Resource;
import oracle.jdevimpl.vcs.generic.util.CandidateStatusFilter;
import oracle.jdevimpl.vcs.generic.util.RecognizedStatusFilter;
import oracle.jdevimpl.vcs.generic.util.UnrecognizedStatusFilter;
import oracle.jdevimpl.vcs.generic.util.UnversionedStatusFilter;
import oracle.jdevimpl.vcs.generic.util.VCSGenericUtil;
import oracle.jdevimpl.vcs.generic.util.VersionedStatusFilter;

public class GenericClient
extends VCSExtension
implements VCSProfile {
    private static final VCSStatus sUnrecognizedStatus = VCSDefaultUtils.createUnrecognizedStatus();
    private static final String AUTO_OP_CHECKOUT_NODE = "CHECKOUT_NODE";
    private final Logger _logger;
    private URL _systemDirectory;
    private final ProfileInfo _profile;
    private ProfileListener _profileListener;
    private StatusResolver _statusResolver;
    private final Map _fsHelpers = new HashMap(5);
    private final Map _actionInfos = new HashMap(20);
    private VCSStatusCache _statusCache;
    private Controller _controller;
    private IdeAction[] _actions;
    private ContextMenuListener _contextMenuListener;
    private IconOverlayTracker _overlayTracker;
    private VCSExtensionInformation _clientInfo;
    private ChangeListener _propertyChangeListener;
    private CheckOutProvider _checkOutProvider;
    private VCSHistoryProvider _historyProvider;
    private boolean _canActivate = true;
    private final Collection _propProviders = new ArrayList(5);
    private final Map _changeListsById = new HashMap(10);
    private final Map _changeListInfosById = new HashMap(10);
    private String _changeListViewID;
    private PendingChangesAdapter _pendingChangesAdapter;
    private ChangeList[] _changeLists;
    private VCSOverlayItemProducer _overlayProducer;
    private ConflictsFinder _conflictsFinder;
    private ChangeSetAdapter _changeSetAdapter;
    private static final Log LOG = new Log("vcs");
    private final Map _qualifiedDataKeys = new HashMap(10);

    public GenericClient(ProfileInfo profile) {
        this._logger = Logger.getLogger(profile.getID());
        this._profile = profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        if (!Ide.getIdeArgs().getCreateUI() && !this._profile.getHeadless()) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            super.initialize();
            this._logger.addHandler(this.createDefaultLogHandler());
            this._logger.setUseParentHandlers(false);
            this._statusResolver = this.createStatusResolver();
            this._profileListener = this.createProfileListener();
            this.initializeClientSettings();
            if (Ide.getIdeArgs().getCreateUI()) {
                try {
                    this.initializePreferencePanels();
                }
                catch (ClassNotFoundException cfne) {
                    this._logger.severe("unable to load preferences panel class");
                }
            }
            this.fireProfileInitialized();
        }
        catch (Exception e) {
            this._canActivate = false;
            this._logger.log(Level.SEVERE, "error initializing vcs profile " + this._profile.getID(), e);
        }
        finally {
            if (this._canActivate) {
                this._logger.info("profile initialized in " + String.valueOf(System.currentTimeMillis() - start) + "ms");
            }
        }
    }

    @Override
    public boolean isControlled(URL url) {
        URLFilter filter = this._profile.getFileSystem().getURLFilter("oracle.jdeveloper.vcs.filters.url.CONTROL");
        if (filter == null) {
            LOG.trace(this.getId() + ": url-filter oracle.jdeveloper.vcs.filters.url.CONTROL undefined");
            return false;
        }
        return filter.accept(url);
    }

    @Override
    public boolean canActivate() {
        return this._canActivate && this.fireCanActivate() && super.canActivate();
    }

    @Override
    public void activate() {
        long start = System.currentTimeMillis();
        this.initializeDefaultStatusFilters();
        if (Ide.getIdeArgs().getCreateUI()) {
            this.activateOperations();
            VCSKeyboardUtils.addKeyStrokeContext(this._actions, this.getInformation().getShortLabel());
            this.activateMenus();
        }
        this.activateEventBusComponents();
        if (Ide.getIdeArgs().getCreateUI()) {
            VCSPropertyMap commonProperties = this.getData("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
            this._overlayProducer = this.createOverlayProducer();
            if (commonProperties != null) {
                this._propertyChangeListener = new ClientChangeListener();
                commonProperties.addChangeListener(this._propertyChangeListener);
                if (this._overlayProducer instanceof ChangeListener) {
                    commonProperties.addChangeListener((ChangeListener)((Object)this._overlayProducer));
                }
                commonProperties.fireChangeEvent();
            }
        }
        if (this._fsHelpers.isEmpty()) {
            for (FileSystemHelperInfo helperInfo : this._profile.getFileSystem().getHelpers()) {
                try {
                    Class helperClass = helperInfo.getHelperClass();
                    URLFileSystemHelper helperInstance = (URLFileSystemHelper)helperClass.newInstance();
                    if (helperInstance instanceof URLFileSystemHelperDecorator) {
                        VCSFileSystemUtils.registerDecorator(helperInfo.getProtocol(), (URLFileSystemHelperDecorator)helperInstance);
                    } else {
                        URLFileSystem.registerHelper((String)helperInfo.getProtocol(), (URLFileSystemHelper)helperInstance);
                    }
                    this._fsHelpers.put(helperInfo.getProtocol(), helperClass.newInstance());
                }
                catch (ClassNotFoundException cfne) {
                    this._logger.severe("unable to load filesystem helper class for protocol " + helperInfo.getProtocol());
                }
                catch (Exception e) {
                    this._logger.severe("unable to instantiate filesystem helper class for protocol " + helperInfo.getProtocol());
                }
            }
        }
        Iterator it = this._fsHelpers.entrySet().iterator();
        while (it.hasNext()) {
            Object helper = it.next().getValue();
            if (!(helper instanceof VCSURLFileSystemHelper)) continue;
            ((VCSURLFileSystemHelper)((Object)helper)).setEnabled(true);
        }
        if (Ide.getIdeArgs().getCreateUI()) {
            this.manageOverlayTracker();
        }
        if (this._checkOutProvider == null) {
            try {
                if (this._profile.getCheckOutClass() != null) {
                    this._checkOutProvider = (CheckOutProvider)this._profile.getCheckOutClass().newInstance();
                }
            }
            catch (ClassNotFoundException cfne) {
                this._logger.severe("unable to load checkout provider class");
            }
            catch (Exception e) {
                this._logger.severe("unable to instantiate checkout provider class");
            }
        }
        if (this._conflictsFinder == null) {
            try {
                if (this._profile.getConflictsFinderClass() != null) {
                    this._conflictsFinder = (ConflictsFinder)this._profile.getConflictsFinderClass().newInstance();
                }
            }
            catch (ClassNotFoundException cfne) {
                this._logger.severe("unable to load conflicts finder class");
            }
            catch (Exception e) {
                this._logger.severe("unable to instantiate conflicts finder class");
            }
        }
        if (Ide.getIdeArgs().getCreateUI()) {
            HistoryProviderInfo historyProviderInfo = this._profile.getHistoryProvider();
            if (historyProviderInfo != null) {
                IdeAction versionHistoryAction = GenericHistoryAction.getAction(this);
                VCSActionInfoImpl historyActionInfo = new VCSActionInfoImpl(this, historyProviderInfo){

                    @Override
                    public VCSCommandStyle getStyle() {
                        return VCSCommandStyle.NORMAL;
                    }

                    @Override
                    public VCSCommandType getType() {
                        return VCSCommandType.BOTH;
                    }
                };
                this._actionInfos.put(Ide.findCmdName((int)versionHistoryAction.getCommandId()), historyActionInfo);
                this._historyProvider = new VCSHistoryProvider(new GenericHistoryProvider(this, historyProviderInfo, this._profile.getClientInfo(), historyActionInfo), versionHistoryAction);
                try {
                    Class versionTreeActionClass = historyProviderInfo.getVersionTreeActionClass();
                    if (versionTreeActionClass != null) {
                        IdeAction versionTreeAction = VersionTreeCommand.getVersionTreeAction(versionTreeActionClass.getName(), this.getId());
                        this._historyProvider.setVersionTreeAction(versionTreeAction);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    this._logger.log(Level.SEVERE, "unable to load version tree action class " + cnfe.getMessage());
                }
            }
            Collection propProviders = this._profile.getPropertyProvider();
            it = propProviders.iterator();
            while (it.hasNext()) {
                try {
                    GenericPropertyPanelProvider provider = new GenericPropertyPanelProvider(this, (PropertyProviderInfo)((Object)it.next()));
                    PropertiesPanelRegistry.registerPanelProvider(provider);
                    this._propProviders.add(provider);
                }
                catch (ClassNotFoundException cnfe) {
                    this._logger.log(Level.SEVERE, "unable to load property panel class " + cnfe.getMessage());
                }
            }
            PendingChangesInfo pcInfo = this._profile.getPendingChanges();
            if (pcInfo != null) {
                try {
                    this.activatePendingChanges(pcInfo);
                }
                catch (Exception e) {
                    this._logger.log(Level.SEVERE, "unable to activate pending changes support", e);
                }
            }
            if (this._changeSetAdapter == null) {
                try {
                    if (this._profile.getChangeSetsClass() != null) {
                        this._changeSetAdapter = (ChangeSetAdapter)this._profile.getChangeSetsClass().getConstructor(String.class).newInstance(this.getId());
                        ChangeSetRegistry.register(this._changeSetAdapter);
                    }
                }
                catch (ClassNotFoundException cfne) {
                    this._logger.severe("unable to load change sets adapter class");
                }
                catch (Exception e) {
                    this._logger.severe("unable to instantiate change sets adapter class");
                }
            }
        }
        this.fireProfileActivated();
        this._logger.info("profile activated in " + String.valueOf(System.currentTimeMillis() - start) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        long start = System.currentTimeMillis();
        try {
            this.fireProfileDestroyed();
        }
        finally {
            this._logger.info("profile destroyed in " + String.valueOf(System.currentTimeMillis() - start) + "ms");
        }
    }

    @Override
    public VCSStatusCache getStatusCache() {
        if (this._statusCache == null) {
            try {
                this._statusCache = new VCSStatusCache(){

                    @Override
                    protected void getImpl(URL[] urls, VCSStatus[] statuses) throws Exception {
                        GenericClient.this._statusResolver.populateStatuses(GenericClient.this, urls, statuses);
                    }

                    @Override
                    protected void clearValues(URLFilter filter, boolean invalidate) {
                        if (GenericClient.this._statusResolver instanceof BaseStatusResolver) {
                            ((BaseStatusResolver)GenericClient.this._statusResolver).clearStatuses(filter);
                        }
                        super.clearValues(filter, invalidate);
                    }
                };
            }
            catch (Exception e) {
                this._logger.severe("Unable to resolve statuses: " + e.getMessage());
                return null;
            }
        }
        return this._statusCache;
    }

    public String getID() {
        return this._profile.getID();
    }

    @Override
    public String getId() {
        return this.getID();
    }

    public ProfileInfo getProfileInfo() {
        return this._profile;
    }

    @Override
    public URLFilter getURLFilter() {
        return this.getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
    }

    @Override
    public URLFilter getURLFilter(String id) {
        FileSystemInfo fsi = this._profile.getFileSystem();
        if (fsi != null) {
            return fsi.getURLFilter(id);
        }
        return null;
    }

    @Override
    public VCSStatusFilter getStatusFilter(String id) {
        StatusesInfo si;
        FileSystemInfo fsi = this._profile.getFileSystem();
        if (fsi != null && (si = fsi.getStatuses()) != null) {
            return si.getStatusFilter(id);
        }
        return null;
    }

    @Override
    public VCSExtensionInformation getInformation() {
        if (this._clientInfo == null) {
            this._clientInfo = new VCSExtensionInformation(new Displayable(){

                public Icon getIcon() {
                    return null;
                }

                public String getLongLabel() {
                    return GenericClient.this._profile.getClientInfo().getLongLabel();
                }

                public String getShortLabel() {
                    return GenericClient.this._profile.getClientInfo().getShortLabel();
                }

                public String getToolTipText() {
                    return this.getLongLabel();
                }

                public String toString() {
                    return this.getShortLabel();
                }
            });
        }
        return this._clientInfo;
    }

    @Override
    public String getCheckOutCommand() {
        ActionsInfo ops = this._profile.getActions();
        AutomaticActionInfo op = ops.getAutomaticAction(AUTO_OP_CHECKOUT_NODE);
        return op != null ? op.getActionClassName() : null;
    }

    @Override
    public VCSPropertyDescriptor getPropertyDescriptor() {
        return new VCSPropertyDescriptor(this._profile.getID(), this.getQualifiedDataKey("oracle.jdeveloper.vcs.data.COMMON_SETTINGS"), new String[]{"useOverlays", "autoCheckouts", "property_operation_timeout"});
    }

    @Override
    public boolean canCheckOut(URL url) throws Exception {
        return this._checkOutProvider != null ? this._checkOutProvider.canCheckOut(url) : super.canCheckOut(url);
    }

    @Override
    public boolean setReadWrite(URL url) throws Exception {
        if (this._checkOutProvider != null) {
            try {
                return this._checkOutProvider.checkOut(url);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return super.setReadWrite(url);
    }

    @Override
    public boolean setReadWrite(URL[] urls) throws Exception {
        return super.setReadWrite(urls);
    }

    @Override
    public boolean setReadWrite(URL[] urls, VCSProgress progress) throws Exception {
        if (this._checkOutProvider != null) {
            try {
                return this._checkOutProvider.checkOut(urls, progress);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return super.setReadWrite(urls, progress);
    }

    @Override
    public boolean isConflictsStatus(VCSStatus status) {
        return status instanceof StatusInfo && ((StatusInfo)status).isConflicts();
    }

    @Override
    public boolean isConflictsStatus(URL url) {
        return this._conflictsFinder != null ? this._conflictsFinder.containsConflicts(url) : super.isConflictsStatus(url);
    }

    @Override
    public ClientSetting getSettings() {
        return ClientSetting.findOrCreate((String)this._profile.getID());
    }

    @Override
    public VCSPropertyMap getData(String key) {
        return (VCSPropertyMap)this.getSettings().getData(this.getQualifiedDataKey(key));
    }

    @Override
    public String getQualifiedDataKey(String key) {
        String qualified = (String)this._qualifiedDataKeys.get(key);
        if (qualified == null) {
            qualified = this._profile.getID() + "." + key;
        }
        return qualified;
    }

    @Override
    public VCSStatus getStatusInstance(String id) {
        if ("oracle.jdeveloper.vcs.status.UNRECOGNIZED".equals(id)) {
            return sUnrecognizedStatus;
        }
        return this._profile.getFileSystem().getStatuses().getStatus(id);
    }

    @Override
    public synchronized VCSActionInfo getActionInfo(String actionId) {
        ActionInfo actionInfo;
        VCSActionInfo ai = (VCSActionInfo)this._actionInfos.get(actionId);
        if (ai == null && (actionInfo = this._profile.getActions().getAction(actionId)) != null) {
            ai = this._profile.getPendingChanges() != null ? new ActionInfoImpl(this, actionInfo, this._profile.getPendingChanges().getChangeLists()) : new ActionInfoImpl((VCSProfile)this, actionInfo);
            this._actionInfos.put(actionId, ai);
        }
        return ai;
    }

    @Override
    public synchronized URL getSystemDirectory() {
        if (this._systemDirectory == null) {
            this._systemDirectory = ExtensionRegistry.getExtensionRegistry().getSystemDirectory(this._profile.getID());
        }
        return this._systemDirectory;
    }

    @Override
    public Logger getLogger() {
        return this._logger;
    }

    @Override
    public CheckOutProvider getCheckOutProvider() {
        return this._checkOutProvider;
    }

    @Override
    public VCSHistoryProvider getHistoryProvider() {
        return this._historyProvider;
    }

    @Override
    public HistoryProperty getHistoryProperty(String id) {
        HistoryProvider provider;
        VCSHistoryProvider vcsProvider = this.getHistoryProvider();
        if (vcsProvider != null && (provider = vcsProvider.getHistoryProvider()) != null && provider instanceof GenericHistoryProvider) {
            return ((GenericHistoryProvider)provider).getProperty(id);
        }
        return null;
    }

    @Override
    public String getChangeListViewID() {
        if (this._profile.getPendingChanges() != null) {
            if (this._changeListViewID == null) {
                this._changeListViewID = ChangeListViewId.getViewId(this);
            }
            return this._changeListViewID;
        }
        return null;
    }

    @Override
    public PendingChangesAdapter getPendingChangesAdapter() {
        if (this._profile.getPendingChanges() == null) {
            return null;
        }
        if (this._pendingChangesAdapter == null) {
            PendingChangesAdapter adapter = this._profile.getPendingChanges().getAdapter();
            if (adapter == null) {
                adapter = new PendingChangesAdapter(){

                    @Override
                    public VCSProfile getProfile() {
                        return GenericClient.this;
                    }
                };
            }
            this._pendingChangesAdapter = adapter;
        }
        return this._pendingChangesAdapter;
    }

    public ChangeList[] getChangeLists() {
        PendingChangesInfo pci;
        if (this._changeLists == null && (pci = this._profile.getPendingChanges()) != null) {
            Collection declaredLists = pci.getChangeLists();
            ArrayList<ChangeList> lists = new ArrayList<ChangeList>(declaredLists.size() * 2);
            for (Object o : declaredLists) {
                if (o instanceof ChangeListInfo) {
                    ChangeListInfo clInfo = (ChangeListInfo)o;
                    String changeListClass = clInfo.getChangeListClass();
                    ChangeList cl = null;
                    if (changeListClass != null) {
                        try {
                            cl = (ChangeList)Class.forName(changeListClass).newInstance();
                        }
                        catch (Exception e) {
                            this._logger.severe("error instantiating change list class: " + e.getClass().getName() + ": " + e.getMessage());
                        }
                    } else {
                        StatusBasedMultiChangeList.sContextProfile = this;
                        StatusBasedMultiChangeList.sContextInfo = clInfo;
                        cl = new StatusBasedMultiChangeList(this, clInfo);
                        StatusBasedMultiChangeList.sContextProfile = null;
                        StatusBasedMultiChangeList.sContextInfo = null;
                    }
                    if (cl == null) continue;
                    lists.add(cl);
                    this._changeListsById.put(clInfo.getID(), cl);
                    this._changeListInfosById.put(clInfo.getID(), clInfo);
                    continue;
                }
                if (!(o instanceof MultiChangeList)) continue;
                ChangeList cl = (ChangeList)o;
                lists.add(cl);
                this._changeListsById.put(cl.getClass().getName(), cl);
                this._changeListInfosById.put(cl.getClass().getName(), null);
            }
            this._changeLists = lists.toArray(new ChangeList[lists.size()]);
        }
        return this._changeLists;
    }

    public ChangeList getChangeList(String id) {
        this.getChangeLists();
        return (ChangeList)this._changeListsById.get(id);
    }

    public ChangeListInfo getChangeListInfo(String id) {
        this.getChangeLists();
        return (ChangeListInfo)this._changeListInfosById.get(id);
    }

    private void initializeClientSettings() {
        ClientSetting prefs = this.getSettings();
        Map propertyMap = VCSPropertyCustomizer.createDefaultProperties(new String[]{"useOverlays", "useLabelDecorations", "logMessagesToLogWindow", "autoCheckouts", "autoCheckoutComment", "property_operation_timeout"});
        VCSPropertyMap commonPrefs = this.getData("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
        if (commonPrefs != null) {
            propertyMap.putAll(commonPrefs.getMap());
        } else {
            commonPrefs = new VCSPropertyMap();
            prefs.putData(this.getQualifiedDataKey("oracle.jdeveloper.vcs.data.COMMON_SETTINGS"), commonPrefs);
        }
        commonPrefs.setMap(propertyMap);
        for (ClientSettingInfo cs : this._profile.getClientSettings()) {
            String key = this.getQualifiedDataKey(cs.getID());
            VCSPropertyMap properties = (VCSPropertyMap)prefs.getData(key);
            properties = this.initializePropertiesMapObject(properties, cs.getProperties());
            prefs.putData(key, (Copyable)properties);
        }
    }

    private final VCSPropertyMap initializePropertiesMapObject(VCSPropertyMap properties, Map defaultsMap) {
        Map propertiesMap;
        Map map = propertiesMap = defaultsMap != null ? defaultsMap : new HashMap();
        if (properties != null) {
            propertiesMap.putAll(properties.getMap());
        } else {
            properties = new VCSPropertyMap();
        }
        properties.setMap(propertiesMap);
        return properties;
    }

    private void initializePreferencePanels() throws ClassNotFoundException {
        PreferencesInfo prefs = this._profile.getPreferences();
        if (prefs == null) {
            this._logger.fine("no preference panels to initialize");
            return;
        }
        List childPanels = prefs.getChildPanels();
        Navigable[] children = new Navigable[childPanels.size()];
        Iterator it = childPanels.iterator();
        int index = 0;
        while (it.hasNext()) {
            PreferencesInfo.ChildPanelInfo p = (PreferencesInfo.ChildPanelInfo)it.next();
            children[index++] = new SearchNavigable(p.getLabel(), p.getTraversableClass(), p.getSearchTag());
        }
        Navigable root = new Navigable(this.getInformation().getShortLabel(), prefs.getTraversableClass(), (Navigable[])(children.length > 0 ? children : null));
        VCSNavigableUtils.registerSystemNavigable(root);
    }

    private void initializeDefaultStatusFilters() {
        StatusesInfo s = this._profile.getFileSystem().getStatuses();
        if (s != null) {
            s.addStatusFilter(new VersionedStatusFilter());
            s.addStatusFilter(new UnversionedStatusFilter());
            s.addStatusFilter(new CandidateStatusFilter());
            s.addStatusFilter(new RecognizedStatusFilter(sUnrecognizedStatus));
            s.addStatusFilter(new UnrecognizedStatusFilter(sUnrecognizedStatus));
        }
    }

    private void activateOperations() {
        assert (this._controller == null);
        assert (this._actions == null);
        this._controller = new GenericController(this, this._profile);
        this._actionInfos.clear();
        this._actions = this.createActions();
        for (int i = 0; i < this._actions.length; ++i) {
            this._actions[i].addController(this._controller);
        }
        IdeAction action = IdeAction.find((int)51);
        if (action != null) {
            action.addController(this._controller);
        }
    }

    private IdeAction[] createActions() {
        ActionsInfo opInfo = this._profile.getActions();
        List operations = opInfo.getActions();
        if (operations != null && operations.size() > 0) {
            ArrayList<IdeAction> actions = new ArrayList<IdeAction>(operations.size() * 2);
            for (ActionInfo op : operations) {
                Boolean toggleStatus;
                IdeAction action;
                int commandIdeId = Ide.findOrCreateCmdID((String)op.getID());
                String className = op.getActionClassName();
                if (op.getResourcePrefix() != null) {
                    try {
                        action = GLazyIdeAction.getAction(commandIdeId, className, this._profile.getRsbundleClass(), op.getResourcePrefix(), op.getIconRef());
                        toggleStatus = op.getToggleStatus();
                        if (toggleStatus != null) {
                            action.putValue("Check", (Object)Boolean.TRUE);
                            action.putValue("State", (Object)toggleStatus);
                        }
                        actions.add(action);
                    }
                    catch (ClassNotFoundException cnfe) {
                        this._logger.severe("Unable to init lazy status, could not load resource class. " + cnfe.getMessage());
                    }
                    continue;
                }
                action = IdeAction.get((int)commandIdeId, (String)className, (String)op.getLabel(), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)new Integer(op.getMnemonic()), null, null, (boolean)true);
                toggleStatus = op.getToggleStatus();
                if (toggleStatus != null) {
                    action.putValue("Check", (Object)Boolean.TRUE);
                    action.putValue("State", (Object)toggleStatus);
                }
                actions.add(action);
            }
            if (this._profile.getPendingChanges() != null) {
                IdeAction action = ViewPendingChangesAction.getAction(this, this._profile.getPendingChanges().getMenuLabel());
                actions.add(action);
                this._actionInfos.put(Ide.findCmdName((int)action.getCommandId()), new VCSActionInfo(){

                    @Override
                    public VCSCommandStyle getStyle() {
                        return VCSCommandStyle.NORMAL;
                    }

                    @Override
                    public VCSCommandType getType() {
                        return VCSCommandType.BOTH;
                    }

                    @Override
                    public Boolean getToggleStatus() {
                        return null;
                    }

                    @Override
                    public boolean requirementsSatisfied(Context context) {
                        return true;
                    }

                    @Override
                    public Collection getFilteredSelection(Context context) {
                        return Collections.EMPTY_SET;
                    }

                    @Override
                    public boolean isChangeListAction() {
                        return false;
                    }

                    @Override
                    public String getDialogTitle() {
                        return null;
                    }

                    @Override
                    public String getDialogHint() {
                        return null;
                    }

                    @Override
                    public String getHelpTopicId() {
                        return null;
                    }
                });
            }
            return actions.toArray(new IdeAction[actions.size()]);
        }
        return new IdeAction[0];
    }

    private void activateMenus() {
        SectionsInfo menuInfo = null;
        menuInfo = this._profile.getMenus().getMenu("oracle.jdeveloper.vcs.menus.VERSIONING_MENU");
        if (menuInfo != null) {
            this.installVersioningMenuItems(menuInfo.getSections());
        } else {
            this._logger.fine("no main versioning menu items found");
        }
        menuInfo = this._profile.getMenus().getMenu("oracle.jdeveloper.vcs.menus.COMPARE_MENU");
        if (menuInfo != null) {
            this.installCompareMenuItems(menuInfo.getSections());
        } else {
            this._logger.fine("no compare menu items found");
        }
        menuInfo = this._profile.getMenus().getMenu("oracle.jdeveloper.vcs.menus.REPLACE_MENU");
        if (menuInfo != null) {
            this.installReplaceWithMenuItems(menuInfo.getSections());
        } else {
            this._logger.fine("no replace-with menu items found");
        }
        if (this._contextMenuListener == null) {
            this._contextMenuListener = new GenericContextMenuListener(this, this._profile, this._logger);
        }
        VCSMenuUtils.installContextMenuListener(this._contextMenuListener);
    }

    private void installCompareMenuItems(Collection menuSections) {
        for (SectionInfo section : menuSections) {
            for (String actionRef : section.getActionRefs()) {
                Integer cmdId = Ide.findCmdID((String)actionRef);
                if (cmdId == null) {
                    this._logger.warning("unsatisfied action reference: " + actionRef);
                    continue;
                }
                VCSMenuUtils.installCompareMenuItem(cmdId, this.getId());
            }
        }
    }

    private void installReplaceWithMenuItems(Collection menuSections) {
        for (SectionInfo section : menuSections) {
            for (String actionRef : section.getActionRefs()) {
                Integer cmdId = Ide.findCmdID((String)actionRef);
                if (cmdId == null) {
                    this._logger.warning("unsatisfied action reference: " + actionRef);
                    continue;
                }
                VCSMenuUtils.installReplaceMenuItem(cmdId, this.getId());
            }
        }
    }

    private void installVersioningMenuItems(Collection menuSections) {
        JMenu menu = VCSMenuUtils.installMainSystemMenu(this.getId(), this.getInformation());
        float sectionIdentifier = 1.0f;
        for (SectionInfo section : menuSections) {
            for (String actionRef : section.getActionRefs()) {
                ActionInfo referencedOp = this._profile.getActions().getAction(actionRef);
                if (referencedOp == null) {
                    this._logger.warning("unsatisfied action reference in menu declarations: " + actionRef);
                    continue;
                }
                Integer cmdId = Ide.findCmdID((String)referencedOp.getID());
                if (cmdId == null) {
                    this._logger.warning("unrecognized operation in menu declarations: " + actionRef);
                    continue;
                }
                VCSMenuUtils.addMenuItem(menu, (int)cmdId, sectionIdentifier);
            }
            sectionIdentifier += 1.0f;
        }
        if (this._profile.getPendingChanges() != null) {
            this.installPendingChangesMenuItem(menu);
        }
    }

    private void installPendingChangesMenuItem(JMenu menu) {
        VCSMenuUtils.addMenuItem(menu, ViewPendingChangesAction.getCommandId(this), 99.7f);
        StringBuilder sb = new StringBuilder(Resource.get("VIEW_PENDING_CHANGES_ACTION"));
        sb.append(" (");
        sb.append(this.getInformation().getShortLabel());
        sb.append(")");
        VCSMenuUtils.addMenuItemToTeamMenu(ViewPendingChangesAction.getCommandId(this), sb.toString(), 102.0f);
    }

    private void activateEventBusComponents() {
        EventBusInfo ebi = this._profile.getEventBus();
        if (ebi == null) {
            return;
        }
        VCSSingleNodeObserver nodeObserver = ebi.getNodeObserver();
        if (nodeObserver != null) {
            nodeObserver.setSystemId(this.getId());
            nodeObserver.setStatusCache(this.getStatusCache());
            nodeObserver.setURLFilter(this.getURLFilter());
            VCSEventBus.addToBus(nodeObserver);
        }
        Iterator it = ebi.getComponents().iterator();
        while (it.hasNext()) {
            VCSEventBus.addToBus((VCSEBComponent)it.next());
        }
    }

    private void activatePendingChanges(PendingChangesInfo info) throws ClassNotFoundException {
        this._changeListsById.clear();
        this._changeListInfosById.clear();
        this._changeLists = null;
        new GenericChangeListDockableFactory(ChangeListViewId.getViewId(this), StatusBasedChangeListWindow.class.getName(), this);
    }

    private void manageOverlayTracker() {
        boolean useLabeldecorations;
        VCSPropertyMap commonPrefs = this.getData("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
        Boolean b = (Boolean)commonPrefs.getMap().get("useOverlays");
        boolean useOverlays = b != null ? b.booleanValue() : VCSPropertyKey.DEFAULT_USE_OVERLAYS.booleanValue();
        b = (Boolean)commonPrefs.getMap().get("useLabelDecorations");
        boolean bl = useLabeldecorations = b != null ? b.booleanValue() : VCSPropertyKey.DEFAULT_USE_LABEL_DECORATIONS.booleanValue();
        if (this._overlayTracker != null) {
            if (this._controller == null || !useOverlays && !useLabeldecorations) {
                this._overlayTracker.stopTracking();
                this._overlayTracker = null;
            }
            return;
        }
        VCSStatusCache statusCache = this.getStatusCache();
        if (this._controller != null && (useOverlays || useLabeldecorations) && statusCache != null) {
            this._overlayTracker = VCSDefaultUtils.createNodeOverlayTracker(10, this._overlayProducer, this.getURLFilter(), this.getId());
        }
    }

    private ProfileListener createProfileListener() throws ClassNotFoundException {
        try {
            Class theClass = this._profile.getListenerClass();
            return (ProfileListener)theClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            this._logger.severe("unable to load profile listener class.");
            throw cnfe;
        }
        catch (Exception e) {
            this._logger.severe("error instantiating profile listener class: " + e.getClass().getName() + ": " + e.getMessage());
            return null;
        }
    }

    private StatusResolver createStatusResolver() throws ClassNotFoundException {
        try {
            Class theClass = this._profile.getFileSystem().getStatuses().getResolverClass();
            return (StatusResolver)theClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            this._logger.severe("unable to load status resolver class.");
            throw cnfe;
        }
        catch (Exception e) {
            this._logger.severe("error instantiating status resolver class: " + e.getClass().getName() + ": " + e.getMessage());
            return null;
        }
    }

    private VCSOverlayItemProducer createOverlayProducer() {
        try {
            return VCSGenericUtil.newOverlayProducer(this, this._profile.getFileSystem().getStatuses().getOverlayProducerClass());
        }
        catch (ClassNotFoundException cnfe) {
            this._logger.warning("could not find overlay producer class. using a default instance");
            return new VCSOverlayItemProducer(this.getStatusCache());
        }
    }

    private Handler createDefaultLogHandler() {
        final SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS z dd.MM.yy");
        Formatter formatter = new Formatter(){

            @Override
            public String format(LogRecord r) {
                StringBuilder buff = new StringBuilder(100);
                buff.append('[');
                buff.append(df.format(new Date(r.getMillis())));
                buff.append("] ").append(r.getMessage()).append("\n");
                return buff.toString();
            }
        };
        try {
            FileHandler handler = new FileHandler(URLFileSystem.getPlatformPathName((URL)URLFactory.newURL((URL)this.getSystemDirectory(), (String)"vcs.log")));
            handler.setFormatter(formatter);
            handler.setLevel(Level.ALL);
            return handler;
        }
        catch (IOException ioe) {
            Logger.getLogger("").log(Level.SEVERE, "unable to use default vcs log file", ioe);
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(formatter);
            handler.setLevel(Level.ALL);
            return handler;
        }
    }

    private void fireProfileInitialized() {
        if (this._profileListener != null) {
            this._profileListener.profileInitialized(this);
        }
    }

    private boolean fireCanActivate() {
        if (this._profileListener != null) {
            return this._profileListener.canActivate(this);
        }
        return true;
    }

    private void fireProfileActivated() {
        if (this._profileListener != null) {
            this._profileListener.profileActivated(this);
        }
    }

    private void fireProfileDestroyed() {
        if (this._profileListener != null) {
            this._profileListener.profileDestroyed(this);
        }
    }

    private final class ClientChangeListener
    implements ChangeListener {
        private ClientChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            GenericClient.this.manageOverlayTracker();
        }
    }

    private static final class ActionInfoImpl
    extends VCSActionInfoImpl {
        private final ActionInfo _actionInfo;

        private ActionInfoImpl(VCSProfile profile, ActionInfo info) {
            super(profile, info);
            this._actionInfo = info;
        }

        private ActionInfoImpl(VCSProfile profile, ActionInfo info, Collection changeListInfos) {
            super(profile, info, changeListInfos);
            this._actionInfo = info;
        }

        @Override
        public String getDialogTitle() {
            return this._actionInfo.getDialogTitle();
        }

        @Override
        public String getDialogHint() {
            return this._actionInfo.getDialogHint();
        }

        @Override
        public String getHelpTopicId() {
            return this._actionInfo.getHelpTopicId();
        }
    }
}

