/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.changeset;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.Assert;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSRegistry;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetException;
import oracle.jdeveloper.vcs.changeset.ChangeSetRegistry;
import oracle.jdeveloper.vcs.changeset.ChangeSetUpdate;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCacheEvent;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCacheListener;

public final class ChangeSetService
implements Addin {
    private final List<ServiceEvent> _queue = new LinkedList<ServiceEvent>();
    private final Object _mutex = new Object();
    private boolean _alive = false;
    private int _count = 0;
    private Thread _thread;

    public static final ChangeSetService getInstance() {
        return (ChangeSetService)AddinManager.getAddinManager().getAddin(ChangeSetService.class);
    }

    public final Object getQueueMutex() {
        return this._mutex;
    }

    public final boolean isQueueBusy() {
        return this._count > 0;
    }

    public final void initialize() {
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public final void addinsLoaded(IdeEvent e) {
                for (final String id : VCSRegistry.keySet()) {
                    VCSStatusCache cache;
                    VCS vcs = VCSRegistry.lookup((String)id);
                    if (!(vcs instanceof VCSExtension) || (cache = ((VCSExtension)vcs).getStatusCache()) == null) continue;
                    cache.addCacheListener(new VCSURLBasedCacheListener(){

                        @Override
                        public final void valuesCleared(VCSURLBasedCacheEvent e) {
                            if (!ChangeSetService.this.isAlive()) {
                                return;
                            }
                            if (!e.isInvalidate()) {
                                ChangeSetService.this.enqueue(new ServiceEvent(e.getURLs(), id));
                            }
                        }

                        @Override
                        public void valueRecached(VCSURLBasedCacheEvent e) {
                            if (!ChangeSetService.this.isAlive()) {
                                return;
                            }
                            ChangeSetService.this.enqueue(new ServiceEvent(new URL[]{e.getNewURL()}, id));
                        }
                    });
                }
                ChangeSetService.this.start();
                Ide.removeIdeListener((IdeListener)this);
            }

            public final void mainWindowOpened(IdeEvent e) {
            }

            public final void mainWindowClosing(IdeEvent e) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void start() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    ChangeSetService.this.eventLoop();
                }
                catch (InterruptedException ie) {
                    Assert.printStackTrace((Throwable)ie);
                }
                ChangeSetService.this._alive = false;
            }
        };
        ChangeSetService changeSetService = this;
        synchronized (changeSetService) {
            this._thread = new Thread(r, "ChangeSetService");
            this._thread.setPriority(1);
            this._alive = true;
            this._thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stop() {
        ChangeSetService changeSetService = this;
        synchronized (changeSetService) {
            this.setAlive(false);
            this._thread = null;
        }
    }

    private synchronized void enqueue(ServiceEvent se) {
        this._queue.add(se);
        ++this._count;
        this.notifyAll();
    }

    private synchronized void awaitEvents() throws InterruptedException {
        while (this.isEmpty() && this.isAlive()) {
            this.wait();
        }
    }

    private synchronized ServiceEvent dequeue() {
        ServiceEvent se = this._queue.remove(0);
        this.notifyAll();
        return se;
    }

    private synchronized boolean isEmpty() {
        return this._queue.isEmpty();
    }

    private void eventLoop() throws InterruptedException {
        while (true) {
            this.awaitEvents();
            if (!this.isAlive()) {
                return;
            }
            Thread.sleep(500L);
            this.processEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents() throws InterruptedException {
        while (!this.isEmpty()) {
            if (!this.isAlive()) {
                return;
            }
            ServiceEvent se = this.dequeue();
            try {
                this.processEvent(se);
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            --this._count;
        }
        Object object = this._mutex;
        synchronized (object) {
            this._mutex.notifyAll();
        }
    }

    protected void processEvent(ServiceEvent se) throws Exception {
        if (se.getRunnable() != null) {
            se.getRunnable().run();
            return;
        }
        VCS vcs = VCSRegistry.lookup((String)se.getSystemId());
        if (!(vcs instanceof VCSExtension)) {
            return;
        }
        ChangeSetAdapter adapter = ChangeSetRegistry.lookup(se.getSystemId());
        if (adapter == null) {
            return;
        }
        if (se.getURLs().length == 0) {
            return;
        }
        VCSStatus[] statuses = ((VCSExtension)vcs).getStatus(se.getURLs());
        ArrayList<URL> changedUrls = new ArrayList<URL>();
        ArrayList<URL> unchangedUrls = new ArrayList<URL>();
        for (int i = 0; i < se.getURLs().length; ++i) {
            if (adapter.isChanged(statuses[i])) {
                changedUrls.add(se.getURLs()[i]);
                continue;
            }
            unchangedUrls.add(se.getURLs()[i]);
        }
        if (!changedUrls.isEmpty()) {
            VCSEventBus.send(new ChangeSetUpdate(se.getSystemId(), changedUrls.toArray(new URL[changedUrls.size()]), ChangeSetUpdate.PENDING));
        }
        if (!unchangedUrls.isEmpty()) {
            VCSEventBus.send(new ChangeSetUpdate(se.getSystemId(), unchangedUrls.toArray(new URL[unchangedUrls.size()]), ChangeSetUpdate.COMMITTED));
        }
    }

    private synchronized void setAlive(boolean isAlive) {
        this._alive = isAlive;
        this.notifyAll();
    }

    private final boolean isAlive() {
        return this._alive;
    }

    public final void fireChangesCommitted(final String vcsId, final URL[] urls, final boolean recursive) {
        Runnable r = new Runnable(){

            @Override
            public final void run() {
                VCS vcs = VCSRegistry.lookup((String)vcsId);
                if (!(vcs instanceof VCSExtension)) {
                    return;
                }
                VCSStatusCache cache = ((VCSExtension)vcs).getStatusCache();
                if (cache == null) {
                    return;
                }
                ChangeSetAdapter adapter = ChangeSetRegistry.lookup(vcsId);
                if (adapter == null) {
                    return;
                }
                try {
                    Map<String, Collection<VCSHashURL>> changesets = adapter.getChangeSets(urls, recursive);
                    ArrayList<URL> urls0 = new ArrayList<URL>();
                    for (Map.Entry<String, Collection<VCSHashURL>> entry : changesets.entrySet()) {
                        urls0.addAll(VCSHashURL.convertToURLs(entry.getValue()));
                    }
                    VCSStatus[] statuses = ((VCSExtension)vcs).getStatus(urls0.toArray(new URL[urls0.size()]));
                    ArrayList urls1 = new ArrayList();
                    for (int i = 0; i < urls0.size(); ++i) {
                        if (adapter.isChanged(statuses[i])) continue;
                        urls1.add(urls0.get(i));
                    }
                    if (urls1.isEmpty()) {
                        return;
                    }
                    VCSEventBus.send(new ChangeSetUpdate(vcsId, urls1.toArray(new URL[urls1.size()]), ChangeSetUpdate.COMMITTED));
                }
                catch (ChangeSetException cse) {
                    FeedbackManager.reportException((Throwable)cse);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.isAlive()) {
            this.enqueue(new ServiceEvent(r));
        } else {
            Thread thread = new Thread(r, "ChangeSetService Commit");
            thread.setPriority(1);
            thread.start();
        }
    }

    private class ServiceEvent {
        private final URL[] _urls;
        private final String _systemId;
        private final Runnable _r;

        ServiceEvent(URL[] urls, String systemId) {
            this._urls = urls;
            this._systemId = systemId;
            this._r = null;
        }

        ServiceEvent(Runnable r) {
            this._urls = null;
            this._systemId = null;
            this._r = r;
        }

        final URL[] getURLs() {
            return this._urls;
        }

        final String getSystemId() {
            return this._systemId;
        }

        final Runnable getRunnable() {
            return this._r;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ServiceEvent: ");
            sb.append(this._systemId);
            sb.append(": ");
            if (this._r != null) {
                sb.append("(runnable) ");
            }
            if (this._urls != null) {
                sb.append(Arrays.asList(this._urls).toString());
            }
            return sb.toString();
        }
    }
}

