/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.Version;
import oracle.ide.composite.AbstractCompositeFileElementProxy;
import oracle.ide.composite.CompositeFileElementProxy;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.DTCache;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSEvent;
import oracle.ide.vcs.VCSListener;
import oracle.ide.vcs.VCSManager;
import oracle.ide.vcs.VCSRegistry;
import oracle.ide.vcs.VCSTask;
import oracle.ideimpl.vcs.VCSUtil;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Log;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.history.CustomFilterSubstitution;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.patch.ApplyPatchCommand;
import oracle.jdeveloper.vcs.patch.CreatePatchCommand;
import oracle.jdeveloper.vcs.patch.PatchController;
import oracle.jdeveloper.vcs.properties.PropertiesCommand;
import oracle.jdeveloper.vcs.properties.PropertiesController;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdeveloper.vcs.properties.PropertiesPanelRegistry;
import oracle.jdeveloper.vcs.properties.VersionPropertiesPanelProvider;
import oracle.jdeveloper.vcs.share.ShareApplicationCommand;
import oracle.jdeveloper.vcs.share.ShareController;
import oracle.jdeveloper.vcs.share.ShareProjectCommand;
import oracle.jdeveloper.vcs.spi.VCSContextMenuListener;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.spi.VCSHistoryProvider;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.spi.VCSNodeUpdate;
import oracle.jdeveloper.vcs.spi.VCSProgress;
import oracle.jdeveloper.vcs.spi.VCSPropertyDescriptor;
import oracle.jdeveloper.vcs.spi.VCSPropertyKey;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSURLFileSystemHelper;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSIdeEventRecorder;
import oracle.jdeveloper.vcs.util.VCSKeyboardUtils;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryAddin;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryCommand;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryNode;
import oracle.jdevimpl.vcs.cmd.ConfigureVersioningCommand;
import oracle.jdevimpl.vcs.util.GeneralPropertiesPanel;

public final class VCSManagerImpl
extends VCSManager
implements Addin {
    public static final float VERSIONING_MENU_WEIGHT = MenuConstants.WEIGHT_ADDITIONAL_MENU;
    public static final String VCS_EXTENSION_ID = "oracle.jdeveloper.vcs";
    private static final String ACCELERATOR_FILE = "oracle/jdevimpl/vcs/accelerators.xml";
    private Map<VCSListener, URLFilter> _vcsListeners = new LinkedHashMap<VCSListener, URLFilter>();
    private CompositeFileElementProxy _compositeFileElementProxy;
    private Collection<ContextMenuListener> _contextMenuListeners = new ArrayList<ContextMenuListener>();
    private ExecutorService _executor;
    private static final Log LOG = new Log("vcs");
    private static DTCache _dtcache;

    public final void initialize() {
        VCSManager.setVCSManager((VCSManager)this);
        VCSIdeEventRecorder.initialize();
        this.registerWorkspaceArtifact("mds/");
        VCSFileEventSender.setFileEventSender(new VCSFileEventSender(){

            @Override
            protected void fireVCSEvent(URL[] urls, int eventType) {
                VCSManagerImpl.this._fireVCSEvent(urls, eventType);
            }
        });
        this.initializeVersioningProperties();
        if (Ide.getIdeArgs().getCreateUI()) {
            this.registerPatchSupportHandlers();
            this.registerPropertiesHandlers();
            EditorManager.getEditorManager().register((EditorAddin)new VersionHistoryAddin(), new Class[]{VersionHistoryNode.class});
        }
        Node.addNodeListenerForTypeHierarchy(Node.class, (NodeListener)new NodeListener(){

            public void nodeSaved(NodeEvent ne) {
                VCSManagerImpl.this.fireNodeSaved(ne.getNode());
            }

            public void nodeReverted(NodeEvent ne) {
                VCSManagerImpl.this.fireNodeReloaded(ne.getNode());
            }

            public void nodeRenamed(NodeEvent ne, URL oldURL, URL newURL) {
                VCSManagerImpl.this.fireNodeRenamed(ne.getNode(), oldURL);
            }
        });
        if (Ide.getIdeArgs().getCreateUI()) {
            Ide.addIdeListener((IdeListener)new IdeAdapter(){

                public final void addinsLoaded(IdeEvent idee) {
                    IdeAction[] actions = new IdeAction[]{IdeAction.find((int)CreatePatchCommand.CREATE_PATCH_CMD_ID), IdeAction.find((int)ApplyPatchCommand.APPLY_PATCH_CMD_ID)};
                    VCSKeyboardUtils.addKeyStrokeContext(actions, "Versioning-Patch");
                    VCSKeyboardUtils.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), VCSManagerImpl.ACCELERATOR_FILE);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public final void run() {
                            IdeActions.getFileSaveAction().addController(new Controller(){

                                public boolean handleEvent(IdeAction action, Context context) {
                                    return !this.canSave(context);
                                }

                                private boolean canSave(Context context) {
                                    URL url = VCSModelUtils.getLocatableURL(context.getNode());
                                    return url == null || context.getNode() instanceof TextNode || !VCSManagerImpl.this.containsConflicts(url);
                                }

                                public boolean update(IdeAction action, Context context) {
                                    if (!this.canSave(context)) {
                                        action.setEnabled(false);
                                        return true;
                                    }
                                    return false;
                                }
                            });
                        }
                    });
                    Ide.removeIdeListener((IdeListener)this);
                }
            });
        }
        Node.addNodeListenerForTypeHierarchy(Project.class, (NodeListener)new NodeListener(){

            public void nodeOpened(NodeEvent ne) {
                Project project = (Project)ne.getNode();
                VCSListenerImpl l = new VCSListenerImpl(project);
                project.getTransientProperties().put("VCSListener", l);
                VCSManagerImpl.this.addVCSListener(l, null);
            }

            public void nodeClosed(NodeEvent ne) {
                Project project = (Project)ne.getNode();
                VCSListener l = (VCSListener)project.getTransientProperties().remove("VCSListener");
                VCSManagerImpl.this.removeVCSListener(l);
            }
        });
        this._compositeFileElementProxy = new AbstractCompositeFileElementProxy(null){

            public Class getCompositeElementClass() {
                return RelativeDirectoryContextFolder.class;
            }

            public URL[] getCompositeFileURLs(Element compositeElement) {
                URL locatableUrl;
                RelativeDirectoryContextFolder directoryContextFolder = (RelativeDirectoryContextFolder)compositeElement;
                URLPath rootDirectoryPath = directoryContextFolder.getRootDirectories();
                String relativePath = directoryContextFolder.getRelativePath();
                URL uRL = locatableUrl = compositeElement instanceof Locatable ? ((Locatable)compositeElement).getURL() : null;
                if (relativePath == null) {
                    URL[] uRLArray;
                    if (locatableUrl != null) {
                        URL[] uRLArray2 = new URL[1];
                        uRLArray = uRLArray2;
                        uRLArray2[0] = locatableUrl;
                    } else {
                        uRLArray = new URL[]{};
                    }
                    return uRLArray;
                }
                URL[] urls = new URL[rootDirectoryPath.size()];
                int i = 0;
                Iterator itr = rootDirectoryPath.iterator();
                while (itr.hasNext()) {
                    urls[i++] = URLFactory.newDirURL((URL)((URL)itr.next()), (String)relativePath);
                }
                return urls;
            }
        };
        CompositeFileElementRegistry.registerCompositeProxy((CompositeFileElementProxy)this._compositeFileElementProxy);
        if (Ide.getIdeArgs().getCreateUI()) {
            JMenu versioningMenu = Ide.getMenubar().createMenu(VCSArb.getString(0), VERSIONING_MENU_WEIGHT);
            MenuManager.putJMenu((String)"Versioning", (JMenu)versioningMenu);
            Ide.getMenubar().add((Component)versioningMenu);
        }
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public void addinsLoaded(IdeEvent idee) {
                ArrayList<JMenuItem> solverMenuItems = null;
                if (Ide.getIdeArgs().getCreateUI()) {
                    IdeAction configureAction = IdeAction.get((int)ConfigureVersioningCommand.CONFIGURE_VERSIONING_CMD_ID, (String)ConfigureVersioningCommand.CONFIGURE_VERSIONING_CMD, (String)VCSArb.getString(258));
                    solverMenuItems = new ArrayList<JMenuItem>();
                    solverMenuItems.add(VCSMenuUtils.addMenuItem(VCSMenuUtils.getMainVersioningMenu(), configureAction.getCommandId(), 99.9f));
                    solverMenuItems.add(VCSMenuUtils.addMenuItem(VCSMenuUtils.getMainVersioningMenu(), CreatePatchCommand.CREATE_PATCH_CMD_ID, 100.0f));
                    solverMenuItems.add(VCSMenuUtils.addMenuItem(VCSMenuUtils.getMainVersioningMenu(), ApplyPatchCommand.APPLY_PATCH_CMD_ID, 100.0f));
                }
                for (String id : VCSRegistry.keySet()) {
                    VCS vcs = VCSRegistry.lookup((String)id);
                    if (!(vcs instanceof VCSExtension)) continue;
                    VCSExtension extension = (VCSExtension)vcs;
                    try {
                        if (!extension.canActivate()) {
                            LOG.trace("VCSExtension.canActivate() failure: " + extension.getId());
                            continue;
                        }
                        long t1 = System.currentTimeMillis();
                        extension.activate();
                        JMenu menu = null;
                        if (Ide.getIdeArgs().getCreateUI() && (menu = MenuManager.getJMenu((String)("Versioning." + extension.getId()))) != null && menu != VCSMenuUtils.getMainVersioningMenu()) {
                            solverMenuItems.add(menu);
                        }
                        this.installVersionHistory(extension, menu);
                    }
                    catch (Exception e) {
                        extension.getExceptionHandler().handleException(e);
                    }
                }
                if (Ide.getIdeArgs().getCreateUI()) {
                    float SECTION_SHARE = -0.01f;
                    JMenuItem menuItem = null;
                    if (!Product.isRaptor()) {
                        menuItem = VCSMenuUtils.addMenuItem(VCSMenuUtils.getMainVersioningMenu(), (ToggleAction)ShareApplicationCommand.getShareApplicationAction(), SECTION_SHARE);
                        menuItem.setMnemonic(0);
                        solverMenuItems.add(menuItem);
                    }
                    if (!solverMenuItems.isEmpty()) {
                        VCSManagerImpl.this.solveMnemonics(VCSMenuUtils.getMainVersioningMenu(), null, solverMenuItems.toArray(new JMenuItem[0]));
                    }
                }
                VCSControlCache.getInstance().fireControlStateChanged(null);
                Ide.removeIdeListener((IdeListener)this);
            }

            private void installVersionHistory(VCSExtension extension, JMenu menu) {
                VCSHistoryProvider historyProvider = extension.getHistoryProvider();
                HistoryManager historyManager = HistoryManager.getHistoryManager();
                if (historyProvider == null || historyManager == null) {
                    return;
                }
                if (historyProvider.getHistoryProvider() != null) {
                    historyManager.registerProvider(historyProvider.getHistoryProvider());
                }
                if (historyProvider.getVersioningUserSubstitution() != null) {
                    historyManager.getCustomFilterManager().registerSubstitution((CustomFilterSubstitution)historyProvider.getVersioningUserSubstitution());
                }
                if (menu == null) {
                    return;
                }
                if (historyProvider.getVersionHistoryAction() != null) {
                    IdeAction versionHistoryAction = historyProvider.getVersionHistoryAction();
                    VCSMenuUtils.installVersionHistoryMenuItem(menu, versionHistoryAction != null ? versionHistoryAction.getCommandId() : VersionHistoryCommand.VERSION_HISTORY_CMD_ID);
                }
                if (historyProvider.getVersionTreeAction() != null) {
                    IdeAction versionTreeAction = historyProvider.getVersionTreeAction();
                    VCSMenuUtils.installVersionHistoryMenuItem(menu, versionTreeAction.getCommandId());
                }
            }
        });
        if (Ide.getIdeArgs().getCreateUI()) {
            IdeAction.find((int)51).addController(new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    if (action.getCommandId() == 51) {
                        VCSControlCache.getInstance().fireControlStateChanged(null);
                    }
                    return false;
                }

                public boolean update(IdeAction action, Context context) {
                    return false;
                }
            });
            VCSMenuUtils.installContextMenuListener(new VCSContextMenuListener(null){

                @Override
                protected Component[] getContextMenuItems(Context context) {
                    if (Product.isRaptor()) {
                        return null;
                    }
                    if (context.getNode() instanceof Workspace) {
                        Component[] componentArray;
                        IdeAction action = ShareApplicationCommand.getShareApplicationAction();
                        action.updateAction(context);
                        if (action.isEnabled()) {
                            Component[] componentArray2 = new Component[1];
                            componentArray = componentArray2;
                            componentArray2[0] = VCSMenuUtils.createMenuItem(action.getCommandId(), 1000.0f);
                        } else {
                            componentArray = null;
                        }
                        return componentArray;
                    }
                    if (context.getNode() instanceof Project) {
                        IdeAction action = ShareProjectCommand.getShareProjectAction();
                        action.updateAction(context);
                        if (!action.isEnabled()) {
                            return null;
                        }
                        JMenuItem menuItem = VCSMenuUtils.createMenuItem(action.getCommandId(), 1000.0f);
                        return new Component[]{menuItem};
                    }
                    return null;
                }

                @Override
                protected float getSection() {
                    return 1.0f;
                }
            });
            IdeAction versionApplicationAction = IdeAction.get((int)Ide.createCmdID((String)"VCS.VERSION_APPLICATION_CMD"), (String)ShareApplicationCommand.getShareApplicationAction().getCommand(), (String)StringUtils.stripMnemonic((String)VCSArb.getString(256)), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)VCSArb.getString(256))), (ResourceBundle)VCSArb.getInstance(), null, null, (boolean)true);
            versionApplicationAction.putValue("NoCtxName", (Object)VCSArb.getString(257));
            versionApplicationAction.addController((Controller)new ShareController());
            VCSKeyboardUtils.addKeyStrokeContext(new IdeAction[]{versionApplicationAction}, "Versioning-Version-Application");
            Ide.getVersionInfo().addComponent(VCSArb.getString(25), Version.VER_FULL);
        }
    }

    private void solveMnemonics(JMenu menu, JMenuItem[] fixedItems, JMenuItem[] solveItems) {
        if (solveItems == null) {
            for (int i = 0; i < menu.getItemCount(); ++i) {
                if (fixedItems != null && Arrays.asList(fixedItems).contains(menu.getItem(i))) continue;
                menu.getItem(i).setMnemonic(0);
            }
        } else {
            for (JMenuItem menuItem : solveItems) {
                menuItem.setMnemonic(0);
            }
        }
        MnemonicSolver mnemonicSolver = new MnemonicSolver();
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem menuItem = menu.getItem(i);
            if (menuItem.getMnemonic() != 0) {
                mnemonicSolver.addMenuLabel(menuItem, menuItem.getText(), true);
                continue;
            }
            if (solveItems != null && !Arrays.asList(solveItems).contains(menuItem)) continue;
            mnemonicSolver.addMenuLabel(menuItem, menuItem.getText(), false);
        }
        mnemonicSolver.solve();
    }

    private void initializeVersioningProperties() {
        HashMap propertiesMap;
        VCSPropertyMap properties = (VCSPropertyMap)ClientSetting.findOrCreate((String)VCS_EXTENSION_ID).getData("VersioningSettings");
        HashMap defaultsMap = null;
        HashMap hashMap = propertiesMap = defaultsMap != null ? defaultsMap : new HashMap();
        if (properties != null) {
            propertiesMap.putAll(properties.getMap());
        } else {
            properties = new VCSPropertyMap();
        }
        properties.setMap(propertiesMap);
        ClientSetting.findOrCreate((String)VCS_EXTENSION_ID).putData("VersioningSettings", properties);
    }

    public final Future<Boolean> checkOutUsingUI(VCSTask task) {
        this.getTaskProperties(task).put("operation", "checkout");
        if (!Ide.getIdeArgs().getCreateUI()) {
            return this.executeConfirmedTask(task);
        }
        if (!EventQueue.isDispatchThread()) {
            new IllegalStateException("checkOutUsingUI() called from non-event thread").printStackTrace();
        }
        ArrayList<URL> readOnlyUrls = new ArrayList<URL>();
        for (URL url : task.getURLs()) {
            if (url == null) {
                return this.executeNoOpTask(task);
            }
            if (!URLFileSystem.isReadOnly((URL)url)) continue;
            readOnlyUrls.add(url);
        }
        for (URL url : readOnlyUrls) {
            if (this.canCheckOut(url)) continue;
            return this.executeNoOpTask(task);
        }
        Map<VCSExtension, Collection<URL>> urlMap = this.organizeURLsByExtension(readOnlyUrls.toArray(new URL[0]));
        assert (!urlMap.containsKey(null));
        ArrayList<URL> confirmationUrls = new ArrayList<URL>();
        for (Map.Entry<VCSExtension, Collection<URL>> entry : urlMap.entrySet()) {
            if (VCSManagerImpl.isAutoCheckoutsSet(entry.getKey())) continue;
            confirmationUrls.addAll(entry.getValue());
        }
        if (!VCSManagerImpl.confirmCheckOutUI(confirmationUrls)) {
            return this.executeCancelledTask(task);
        }
        return this.executeConfirmedTask(task);
    }

    private final Future<Boolean> executeNoOpTask(VCSTask task) {
        this.getTaskProperties(task).put("noop", true);
        this.getExecutor().submit((Runnable)task);
        return task;
    }

    private final Future<Boolean> executeConfirmedTask(VCSTask task) {
        this.getTaskProperties(task).put("confirmed", true);
        this.getExecutor().submit((Runnable)task);
        return task;
    }

    private final Future<Boolean> executeCancelledTask(VCSTask task) {
        this.getTaskProperties(task).put("cancelled", true);
        this.getExecutor().submit((Runnable)task);
        return task;
    }

    public static final boolean confirmCheckOutUI(Collection<URL> confirmationUrls) {
        if (confirmationUrls.size() == 1) {
            String message = VCSArb.format(293, URLFileSystem.getPlatformPathName((URL)confirmationUrls.iterator().next()));
            return MessageDialog.confirm((Component)VCSWindowUtils.getCurrentWindow(), (Object)message, (String)VCSArb.getString(295), null, (boolean)false);
        }
        if (confirmationUrls.size() > 1) {
            CheckBoxListModel listModel = VCSComponents.createCheckBoxListModel(VCSModelUtils.findOrCreateNodes(confirmationUrls.toArray(new URL[0])), false);
            CheckOutFilesPanel checkOutFilesPanel = new CheckOutFilesPanel(listModel, VCSArb.getString(294));
            return CheckOutFilesPanel.showDialog(VCSWindowUtils.getCurrentWindow(), VCSArb.getString(295), (Component)((Object)checkOutFilesPanel), null) != 1;
        }
        return true;
    }

    public final boolean checkOut(URL[] urls) {
        VCSTask task = new VCSTask(urls){};
        this.getTaskProperties(task).put("operation", "checkout");
        return this.executeTaskImpl(task);
    }

    protected final boolean executeTaskImpl(VCSTask task) {
        Boolean noOp = (Boolean)this.getTaskProperties(task).get("noop");
        if (noOp != null && noOp.booleanValue()) {
            return false;
        }
        Boolean cancelled = (Boolean)this.getTaskProperties(task).get("cancelled");
        if (cancelled != null && cancelled.booleanValue()) {
            task.cancel(false);
            return false;
        }
        if ("checkout".equals(this.getTaskProperties(task).get("operation"))) {
            ArrayList<URL> readOnlyUrls = new ArrayList<URL>();
            for (URL url : task.getURLs()) {
                if (url == null) {
                    return false;
                }
                if (!URLFileSystem.isReadOnly((URL)url)) continue;
                readOnlyUrls.add(url);
            }
            for (URL url : readOnlyUrls) {
                if (this.canCheckOut(url)) continue;
                return false;
            }
            Boolean confirmed = (Boolean)this.getTaskProperties(task).get("confirmed");
            if (!this._checkOut(readOnlyUrls.toArray(new URL[0]), new ProgressAdapter(task), confirmed != null && confirmed != false)) {
                return false;
            }
            for (URL url : readOnlyUrls) {
                if (!URLFileSystem.isReadOnly((URL)url)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final ExecutorService getExecutor() {
        if (this._executor == null) {
            this._executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
                private final ThreadFactory _delegate = Executors.defaultThreadFactory();

                @Override
                public final Thread newThread(Runnable r) {
                    Thread t = this._delegate.newThread(r);
                    t.setName("VCSManager");
                    return t;
                }
            });
        }
        return this._executor;
    }

    public final boolean canCheckOut(URL url) {
        if (VCSFileSystemUtils.isNonEditable(url)) {
            return false;
        }
        VCSExtension extension = VCSExtensionUtils.getActiveExtension(url);
        if (extension == null) {
            return false;
        }
        try {
            return extension.canCheckOut(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public boolean checkOutNode(Node node) {
        try {
            return this.checkOutUsingUI(new VCSTask(new URL[]{node.getURL()}){}).get();
        }
        catch (CancellationException ce) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public final boolean checkOutNode(Node node, CommandProcessor processor) {
        return VCSUtil.checkOutOnUndoStack((Node)node);
    }

    public final String getCheckOutCommand(Node node) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(node.getURL());
        return vcs != null ? vcs.getCheckOutCommand() : null;
    }

    @Deprecated
    public final boolean setReadWrite(URL[] urls) {
        return this.checkOut(urls);
    }

    private final boolean _checkOut(URL[] urls, ProgressAdapter progress, boolean confirmed) {
        progress.setMaximum(urls.length);
        progress.setCeiling(0);
        Map<VCSExtension, Collection<URL>> urlMap = this.organizeURLsByExtension(urls);
        if (urlMap.containsKey(null)) {
            return false;
        }
        if (!confirmed) {
            for (VCSExtension vCSExtension : urlMap.keySet()) {
                if (VCSManagerImpl.isAutoCheckoutsSet(vCSExtension)) continue;
                return false;
            }
        }
        for (Map.Entry entry : urlMap.entrySet()) {
            try {
                progress.setCeiling(progress.getCeiling() + ((Collection)entry.getValue()).size());
                if (progress.isCancelled()) {
                    return false;
                }
                if (!((VCSExtension)entry.getKey()).setReadWrite(((Collection)entry.getValue()).toArray(new URL[0]), progress)) {
                    return false;
                }
                for (URL url : (Collection)entry.getValue()) {
                    Node node = NodeFactory.find((URL)url);
                    if (node == null) continue;
                    node.isReadOnly();
                }
                progress.setProgress(progress.getCeiling());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        progress.setCeiling(-1);
        progress.setProgress(urls.length);
        return true;
    }

    private final Map<VCSExtension, Collection<URL>> organizeURLsByExtension(URL[] urls) {
        LinkedHashMap<VCSExtension, Collection<URL>> map = new LinkedHashMap<VCSExtension, Collection<URL>>();
        for (URL url : urls) {
            VCSExtension vcs = VCSExtensionUtils.getActiveExtension(url);
            ArrayList<URL> c = (ArrayList<URL>)map.get(vcs);
            if (c == null) {
                c = new ArrayList<URL>();
                map.put(vcs, c);
            }
            c.add(url);
        }
        return map;
    }

    @Deprecated
    public final boolean isAutoCheckOutEnabled(URL url) {
        return VCSManagerImpl.isAutoCheckoutsSet(url);
    }

    public static final boolean isAutoCheckoutsSet(URL url) {
        return VCSManagerImpl.isAutoCheckoutsSet(VCSExtensionUtils.getActiveExtension(url));
    }

    public static final boolean isAutoCheckoutsSet(VCSExtension extension) {
        if (!Ide.getIdeArgs().getCreateUI()) {
            return true;
        }
        if (extension == null) {
            return true;
        }
        VCSPropertyDescriptor propertyDescriptor = extension.getPropertyDescriptor();
        if (propertyDescriptor == null || Arrays.asList(propertyDescriptor.getPropertyKeys()).indexOf("autoCheckouts") < 0) {
            return true;
        }
        String clientSettingsKey = propertyDescriptor.getClientSettingsKey();
        String propertyDataKey = propertyDescriptor.getPropertyDataKey();
        VCSPropertyMap propertyMap = null;
        propertyMap = clientSettingsKey == null ? (VCSPropertyMap)((Object)Ide.getSettings().getData(propertyDataKey)) : (VCSPropertyMap)ClientSetting.findOrCreate((String)clientSettingsKey).getData(propertyDataKey);
        Boolean autoCheckouts = propertyMap != null ? propertyMap.getMap().get("autoCheckouts") : null;
        if (autoCheckouts == null) {
            autoCheckouts = VCSPropertyKey.DEFAULT_AUTO_CHECKOUTS;
        }
        return autoCheckouts;
    }

    public final boolean isVersioned(URL url) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(url);
        if (vcs == null) {
            return false;
        }
        try {
            VCSStatusCache statusCache = vcs.getStatusCache();
            return statusCache != null && statusCache.get(url).isVersioned();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public final void validateStatus(final URL url) {
        this.validateStatus(new URLFilter(){

            public boolean accept(URL url2) {
                return url.equals(url2);
            }
        });
    }

    public final void validateStatus(URLFilter filter) {
        for (String id : VCSRegistry.keySet()) {
            VCSStatusCache statusCache;
            VCS vcs = VCSRegistry.lookup((String)id);
            if (!(vcs instanceof VCSExtension) || (statusCache = ((VCSExtension)vcs).getStatusCache()) == null) continue;
            statusCache.clear(filter);
        }
    }

    public final void addVCSListener(VCSListener listener, URLFilter filter) {
        this._vcsListeners.put(listener, filter);
        if (filter != null) {
            VCSBufferUtils.registerTrackingFilter(filter);
        }
    }

    public final void removeVCSListener(VCSListener listener) {
        URLFilter filter = this._vcsListeners.get(listener);
        this._vcsListeners.remove(listener);
        if (filter != null) {
            VCSBufferUtils.deregisterTrackingFilter(filter);
        }
    }

    public final String getVersionName(URL url) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(url);
        return vcs != null ? vcs.getVersionName(url) : null;
    }

    final Collection<String> getWorkspaceArtifactPaths() {
        return this.getWorkspaceArtifacts();
    }

    public final boolean containsConflicts(URL url) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(url);
        if (vcs != null) {
            return vcs.isConflictsStatus(url);
        }
        return false;
    }

    public final InputStream openConflictsStreamAsContributor(URL url) throws IOException {
        return VCSFileSystemUtils.openConflictsStreamAsContributor(url, StreamDecoder.getDefaultEncoding((URL)url));
    }

    private void fireNodeReloaded(Node node) {
        VCSNodeUpdate nodeUpdate = new VCSNodeUpdate(node, VCSNodeUpdate.RELOADED);
        VCSEventBus.send(nodeUpdate);
    }

    private void fireNodeRenamed(Node node, URL oldUrl) {
        VCSNodeUpdate nodeUpdate = new VCSNodeUpdate(node, VCSNodeUpdate.RENAMED);
        nodeUpdate.setOldURL(oldUrl);
        VCSEventBus.send(nodeUpdate);
    }

    private void fireNodeSaved(Node node) {
        VCSNodeUpdate nodeUpdate = new VCSNodeUpdate(node, VCSNodeUpdate.SAVED);
        VCSEventBus.send(nodeUpdate);
    }

    private void _fireVCSEvent(URL[] urls, int eventType) {
        VCSEvent vcse = new VCSEvent((Object)this, urls, eventType);
        VCSListener[] l = this._vcsListeners.keySet().toArray(new VCSListener[0]);
        block0: for (int i = l.length - 1; i >= 0; --i) {
            URLFilter filter = this._vcsListeners.get(l[i]);
            if (filter == null) {
                if (eventType == 3) continue;
                l[i].notifyEvent(vcse);
                continue;
            }
            for (int j = 0; j < urls.length; ++j) {
                if (!filter.accept(urls[j])) continue;
                l[i].notifyEvent(vcse);
                continue block0;
            }
        }
    }

    private void registerPatchSupportHandlers() {
        IdeAction applyPatchAction = IdeAction.get((int)ApplyPatchCommand.APPLY_PATCH_CMD_ID, (String)ApplyPatchCommand.APPLY_PATCH_CMD, (String)VCSArb.getString(206), (String)VCSArb.getString(0), null, (ResourceBundle)VCSArb.getInstance(), null, null, (boolean)false);
        applyPatchAction.putValue("Category", (Object)VCSMenuConstants.ACTION_CATEGORY_VERSIONING);
        applyPatchAction.putValue("NoCtxName", (Object)VCSArb.getString(145));
        applyPatchAction.addController((Controller)new PatchController());
    }

    private void registerPropertiesHandlers() {
        IdeAction propertiesAction = IdeAction.get((int)PropertiesCommand.PROPERTIES_CMD_ID, (String)PropertiesCommand.PROPERTIES_CMD, (String)VCSArb.getString(144), (String)VCSArb.getString(0), null, (ResourceBundle)VCSArb.getInstance(), null, null, (boolean)false);
        propertiesAction.putValue("Category", (Object)VCSMenuConstants.ACTION_CATEGORY_VERSIONING);
        propertiesAction.putValue("NoCtxName", (Object)VCSArb.getString(145));
        VCSKeyboardUtils.addKeyStrokeContext(new IdeAction[]{propertiesAction}, "Versioning-Properties");
        propertiesAction.addController((Controller)new PropertiesController());
        PropertiesPanelRegistry.registerPanelProvider(new VersionPropertiesPanelProvider(){

            @Override
            public String getTabName() {
                return VCSArb.getString(124);
            }

            @Override
            public float getTabWeight() {
                return Float.MAX_VALUE;
            }

            @Override
            public boolean isDefaultTab() {
                return false;
            }

            @Override
            public boolean isHandled(Context context) {
                if (!super.isHandled(context)) {
                    return false;
                }
                URL url = this.getContextURL(context);
                return url != null && VCSManagerImpl.this.isVersioned(url);
            }

            @Override
            public PropertiesPanel createPanel(Context context) {
                return new GeneralPropertiesPanel(this.getContextElement(context), this.getContextURL(context));
            }
        });
    }

    public void registerContextMenuListener(ContextMenuListener l) {
        this._contextMenuListeners.add(l);
    }

    public void deregisterContextMenuListener(ContextMenuListener l) {
        this._contextMenuListeners.remove(l);
    }

    public ContextMenuListener[] getContextMenuListeners() {
        return this._contextMenuListeners.toArray(new ContextMenuListener[0]);
    }

    public Locatable[] getContextLocatables(Context context) {
        return VCSContextUtils.getContextLocatables(context);
    }

    public void deleteRecursively(URL url, URLFilter filter, boolean tolerant) throws IOException, InterruptedException {
        if (EventQueue.isDispatchThread()) {
            new IllegalStateException("deleteRecursively() called from AWT event thread").printStackTrace();
        }
        URLFileSystemHelper helper = URLFileSystem.findHelper((String)url.getProtocol());
        while (helper instanceof URLFileSystemHelperDecorator) {
            if (!((helper = ((URLFileSystemHelperDecorator)helper).getHelper()) instanceof VCSURLFileSystemHelper)) continue;
            ((VCSURLFileSystemHelper)helper).deleteRecursively(url, filter, tolerant);
            return;
        }
        super.deleteRecursively(url, filter, tolerant);
    }

    public static void _test_SelectNoSystem() {
    }

    public static void _test_SelectSystem(VCS vcs) {
        vcs.toString();
    }

    public static DTCache getDTCache() {
        if (Boolean.getBoolean("ide.vcs.nodtcache")) {
            if (_dtcache == null) {
                _dtcache = new DTCache();
            }
            return _dtcache;
        }
        return Ide.getDTCache();
    }

    private class VCSListenerImpl
    implements VCSListener {
        private final Project _project;

        VCSListenerImpl(Project project) {
            this._project = project;
        }

        public void notifyEvent(VCSEvent event) {
            int eventType = event.getEventType();
            switch (eventType) {
                case 1: {
                    LOG.trace("VCSManager: VCSEvent.FILE_CREATED");
                    ContentSet contents = ProjectContent.getInstance((PropertyStorage)this._project).getAllContents();
                    URL[] addedURLs = event.getURLs();
                    for (int i = 0; i < addedURLs.length; ++i) {
                        if (!contents.canHaveMember(addedURLs[i])) continue;
                        try {
                            Node node = NodeFactory.findOrCreate((URL)addedURLs[i]);
                            this.fireAddedEvent(node);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    break;
                }
                case 2: {
                    LOG.trace("VCSManager: VCSEvent.FILE_DELETED");
                    ContentSet contents = ProjectContent.getInstance((PropertyStorage)this._project).getAllContents();
                    URL[] removedURLs = event.getURLs();
                    for (int i = 0; i < removedURLs.length; ++i) {
                        Node removedNode;
                        if (!contents.canHaveMember(removedURLs[i]) || (removedNode = NodeFactory.find((URL)removedURLs[i])) == null) continue;
                        this.fireRemovedEvent(removedNode);
                    }
                    break;
                }
                case 4: {
                    LOG.trace("VCSManager: VCSEvent.FILE_STRUCTURE_CHANGED");
                    ContentSet contents = ProjectContent.getInstance((PropertyStorage)this._project).getAllContents();
                    URL[] structureChangeURLs = event.getURLs();
                    URL projectDir = URLFileSystem.getParent((URL)this._project.getURL());
                    for (int i = 0; i < structureChangeURLs.length; ++i) {
                        if (contents.canHaveMember(structureChangeURLs[i])) {
                            this.fireStructureChangedEvent();
                            continue;
                        }
                        if (!URLFileSystem.equals((URL)structureChangeURLs[i], (URL)projectDir)) continue;
                        this.fireStructureChangedEvent();
                    }
                    break;
                }
            }
        }

        private void fireAddedEvent(Node addedNode) {
            UpdateMessage.fireChildAdded((Subject)this._project, (Element)addedNode);
        }

        private void fireRemovedEvent(Node removedNode) {
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, (Object)this);
            updateMessage.getRemoveObjects().add(removedNode);
            this._project.notifyObservers((Object)this._project, updateMessage);
        }

        private void fireStructureChangedEvent() {
            UpdateMessage.fireStructureChanged((Subject)this._project);
        }
    }

    private final class ProgressAdapter
    extends VCSProgress {
        private final VCSTask _task;
        private int _maximum;
        private int _progress;
        private int _ceiling = -1;

        ProgressAdapter(VCSTask task) {
            this._task = task;
        }

        @Override
        public void incrementProgress(int amount) {
            this.setProgress(this.getProgress() + amount);
        }

        @Override
        public boolean isCancelled() {
            return this._task != null && this._task.isCancelled();
        }

        protected final synchronized void setProgress(int progress) {
            if (this._ceiling >= 0 && progress > this._ceiling) {
                new IllegalArgumentException("Progress exceeds current ceiling (" + progress + " > " + this._ceiling + ")").printStackTrace();
            }
            if (this._ceiling >= 0) {
                progress = Math.min(progress, this._ceiling);
            }
            if (this._task != null) {
                int oldValue = this.calculateProgressPercent(this._progress);
                int newValue = this.calculateProgressPercent(progress);
                this._task.getPropertyChangeSupport().firePropertyChange("external-progress", oldValue, newValue);
            }
            this._progress = progress;
        }

        private final int calculateProgressPercent(int progress) {
            return this._maximum > 0 ? Math.min(100, Math.max(0, Math.round((float)progress / (float)this._maximum))) : 0;
        }

        protected final synchronized int getProgress() {
            return this._progress;
        }

        private final void setMaximum(int maximum) {
            this._maximum = maximum;
        }

        private final void setCeiling(int ceiling) {
            this._ceiling = ceiling;
        }

        private final int getCeiling() {
            return this._ceiling;
        }
    }

    private static class CheckOutFilesPanel
    extends SelectFilesPanel {
        private static final int OK_BUTTON = 0;
        private static final int CANCEL_BUTTON = 1;
        private static final int DLG_MAX_WIDTH = 800;
        private static final int DLG_MAX_HEIGHT = 600;
        private static final int DLG_MIN_WIDTH = 400;
        private static final int DLG_MIN_HEIGHT = 300;

        CheckOutFilesPanel(CheckBoxListModel listModel, String prompt) {
            super(listModel, true, prompt);
        }

        public static final int showDialog(Component parent, String title, Component pnl, String helpTopic) {
            int displayButtons = 3;
            if (helpTopic != null) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)pnl, helpTopic);
                displayButtons += 4;
            }
            JEWTDialog dialog = CheckOutFilesPanel.newDialog(parent, title, pnl, displayButtons);
            dialog.setDefaultButton(1);
            return VCSDialogRunner.runDialog((JDialog)dialog) ? 0 : 1;
        }

        private static JEWTDialog newDialog(Component parent, String title, Component pnl, int buttons) {
            JEWTDialog dlg = JEWTDialog.createDialog((Component)parent, (String)title, (int)buttons);
            dlg.setMinimumSize(400, 300);
            dlg.setMaximumInitialSize(800, 600);
            dlg.setContent(pnl);
            dlg.setResizable(true);
            return dlg;
        }
    }
}

