/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.vop;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTablePersistentSettings;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.vcs.vop.BaseVersionOperationPanel;
import oracle.jdeveloper.vcs.vop.DisplayableCellRenderer;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModelEvent;
import oracle.jdeveloper.vcs.vop.VersionOperationModelListener;
import oracle.jdeveloper.vcs.vop.VersionOperationTableModel;

public class VersionOperationTablePanel
extends BaseVersionOperationPanel {
    private NiceTable _table;
    private JScrollPane _scrollPane;

    @Override
    protected final void createComponents() {
        this._table = new NiceTable();
        this._table.setShowToolTips(false);
        this._table.setUseTransferHandler(false);
        this._table.setDefaultRenderer(Displayable.class, (TableCellRenderer)((Object)new DisplayableCellRenderer()));
        this._scrollPane = new JScrollPane((Component)this._table);
    }

    @Override
    protected final JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    @Override
    protected final void initializePreferredSize() {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setText("Dummy");
        Insets i = this.getScrollPane().getInsets();
        int width = this._table.getPreferredSize().width;
        width += this.getScrollPane().getVerticalScrollBar().getPreferredSize().width;
        width += i.left;
        int height = this._table.getTableHeader().getPreferredSize().height;
        height += renderer.getPreferredSize().height * 5;
        height += i.top;
        this.getScrollPane().setPreferredSize(new Dimension(width += i.right, height += i.bottom));
    }

    @Override
    protected final void addMouseListenerImpl(MouseListener ml) {
        this._table.addMouseListener(ml);
    }

    @Override
    protected final void removeMouseListenerImpl(MouseListener ml) {
        this._table.removeMouseListener(ml);
    }

    @Override
    public final void installModelImpl(final VersionOperationModel model) {
        VersionOperationTableModel tableModel = new VersionOperationTableModel(model);
        this._table.setModel((TableModel)tableModel);
        this._table.setAutoResizeMode(0);
        this._table.setSorted(true);
        this._autoSizeColumnsToFit();
        if (!model.isComplete()) {
            VersionOperationModelListener l = new VersionOperationModelListener(){

                @Override
                public void completenessChanged(VersionOperationModelEvent event) {
                    if (model.isComplete()) {
                        VersionOperationTablePanel.this._table.setSortColumn(0, true);
                        VersionOperationTablePanel.this._table.repaint();
                        model.removeVersionOperationListener(this);
                    }
                }

                @Override
                public void itemsRemoved(VersionOperationModelEvent event) {
                }

                @Override
                public void itemsChanged(VersionOperationModelEvent event) {
                }

                @Override
                public void itemsInserted(VersionOperationModelEvent event) {
                }
            };
            model.addVersionOperationModelListener(l);
        } else {
            this._reapplySort();
        }
        this.initializePreferredSize();
    }

    @Override
    protected void attachSelectionListener() {
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                VersionOperationTablePanel.this.fireSelectionChange();
            }
        });
    }

    @Override
    @Deprecated
    public final void autoSizeColumnsToFit() {
        this._autoSizeColumnsToFit();
    }

    private final void _autoSizeColumnsToFit() {
        VersionOperationTableModel tableModel = (VersionOperationTableModel)this._table.getBaseModel();
        Object[] prototypeValues = new Object[tableModel.getColumnCount()];
        for (int i = 0; i < prototypeValues.length; ++i) {
            prototypeValues[i] = tableModel.getProperty(i).getPrototypeValue();
        }
        this._table.autoSizeColumnsToFit(prototypeValues);
    }

    @Override
    @Deprecated
    public final void reapplySort() {
        this._reapplySort();
    }

    private final void _reapplySort() {
        int sortColumn = this._table.getSortColumn();
        boolean sortAscending = this._table.isSortAscending();
        if (sortColumn >= 0) {
            this._table.setSortColumn(sortColumn, sortAscending);
        }
    }

    @Override
    @Deprecated
    public final NiceTable getTable() {
        return this._table;
    }

    @Override
    public final Element[] getSelection() {
        int[] selectedRows = this._table.getSelectedRowsInModel();
        if (selectedRows != null && selectedRows.length > 0) {
            ArrayList<Displayable> selection = new ArrayList<Displayable>(selectedRows.length);
            for (int i = 0; i < selectedRows.length; ++i) {
                int rowIndex = selectedRows[i];
                if (rowIndex >= this.getModel().getCount()) continue;
                selection.add(this.getModel().getItem(rowIndex));
            }
            Element[] arr = new Element[selection.size()];
            selection.toArray(arr);
            return arr;
        }
        return new Element[0];
    }

    @Override
    public final void selectAll() {
        int rows = this._table.getRowCount();
        if (rows > 0) {
            this._table.setRowSelectionInterval(0, rows - 1);
        }
    }

    @Override
    protected final void selectOnRightClick(MouseEvent me) {
        int row = this._table.rowAtPoint(me.getPoint());
        if (row < 0 || row >= this._table.getModel().getRowCount()) {
            return;
        }
        if (!this._table.isRowSelected(row)) {
            this._table.setRowSelectionInterval(row, row);
        }
        this.requestFocus();
    }

    @Override
    protected final Component getInternalComponent() {
        return this._table;
    }

    @Override
    public boolean isItemAtPosition(Point p) {
        return this._table.rowAtPoint(p) >= 0;
    }

    @Override
    public Object depersistVisualSettings(String persistenceKey) {
        CopyableNiceTablePersistentSettings settings = (CopyableNiceTablePersistentSettings)Ide.getDTCache().getData(persistenceKey);
        if (settings != null) {
            this._table.setPersistentSettings(settings.getValue());
        }
        return settings;
    }

    @Override
    public void persistVisualSettings(String persistenceKey) {
        Ide.getDTCache().putData(persistenceKey, (Copyable)new CopyableNiceTablePersistentSettings(this._table.getPersistentSettings()));
    }

    @Override
    @Deprecated
    public void setDefaultRenderer(Class<?> columnClass, TableCellRenderer renderer) {
        this._table.setDefaultRenderer(columnClass, renderer);
    }

    public static class CopyableNiceTablePersistentSettings
    implements Copyable {
        private NiceTablePersistentSettings _value;

        public CopyableNiceTablePersistentSettings() {
        }

        public CopyableNiceTablePersistentSettings(NiceTablePersistentSettings settings) {
            this.setValue(settings);
        }

        public NiceTablePersistentSettings getValue() {
            return this._value;
        }

        public void setValue(NiceTablePersistentSettings settings) {
            this._value = settings;
        }

        public Object copyTo(Object target) {
            CopyableNiceTablePersistentSettings copy = target != null ? (CopyableNiceTablePersistentSettings)target : new CopyableNiceTablePersistentSettings();
            this.copyToImpl(copy);
            return copy;
        }

        protected final void copyToImpl(CopyableNiceTablePersistentSettings copy) {
            copy.setValue(this.getValue());
        }
    }
}

