/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.vop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import oracle.ide.model.Element;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.vop.VersionOperationCategorizer;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;

public abstract class BaseVersionOperationPanel
extends JPanel {
    private final JScrollPane _scrollPane;
    private Component _optionsComponent;
    private VersionOperationModel _model;
    private MouseListener _rightClickListener;
    private int _optionsLocation = 3;
    private boolean _optionsResizeable;
    private JSplitPane _splitPane;
    private List<ChangeListener> _selectionListeners = new ArrayList<ChangeListener>();
    public static final int BORDER_LOOK_NOT_FLAT = 0;
    public static final int BORDER_LOOK_FLAT_CHANGELIST = 1;
    public static final int BORDER_LOOK_FLAT_HISTORY = 2;

    protected BaseVersionOperationPanel() {
        BorderLayout bl = new BorderLayout();
        this.setLayout(bl);
        this.createComponents();
        this._scrollPane = this.getScrollPane();
        this.initializePreferredSize();
        this.layoutComponents();
        this.attachSelectionListener();
    }

    @Deprecated
    public void autoSizeColumnsToFit() {
    }

    @Deprecated
    public void reapplySort() {
    }

    @Deprecated
    public NiceTable getTable() {
        return new NiceTable();
    }

    protected abstract void createComponents();

    protected abstract JScrollPane getScrollPane();

    protected abstract void initializePreferredSize();

    protected abstract void attachSelectionListener();

    @Override
    public final void addMouseListener(MouseListener ml) {
        this._scrollPane.addMouseListener(ml);
        this.addMouseListenerImpl(ml);
    }

    protected abstract void addMouseListenerImpl(MouseListener var1);

    @Override
    public final void removeMouseListener(MouseListener ml) {
        this._scrollPane.removeMouseListener(ml);
        this.removeMouseListenerImpl(ml);
    }

    protected abstract void removeMouseListenerImpl(MouseListener var1);

    public void setOptionsResizeable(boolean optionsResizeable) {
        this._optionsResizeable = optionsResizeable;
        this.layoutComponents();
    }

    public boolean isOptionsResizeable() {
        return this._optionsResizeable;
    }

    public void setOptionsComponent(Component c) {
        this._optionsComponent = c;
        this.layoutComponents();
    }

    public Component getOptionsComponent() {
        return this._optionsComponent;
    }

    public void setOptionsLocation(int location) {
        if (this._optionsLocation != location) {
            this._optionsLocation = location;
            if (this._optionsComponent != null) {
                this.setOptionsComponent(this._optionsComponent);
            }
        }
    }

    public final void setOptionsVisible(boolean isVisible) {
        if (this._optionsComponent != null) {
            this._optionsComponent.setVisible(isVisible);
            this.layoutComponents();
            this.firePropertyChange("optionsVisible", !isVisible, isVisible);
        }
    }

    public final boolean isOptionsVisible() {
        if (this._optionsComponent != null) {
            return this._optionsComponent.isVisible();
        }
        return false;
    }

    public VersionOperationModel getModel() {
        return this._model;
    }

    public void setBorderLook(int look) {
        if (look == 0) {
            this._scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        } else if (look == 1) {
            this._scrollPane.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, UIManager.getColor("controlShadow")));
        } else if (look == 2) {
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public void installModel(VersionOperationModel model) {
        this._model = model;
        this.installModelImpl(model);
    }

    protected abstract void installModelImpl(VersionOperationModel var1);

    public final void addSelectionListener(ChangeListener listener) {
        this._selectionListeners.add(listener);
    }

    public final void removeSelectionListener(ChangeListener listener) {
        this._selectionListeners.remove(listener);
    }

    public abstract Element[] getSelection();

    public abstract void selectAll();

    protected abstract void selectOnRightClick(MouseEvent var1);

    public void setSelectOnRightClick(boolean isSet) {
        if (isSet) {
            if (this._rightClickListener == null) {
                this._rightClickListener = new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent me) {
                        if (me.isPopupTrigger()) {
                            BaseVersionOperationPanel.this.selectOnRightClick(me);
                        }
                    }

                    @Override
                    public void mousePressed(MouseEvent me) {
                        if (me.isPopupTrigger()) {
                            BaseVersionOperationPanel.this.selectOnRightClick(me);
                        }
                    }

                    @Override
                    public void mouseClicked(MouseEvent me) {
                        if (me.isPopupTrigger()) {
                            BaseVersionOperationPanel.this.selectOnRightClick(me);
                        }
                    }
                };
                this.addMouseListener(this._rightClickListener);
            }
        } else if (this._rightClickListener != null) {
            this.removeMouseListener(this._rightClickListener);
            this._rightClickListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layoutComponents() {
        this.removeAll();
        try {
            if (!this._optionsResizeable || this._optionsComponent == null || !this._optionsComponent.isVisible()) {
                this.add((Component)this._scrollPane, "Center");
                if (this._optionsComponent != null && this._optionsComponent.isVisible()) {
                    this.add(this._optionsComponent, this._optionsLocation == 1 ? "North" : "South");
                }
                return;
            }
            JPanel tablePanel = new JPanel(new BorderLayout());
            tablePanel.add((Component)this._scrollPane, "Center");
            tablePanel.setMinimumSize(new Dimension(0, 0));
            this._splitPane = this._optionsLocation == 1 ? new JSplitPane(0, this._optionsComponent, tablePanel) : new JSplitPane(0, tablePanel, this._optionsComponent);
            this._splitPane.setOneTouchExpandable(true);
            this.add((Component)this._splitPane, "Center");
        }
        finally {
            this.getInternalComponent().validate();
            this.getInternalComponent().invalidate();
            this.validate();
            this.invalidate();
            this.repaint();
        }
    }

    public final int getOptionsDividerLocation() {
        return this._splitPane != null ? this._splitPane.getDividerLocation() : -1;
    }

    public final void setOptionsDividerLocation(int location) {
        if (this._splitPane != null) {
            this._splitPane.setDividerLocation(location);
        }
    }

    protected abstract Component getInternalComponent();

    protected final void fireSelectionChange() {
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener l : this._selectionListeners) {
            l.stateChanged(ce);
        }
    }

    public Component getFocusComponent() {
        return this.getInternalComponent();
    }

    public abstract boolean isItemAtPosition(Point var1);

    public void setCategorizer(VersionOperationCategorizer categorizer) {
    }

    public void setCategoryCache(Map<VCSHashURL, String> categoryCache) {
    }

    public void fireCategoriesChanged() {
    }

    public void setDefaultCategory(String category) {
    }

    public Object depersistVisualSettings(String persistenceKey) {
        return null;
    }

    public void persistVisualSettings(String persistenceKey) {
    }

    @Deprecated
    public void setDefaultRenderer(Class<?> columnClass, TableCellRenderer renderer) {
    }
}

