/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.versionhistory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.ide.Context;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Node;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.history.DefaultHistoryModel;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryNode;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryURLHelper;
import oracle.jdevimpl.compare.EastWestToolbarLayout;
import oracle.jdevimpl.history.HistoryFilterComponent;
import oracle.jdevimpl.history.HistoryManagerImpl;
import oracle.jdevimpl.history.HistoryViewer;

public class VersionHistoryViewer
extends HistoryViewer {
    private JLabel _rightLabel;
    private HistoryFilterComponent _rightFilter;
    private JSplitPane _historySplitPane;
    private SplitListener _splitListener;

    public void open() {
        Node node = this.getContext().getNode();
        try {
            if (node instanceof VersionHistoryNode) {
                node.open();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        super.open();
    }

    public void close() {
        super.close();
        Node node = this.getContext().getNode();
        try {
            if (node instanceof VersionHistoryNode) {
                node.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void refresh() {
        HistoryContext.setHistoryEntrySelectorLHS((Context)this.getContext(), null);
        super.refresh();
    }

    protected String getTablePersistenceKeyLHS() {
        return "VersionHistoryViewer.LHS.DisplaySettings";
    }

    protected String getTablePersistenceKeyRHS() {
        return "VersionHistoryViewer.RHS.DisplaySettings";
    }

    protected void enableAllDefaultProperties(DefaultHistoryModel model) {
    }

    protected URL getRealURL() {
        return VersionHistoryURLHelper.getRealURL(super.getRealURL());
    }

    protected Component createNoHistoryPanel() {
        JPanel noHistoryPanel = new JPanel(new BorderLayout());
        Component noHistoryLabel = super.createNoHistoryPanel();
        if (noHistoryLabel instanceof JComponent) {
            ((JComponent)noHistoryLabel).setBorder(this.createRightLineBorder());
        }
        noHistoryPanel.add(noHistoryLabel, "Center");
        noHistoryPanel.add(Box.createHorizontalStrut(BaseCompareView.calculateRightEditorInset()), "East");
        noHistoryPanel.putClientProperty("VersionHistoryViewer.label", noHistoryLabel);
        return noHistoryPanel;
    }

    protected void setNoHistoryText(Component noHistoryPanel, String message) {
        super.setNoHistoryText((Component)((JComponent)noHistoryPanel).getClientProperty("VersionHistoryViewer.label"), message);
    }

    protected HistoryComponent createHistoryComponent() {
        HistoryComponent historyComponent = super.createHistoryComponent();
        historyComponent.setUseScrollPane(true);
        return historyComponent;
    }

    protected HistoryFilterComponent createHistoryFilter() {
        HistoryFilterComponent leftFilter = this.createHistoryFilter(this.getLeftHistoryComponent());
        this._rightFilter = this.createHistoryFilter(this.getRightHistoryComponent());
        return leftFilter;
    }

    protected void setHistoryFilterEnabled(boolean enabled) {
        super.setHistoryFilterEnabled(enabled);
        this._rightLabel.setEnabled(enabled);
        this._rightFilter.setEnabled(enabled);
    }

    protected void refilterModel() {
        super.refilterModel();
        this._rightFilter.refilter();
    }

    protected JLabel createHistoryFilterLabel(HistoryFilterComponent filter) {
        JLabel leftLabel = this.createToolbarLabel();
        ResourceUtils.resLabel((JLabel)leftLabel, (Component)filter, (String)VCSArb.getString(234));
        this._rightLabel = this.createToolbarLabel();
        ResourceUtils.resLabel((JLabel)this._rightLabel, (Component)this._rightFilter, (String)VCSArb.getString(235));
        return leftLabel;
    }

    protected void disposeHistoryFilters() {
        super.disposeHistoryFilters();
        this._rightFilter.detachCustomFilterObserver();
    }

    protected void layoutHistoryPanel(JPanel historyPanel) {
        this._historySplitPane = new JSplitPane(1);
        this._historySplitPane.setDividerSize(50);
        this._historySplitPane.setContinuousLayout(true);
        JPanel leftPanel = new JPanel(new BorderLayout());
        JPanel rightPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.getLeftHistoryComponent(), "Center");
        rightPanel.add((Component)this.getRightHistoryComponent(), "Center");
        this._historySplitPane.setBorder(this.createRightLineBorder());
        this._historySplitPane.setResizeWeight(0.5);
        this._historySplitPane.setLeftComponent(leftPanel);
        this._historySplitPane.setRightComponent(rightPanel);
        historyPanel.setLayout(new BorderLayout());
        historyPanel.add((Component)this._historySplitPane, "Center");
        historyPanel.add(Box.createHorizontalStrut(BaseCompareView.calculateRightEditorInset()), "East");
        this._historySplitPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VersionHistoryViewer.this._historySplitPane.setDividerLocation(0.5);
                    }
                });
                VersionHistoryViewer.this._historySplitPane.removeComponentListener(this);
            }
        });
    }

    protected double getDefaultDividerLocation() {
        return 0.5;
    }

    protected HistoryModel updateHistoryModel(HistoryComponent historyComponent, HistoryFilterComponent filter) {
        if (historyComponent == this.getRightHistoryComponent()) {
            filter = this._rightFilter;
        }
        HistoryModel historyModel = this.updateHistoryModelImpl(historyComponent, filter);
        if (historyComponent == this.getLeftHistoryComponent()) {
            HistoryContext.setHistoryEntrySelectorLHS((Context)this.getContext(), (HistoryEntrySelector)HistoryEntrySelector.PREVIOUS_REVISION);
        }
        if (historyComponent == this.getRightHistoryComponent()) {
            HistoryContext.setHistoryEntrySelectorRHS((Context)this.getContext(), (HistoryEntrySelector)HistoryEntrySelector.CURRENT_REVISION);
        }
        return historyModel;
    }

    protected Collection getHistoryProviders() {
        ArrayList providers = new ArrayList(HistoryManager.getHistoryManager().getProviders());
        providers.remove(((HistoryManagerImpl)HistoryManager.getHistoryManager()).getLocalHistoryProvider());
        return providers;
    }

    protected CompareView createCompareView(CompareModel model) {
        CompareView compareView;
        if (this._splitListener != null) {
            this._splitListener.detach();
            this._splitListener = null;
        }
        if ((compareView = super.createCompareView(model)) instanceof BaseCompareView) {
            this._splitListener = new SplitListener(this._historySplitPane, (BaseCompareView)compareView);
            this._splitListener.attach();
        }
        return compareView;
    }

    protected void initializeToolbars() {
        this.getToolbar().setLayout((LayoutManager)new EastWestToolbarLayout((Container)this.getToolbar()));
        super.initializeToolbars();
        if (this._rightFilter != null) {
            this.getToolbar().add((Component)this._rightLabel, (Object)"East");
            this.getToolbar().add((Component)this._rightFilter, (Object)"East");
            return;
        }
        int height = 0;
        Toolbar leftToolbar = super.getToolbar();
        for (int i = 0; i < leftToolbar.getComponentCount(); ++i) {
            height = Math.max(leftToolbar.getComponent((int)i).getPreferredSize().height, height);
        }
        leftToolbar.setMinimumSize(new Dimension(0, 0));
    }

    protected boolean isEditableRHS() {
        return false;
    }

    private Border createRightLineBorder() {
        return BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getColor("controlShadow"));
    }

    private class SplitListener
    implements PropertyChangeListener {
        private final JSplitPane _splitPane;
        private final BaseCompareView _splitPanelView;
        private int _dividerWidthDelta;

        SplitListener(JSplitPane splitPane, BaseCompareView splitPanelView) {
            this._splitPane = splitPane;
            this._splitPanelView = splitPanelView;
        }

        void attach() {
            this._splitPanelView.getLeftOrCenterSplitter().addPropertyChangeListener(this);
            this._splitPane.addPropertyChangeListener(this);
            this._dividerWidthDelta = this._splitPane.getDividerSize() / 2;
        }

        void detach() {
            this._splitPanelView.getLeftOrCenterSplitter().removePropertyChangeListener(this);
            this._splitPane.removePropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equals("lastSplitterLocation")) {
                this.detach();
                this._splitPane.setDividerLocation((Integer)pce.getNewValue() - this._dividerWidthDelta);
                this.attach();
            }
            if (pce.getPropertyName().equals("dividerLocation")) {
                this.detach();
                if (this._splitPanelView instanceof BaseCompareView) {
                    this._splitPanelView.setSplitterLocation(this._splitPanelView.getLeftOrCenterSplitter(), (Integer)pce.getNewValue() + this._dividerWidthDelta, (Component)this._splitPane);
                } else {
                    this._splitPanelView.setSplitterLocation(this._splitPanelView.getLeftOrCenterSplitter(), (Integer)pce.getNewValue() + this._dividerWidthDelta);
                }
                this.attach();
            }
        }
    }
}

