/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import oracle.ide.Ide;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryNotAvailableException;

public class VCSOperatingSystem {
    private static final String OS_NAME_PROPERTY = "os.name";
    private static final int WINDOWS = 1;
    private static final int OSX = 2;
    private static final int OTHER = 3;
    private static final int _os = VCSOperatingSystem.determineOS();

    private VCSOperatingSystem() {
    }

    public static final boolean isWindows() {
        return _os == 1;
    }

    public static final boolean isOSX() {
        return _os == 2;
    }

    private static final int determineOS() {
        String osName;
        if (Ide.isRunning()) {
            try {
                if (NativeHandler.getRegistry() != null) {
                    return 1;
                }
            }
            catch (RegistryNotAvailableException rnae) {
                // empty catch block
            }
        }
        if ((osName = System.getProperty(OS_NAME_PROPERTY)) == null) {
            return 1;
        }
        if ((osName = osName.toLowerCase()).indexOf("os x") >= 0) {
            return 2;
        }
        if (osName.indexOf("windows") >= 0) {
            return 1;
        }
        return 3;
    }
}

