/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.IdeSettings;
import oracle.ide.panels.Navigable;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSVersioningTraversable;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSIdeEventRecorder;
import oracle.jdevimpl.vcs.generic.SearchNavigable;

public class VCSNavigableUtils {
    private static Navigable _versioningNavigable;
    private static Collection<Navigable> _navigables;
    private static boolean _navigablesRegistered;

    private VCSNavigableUtils() {
    }

    public static final Navigable createVersioningNavigable() {
        return new SearchNavigable(VCSArb.getString(1), VCSVersioningTraversable.class, VCSArb.getString(302));
    }

    public static final Navigable createVersioningNavigable(Class traversableClass) {
        return new Navigable(VCSArb.getString(1), traversableClass);
    }

    public static final Navigable createGeneralNavigable(Class traversableClass) {
        return new Navigable(VCSArb.getString(2), traversableClass);
    }

    public static final Navigable createCommentTemplatesNavigable(Class traversableClass) {
        return new Navigable(VCSArb.getString(272), traversableClass);
    }

    public static final synchronized void registerSystemNavigable(Navigable navigable) {
        if (VCSIdeEventRecorder.hasAddinsLoaded() && Ide.getIdeArgs().getCreateUI()) {
            throw new IllegalStateException("registerSystemNavigable() must be called in Addin.initialize()");
        }
        if (_navigables == null) {
            _navigables = new ArrayList<Navigable>();
        }
        _navigables.add(navigable);
        if (_navigables.size() > 1) {
            return;
        }
        _navigables = new ArrayList<Navigable>();
        _navigables.add(navigable);
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public final void addinsLoaded(IdeEvent e) {
                VCSNavigableUtils.registerNavigables();
                Ide.removeIdeListener((IdeListener)this);
            }
        });
    }

    private static final void registerNavigables() {
        if (_navigablesRegistered) {
            return;
        }
        for (Navigable navigable : _navigables) {
            VCSNavigableUtils._registerSystemNavigable(navigable);
        }
        _navigables = null;
        _navigablesRegistered = true;
    }

    private static final void _registerSystemNavigable(Navigable navigable) {
        if (_navigables.size() > 1) {
            if (_versioningNavigable == null) {
                _versioningNavigable = VCSNavigableUtils.createVersioningNavigable();
                IdeSettings.registerUI((Navigable)_versioningNavigable);
            }
            _versioningNavigable.addChildNavigable(navigable);
            return;
        }
        _versioningNavigable = new Navigable("", null);
        navigable.copyTo((Object)_versioningNavigable);
        _versioningNavigable.setShortLabel(VCSArb.getString(1));
        IdeSettings.registerUI((Navigable)_versioningNavigable);
    }

    public static final String[] getSystemNavigablePath(String systemShortLabel, String ... relativePath) {
        if (!VCSIdeEventRecorder.hasAddinsLoaded() && !Boolean.getBoolean("java.awt.headless")) {
            throw new IllegalStateException("getSystemNavigablePath() must be called after Addin.initialize()");
        }
        VCSNavigableUtils.registerNavigables();
        if (_versioningNavigable == null) {
            throw new IllegalStateException();
        }
        ArrayList<String> path = new ArrayList<String>();
        path.add(_versioningNavigable.getShortLabel());
        if (VCSExtensionUtils.getExtensionCount() > 1) {
            path.add(systemShortLabel);
        }
        if (relativePath != null) {
            for (String s : relativePath) {
                path.add(s);
            }
        }
        return path.toArray(new String[0]);
    }

    public static final void resetVersioningNavigable() {
        _versioningNavigable = null;
    }
}

