/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.model.Attributes;
import oracle.ide.model.ContentSet;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.VetoableSubject;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Log;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.vcs.spi.VCSApplicationSystem;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

public final class VCSModelUtils {
    private static final Log LOG = new Log("vcs");

    private VCSModelUtils() {
    }

    public static final Locatable[] findOrCreateNodes(URL[] urls) {
        Locatable[] locatables = new Locatable[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            locatables[i] = NodeFactory.find((URL)urls[i]);
            if (locatables[i] != null) continue;
            if (URLFileSystem.isDirectoryPath((URL)urls[i])) {
                locatables[i] = new LocatableImpl(urls[i]){

                    public Icon getIcon() {
                        return UIManager.getIcon("Tree.closedIcon");
                    }
                };
                continue;
            }
            try {
                locatables[i] = NodeFactory.findOrCreate((URL)urls[i]);
                continue;
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            locatables[i] = new LocatableImpl(urls[i]);
        }
        return locatables;
    }

    public static final URL[] convertNodesToURLs(Locatable[] locatables) {
        URL[] urls = new URL[locatables.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = locatables[i].getURL();
        }
        return urls;
    }

    public static final URL[] convertNodesToURLs(Collection<? extends Locatable> locatables) {
        return VCSModelUtils.convertNodesToURLs(locatables.toArray(new Locatable[0]));
    }

    public static final boolean isElementSaveUpdate(Object observed, UpdateMessage change) {
        if (change.getMessageID() != UpdateMessage.ATTRIBUTE_CHANGED) {
            return false;
        }
        if (!(observed instanceof Element)) {
            return false;
        }
        if (change.getModifyObjects() == null || change.getModifyObjects().size() <= 0) {
            return false;
        }
        Attributes bef = (Attributes)change.getModifyObjects().get(0);
        Attributes aft = ((Element)observed).getAttributes();
        if (bef == null || aft == null) {
            return false;
        }
        return bef.isSet(ElementAttributes.DIRTY) && !aft.isSet(ElementAttributes.DIRTY);
    }

    public static final Locatable[] getValidLocatables(Object[] nodes, URLFilter filter) {
        ArrayList<Locatable> c = new ArrayList<Locatable>();
        for (int i = 0; i < nodes.length; ++i) {
            URL url = VCSModelUtils.getLocatableURL(nodes[i]);
            if (url == null || filter != null && !filter.accept(url)) continue;
            c.add((Locatable)nodes[i]);
        }
        return c.toArray(new Locatable[0]);
    }

    public static final URL getLocatableURL(Object node) {
        return node instanceof Locatable ? ((Locatable)node).getURL() : null;
    }

    public static final Node[] findCachedNodes(URLFilter filter) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Iterator itr = NodeFactory.getCachedNodes();
        while (itr.hasNext()) {
            Node node = (Node)itr.next();
            URL url = node.getURL();
            if (filter != null && (url == null || !filter.accept(url))) continue;
            nodes.add(node);
        }
        return nodes.toArray(new Node[0]);
    }

    public static final Node[] getDirtyNodes(Node[] nodes) {
        ArrayList<Node> dirtyables = new ArrayList<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].isDirty()) continue;
            dirtyables.add(nodes[i]);
        }
        return dirtyables.toArray(new Node[0]);
    }

    public static final Node[] getCachedDirectoryNodes(URL[] directoryUrls) {
        return VCSModelUtils.findCachedNodes(VCSURLFilters.createDirectoryContentsFilter(directoryUrls));
    }

    public static final Node[] getCachedBaseURLNodes(URL[] baseUrls) {
        return VCSModelUtils.findCachedNodes(VCSURLFilters.createBaseURLContentsFilter(VCSFileSystemUtils.canonicalizeURLs(baseUrls)));
    }

    @Deprecated
    public static final String[] listBinaryExtensions() {
        return VCSFileSystemUtils.listBinaryExtensions();
    }

    public static final Workspace[] findCachedWorkspaces() {
        if (!EventQueue.isDispatchThread()) {
            LOG.trace("VCS: Warning: findCachedWorkspaces() called off the AWT event thread");
        }
        ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
        Iterator itr = Ide.getWorkspaces().getChildren();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof Workspace)) continue;
            workspaces.add((Workspace)o);
        }
        return workspaces.toArray(new Workspace[0]);
    }

    public static final Project[] findCachedProjects() {
        if (!EventQueue.isDispatchThread()) {
            LOG.trace("VCS: Warning: findCachedProjects() called off the AWT event thread");
        }
        LinkedHashSet projects = new LinkedHashSet();
        for (Workspace workspace : VCSModelUtils.findCachedWorkspaces()) {
            projects.addAll(workspace.projects());
        }
        return projects.toArray(new Project[0]);
    }

    @Deprecated
    public static final Project[] findCachedProjects(boolean openWorkspaces) {
        return VCSModelUtils.findCachedProjects();
    }

    @Deprecated
    public static final void fireProjectStructuresChanged() {
        VCSModelUtils.fireProjectStructuresChanged(null);
    }

    @Deprecated
    public static final void fireProjectStructuresChanged(URL[] projectContentsUrls) {
        Project[] projects = VCSModelUtils.findCachedProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].isOpen() || projectContentsUrls != null && !VCSModelUtils.contentSetCanHaveMember(ProjectContent.getInstance((PropertyStorage)projects[i]).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY), projectContentsUrls)) continue;
            VCSModelUtils.fireStructureChanged((Subject)projects[i]);
        }
    }

    public static final void fireVetoableCanRemoveChildren(Object[] elements) throws ChangeVetoException {
        Project[] projects = VCSModelUtils.findCachedProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].isOpen()) continue;
            ArrayList<Object> removeObjects = null;
            for (int j = 0; j < elements.length; ++j) {
                if (elements[j] instanceof Workspace || elements[j] instanceof Project || !projects[i].containsChild((Element)elements[j])) continue;
                if (removeObjects == null) {
                    removeObjects = new ArrayList<Object>();
                }
                removeObjects.add(elements[j]);
            }
            if (removeObjects == null) continue;
            UpdateMessage.fireCanRemoveChildren((VetoableSubject)projects[i], removeObjects);
        }
    }

    public static final URL[] listProjectURLs(Project project, VCSCancellable cancellable) throws InterruptedException {
        return VCSModelUtils.listProjectURLs(project, cancellable, false);
    }

    public static final URL[] listProjectURLs(Project project, VCSCancellable cancellable, boolean includeDirectories) throws InterruptedException {
        LinkedHashSet<VCSHashURL> urls = new LinkedHashSet<VCSHashURL>();
        Iterator<URL> itr = VCSApplicationSystem.getApplicationSystem().createProjectIterator(project, includeDirectories ? VCSApplicationSystem.ListMode.FILES_AND_DIRECTORIES : VCSApplicationSystem.ListMode.FILES_ONLY);
        while (itr.hasNext() && (cancellable == null || !cancellable.isCancelled())) {
            urls.add(new VCSHashURL(itr.next()));
        }
        return VCSHashURL.convertToURLs(urls).toArray(new URL[0]);
    }

    private static boolean contentSetCanHaveMember(ContentSet contentSet, URL[] projectContentsUrls) {
        Iterator<URL> itr = Arrays.asList(projectContentsUrls).iterator();
        while (itr.hasNext()) {
            if (!contentSet.canHaveMember(itr.next())) continue;
            return true;
        }
        return false;
    }

    private static void fireStructureChanged(final Subject s) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                UpdateMessage.fireStructureChanged((Subject)s);
            }
        });
    }

    private static class LocatableImpl
    extends DefaultElement
    implements Locatable {
        private URL _url;

        LocatableImpl(URL url) {
            this.setURL(url);
        }

        public void setURL(URL url) {
            this._url = url;
        }

        public URL getURL() {
            return this._url;
        }

        public String getShortLabel() {
            return URLFileSystem.getFileName((URL)this.getURL());
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            return this.getURL().equals(((LocatableImpl)((Object)obj)).getURL());
        }
    }
}

