/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.awt.Component;
import java.text.Collator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.replace.ReplaceMenuManager;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.util.Log;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSExtensionInformation;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.util.VCSDefaultUtils;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdevimpl.vcs.VCSManagerImpl;

public class VCSMenuUtils {
    private static ContextMenuListener _compareContextMenuListener;
    private static ContextMenuListener _replaceContextMenuListener;
    private static Map<JMenuItem, String> _compareMenuItems;
    private static Map<JMenuItem, String> _replaceMenuItems;
    private static final Log LOG;

    public static JMenu getMainVersioningMenu() {
        JMenu menu = MenuManager.getJMenu((String)"Versioning");
        if (menu == null) {
            throw new IllegalStateException("VCS extension trying to initialize with no Versioning menu");
        }
        return menu;
    }

    public static JMenu getViewTeamSubmenu() {
        Menubar menubar = Ide.getMenubar();
        JMenu teammenu = Menubar.getJMenu((String)"VIEW_TEAM_SUB_MENU");
        if (teammenu != null) {
            return teammenu;
        }
        String menuname = VCSArb.getString(301);
        int mnemonic = StringUtils.getMnemonicKeyCode((String)menuname);
        String realText = StringUtils.stripMnemonic((String)menuname);
        JMenu teamSubmenu = menubar.createSubMenu(realText, Integer.valueOf(mnemonic));
        Menubar.putJMenu((String)"VIEW_TEAM_SUB_MENU", (JMenu)teamSubmenu);
        menubar.add((Component)teamSubmenu, Menubar.getJMenu((String)"View"), MenuConstants.SECTION_VIEW_ALPHABETIZED_VIEWS);
        return teamSubmenu;
    }

    public static JMenuItem installVersionHistoryMenuItem(JMenu menu, int cmdId) {
        return VCSMenuUtils.addMenuItem(menu, cmdId, 99.8f);
    }

    public static JMenu createVersioningSubmenu() {
        float section = MenuConstants.SECTION_ADDITIONAL_CTXT_MENU;
        return Ide.getMenubar().createSubMenu(VCSArb.getString(0), VCSMenuConstants.CONTEXT_MENU_MNEMONIC, 0.1f, section);
    }

    public static JMenu installMainSystemMenu(String vcsId, VCSExtensionInformation information) {
        String menuId = "Versioning." + vcsId;
        if (VCSExtensionUtils.getExtensionCount() <= 1) {
            MenuManager.putJMenu((String)menuId, (JMenu)VCSMenuUtils.getMainVersioningMenu());
            return VCSMenuUtils.getMainVersioningMenu();
        }
        String name = information.getShortLabel();
        JMenu versioningMenu = VCSMenuUtils.getMainVersioningMenu();
        JMenu submenu = Ide.getMenubar().createSubMenu(name, null, 0.0f, 0.0f);
        submenu.setIcon(information.getIcon());
        MenuManager.putJMenu((String)menuId, (JMenu)submenu);
        for (int i = 0; i <= versioningMenu.getItemCount(); ++i) {
            if (i == versioningMenu.getItemCount()) {
                versioningMenu.add(submenu);
                break;
            }
            JMenuItem menuItem = versioningMenu.getItem(i);
            if (Collator.getInstance().compare(menuItem.getText(), name) <= 0) continue;
            versioningMenu.insert(submenu, i);
            break;
        }
        return submenu;
    }

    public static void installContextMenuListener(ContextMenuListener listener) {
        if (NavigatorManager.getApplicationNavigatorManager() != null) {
            NavigatorManager.getApplicationNavigatorManager().addContextMenuListener(listener, null);
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(listener, null);
        ((VCSManagerImpl)VCSManager.getVCSManager()).registerContextMenuListener(listener);
    }

    public static void uninstallContextMenuListener(ContextMenuListener listener) {
        if (NavigatorManager.getApplicationNavigatorManager() != null) {
            NavigatorManager.getApplicationNavigatorManager().removeContextMenuListener(listener);
        }
        EditorManager.getEditorManager().getContextMenu().removeContextMenuListener(listener);
        ((VCSManagerImpl)VCSManager.getVCSManager()).deregisterContextMenuListener(listener);
    }

    public static KeyStrokeContext registerKeyStrokes(Collection<IdeAction> actions, String keyStrokeContextName) {
        IdeAction[] actionArray = new IdeAction[actions.size()];
        actions.toArray(actionArray);
        KeyStrokeContext context = VCSDefaultUtils.createKeyStrokeContext(actionArray, keyStrokeContextName);
        Ide.getKeyStrokeContextRegistry().addContext(context);
        return context;
    }

    public static JMenuItem addMenuItem(JMenu menu, int cmdId, float section) {
        return VCSMenuUtils.addMenuItem(menu, (ToggleAction)IdeAction.find((int)cmdId), section);
    }

    public static JMenuItem addMenuItem(ContextMenu menu, int cmdId, float section) {
        return VCSMenuUtils.addMenuItem(menu, (ToggleAction)IdeAction.find((int)cmdId), section);
    }

    public static JMenuItem addMenuItem(JMenu menu, ToggleAction action, float section) {
        return (JMenuItem)VCSMenuUtils.addMenuItem(menu, Ide.getMenubar().createMenuItem(action), section);
    }

    public static JMenuItem addMenuItem(ContextMenu menu, ToggleAction action, float section) {
        JMenuItem menuItem = Ide.getMenubar().createMenuItem(action);
        menu.add((Component)menuItem, section);
        return menuItem;
    }

    public static Component addMenuItem(JMenu menu, Component component, float section) {
        Ide.getMenubar().add(component, menu, section);
        return component;
    }

    public static JMenuItem addDynamicMenuItem(JMenu menu, int cmdId, float section, Context context) {
        if (!VCSMenuUtils.updateDynamicAction(cmdId, context)) {
            return null;
        }
        return VCSMenuUtils.addMenuItem(menu, cmdId, section);
    }

    public static JMenuItem addDynamicMenuItem(ContextMenu menu, int cmdId, float section) {
        if (!VCSMenuUtils.updateDynamicAction(cmdId, menu.getContext())) {
            return null;
        }
        return VCSMenuUtils.addMenuItem(menu, cmdId, section);
    }

    public static JMenuItem addMenuItemToTeamMenu(int cmdId, String alterativeName, float section) {
        IdeAction action = IdeAction.find((int)cmdId);
        if (alterativeName != null) {
            action.setLabelUpdater((LabelUpdater)new TeamItemActionLabelUpdater(alterativeName));
        }
        JMenu teamMenu = VCSMenuUtils.getViewTeamSubmenu();
        JMenuItem menuItem = VCSMenuUtils.addMenuItem(teamMenu, cmdId, section);
        menuItem.setMnemonic(0);
        return menuItem;
    }

    private static final boolean updateDynamicAction(int cmdId, Context context) {
        IdeAction action = IdeAction.find((int)cmdId);
        if (action == null) {
            return false;
        }
        action.updateAction(context);
        return action.isEnabled();
    }

    public static JMenuItem createMenuItem(int cmdId) {
        return Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)cmdId));
    }

    public static JMenuItem createMenuItem(int cmdId, float weight) {
        return Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)cmdId), weight);
    }

    public static void installCompareMenuItem(final int cmdId, String vcsId) {
        _compareMenuItems.put(VCSMenuUtils.createMenuItem(cmdId), vcsId);
        if (_compareContextMenuListener != null) {
            return;
        }
        _compareContextMenuListener = new ContextMenuListener(){

            public void menuWillShow(ContextMenu contextMenu) {
                CompareViewer compareViewer = CompareViewer.get();
                if (compareViewer == null) {
                    LOG.trace("Compare viewer is not available. Version control menu item \"" + IdeAction.find((int)cmdId).getValue("Name") + "\" could not be installed.");
                    return;
                }
                for (Map.Entry entry : _compareMenuItems.entrySet()) {
                    JMenu menu = compareViewer.getContextCompareMenu();
                    Ide.getMenubar().remove((Component)entry.getKey(), menu);
                    VCSExtension extension = VCSExtensionUtils.getActiveExtension(contextMenu.getContext());
                    if (extension == null || !extension.getId().equals(entry.getValue())) continue;
                    Ide.getMenubar().add((Component)entry.getKey(), menu, 0.5f);
                }
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }
        };
        if (NavigatorManager.getApplicationNavigatorManager() != null) {
            NavigatorManager.getApplicationNavigatorManager().getContextMenu().addContextMenuListener(_compareContextMenuListener);
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(_compareContextMenuListener);
    }

    public static void installReplaceMenuItem(final int cmdId, String vcsId) {
        _replaceMenuItems.put(VCSMenuUtils.createMenuItem(cmdId), vcsId);
        if (_replaceContextMenuListener != null) {
            return;
        }
        _replaceContextMenuListener = new ContextMenuListener(){

            public void menuWillShow(ContextMenu contextMenu) {
                ReplaceMenuManager replaceMenuMgr = ReplaceMenuManager.getInstance();
                if (replaceMenuMgr == null) {
                    LOG.trace("Menu item \"" + IdeAction.find((int)cmdId).getValue("Name") + "\" could not be installed.");
                    return;
                }
                for (Map.Entry entry : _replaceMenuItems.entrySet()) {
                    JMenu menu = replaceMenuMgr.getContextReplaceMenu();
                    Ide.getMenubar().remove((Component)entry.getKey(), menu);
                    VCSExtension extension = VCSExtensionUtils.getActiveExtension(contextMenu.getContext());
                    if (extension == null || !extension.getId().equals(entry.getValue())) continue;
                    Ide.getMenubar().add((Component)entry.getKey(), menu, 1.0f);
                }
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }
        };
        if (NavigatorManager.getApplicationNavigatorManager() != null) {
            NavigatorManager.getApplicationNavigatorManager().getContextMenu().addContextMenuListener(_replaceContextMenuListener);
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(_replaceContextMenuListener);
    }

    public static void addCompareSubmenu(Collection<? super JMenuItem> menus, Context context) {
        if (CompareViewer.get() != null) {
            JMenu menu = CompareViewer.get().getContextCompareMenu();
            for (int i = 0; i < menu.getItemCount(); ++i) {
                JMenuItem item = menu.getItem(i);
                if (item != null && item.getAction() instanceof IdeAction) {
                    ((IdeAction)item.getAction()).updateAction(context);
                }
                if (item == null || !item.isEnabled()) continue;
                menus.add(menu);
                break;
            }
        }
    }

    public static final void registerContextMenuForCompare(ContextMenu contextMenu) {
        if (_compareContextMenuListener != null) {
            contextMenu.addContextMenuListener(_compareContextMenuListener);
        }
    }

    public static final void registerContextMenuForReplace(ContextMenu contextMenu) {
        if (_replaceContextMenuListener != null) {
            contextMenu.addContextMenuListener(_replaceContextMenuListener);
        }
    }

    static {
        _compareMenuItems = new LinkedHashMap<JMenuItem, String>();
        _replaceMenuItems = new LinkedHashMap<JMenuItem, String>();
        LOG = new Log("vcs");
    }

    private static class TeamItemActionLabelUpdater
    implements LabelUpdater {
        private String _teamMenuLabel;
        private int mnemonic;

        private TeamItemActionLabelUpdater(String teamSubLabel) {
            this._teamMenuLabel = StringUtils.stripMnemonic((String)teamSubLabel);
            this.mnemonic = StringUtils.getMnemonicKeyCode((String)teamSubLabel);
        }

        public String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
            JMenu jMenu;
            JMenu teamMenu;
            Object source;
            if (context.getEvent() != null && (source = context.getEvent().getSource()) instanceof JMenu && (teamMenu = VCSMenuUtils.getViewTeamSubmenu()) == (jMenu = (JMenu)source)) {
                return this._teamMenuLabel;
            }
            return originalLabel;
        }

        public String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
            return this.labelWhenEnabled(context, action, originalLabel);
        }

        public void setEnabledFormat(String format) {
        }

        public void setDisabledFormat(String format) {
        }
    }
}

