/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.ide.Context;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.spi.VCSProtocolRegistry;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

public final class VCSContextUtils {
    private static final String SUB_PREFIX = "_SUB_";
    private static URLFilter _protocolFilter = null;

    private VCSContextUtils() {
    }

    public static final URLFilter createLocalProtocolFilter() {
        return VCSURLFilters.createChainedANDFilter(new URLFilter[]{new URLFilter(){

            public boolean accept(URL url) {
                return URLFileSystem.isLocal((URL)url);
            }
        }, new URLFilter(){

            public boolean accept(URL url) {
                for (String protocol : VCSProtocolRegistry.protocols()) {
                    if (!url.getProtocol().equals(protocol)) continue;
                    return true;
                }
                return false;
            }
        }});
    }

    public static final Locatable[] getContextLocatables(Context context, URLFilter filter) {
        Element[] elements = null;
        if (context.getSelection() != null && context.getSelection().length > 0) {
            elements = context.getSelection();
            boolean gotLocatables = false;
            for (int i = 0; i < elements.length; ++i) {
                URL url;
                if (!(elements[i] instanceof Locatable) || (url = ((Locatable)elements[i]).getURL()) == null || filter != null && !filter.accept(url)) continue;
                gotLocatables = true;
                break;
            }
            if (!gotLocatables) {
                elements = null;
            }
        }
        if (elements == null) {
            LinkedHashSet<Element> directoryFolders = new LinkedHashSet<Element>();
            if (context.getElement() instanceof RelativeDirectoryContextFolder) {
                directoryFolders.add(context.getElement());
            }
            if (context.getSelection() != null) {
                for (Element element : context.getSelection()) {
                    if (!(element instanceof RelativeDirectoryContextFolder)) continue;
                    directoryFolders.add(element);
                }
            }
            if (!directoryFolders.isEmpty()) {
                elements = directoryFolders.toArray(new Element[0]);
            }
        }
        if (elements == null && context.getNode() != null && !(context.getNode() instanceof Project)) {
            elements = new Element[]{context.getNode()};
        }
        if (elements == null) {
            return new Locatable[0];
        }
        Locatable[] expandedLocatables = VCSContextUtils.getExpandedLocatables(context, elements, filter);
        ArrayList<Object> locatables = new ArrayList<Object>();
        for (Locatable locatable : expandedLocatables) {
            URL url = locatable.getURL();
            if (!JarUtil.isJarURL((URL)url)) {
                locatables.add(locatable);
                continue;
            }
            if (!JarUtil.getJarEntry((URL)url).equals("")) continue;
            try {
                locatables.add(NodeFactory.findOrCreate((URL)JarUtil.getJarFileURL((URL)url)));
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InstantiationException ie) {
                // empty catch block
            }
        }
        return locatables.toArray(new Locatable[locatables.size()]);
    }

    public static final Locatable[] getContextLocatables(Context context) {
        if (_protocolFilter == null) {
            _protocolFilter = VCSContextUtils.createLocalProtocolFilter();
        }
        return VCSContextUtils.getContextLocatables(context, _protocolFilter);
    }

    public static final Locatable[] getExpandedLocatables(Element[] elements, URLFilter filter) {
        return VCSContextUtils.getExpandedLocatables(null, elements, filter);
    }

    public static final Locatable[] getExpandedLocatables(Context context, Element[] elements, URLFilter filter) {
        int i;
        String viewType = VCSContextUtils.getContextViewType(context);
        if (viewType == null) {
            viewType = "ViewTypeThatDoesNotExist";
        }
        LinkedHashSet<Object> expandedElements = new LinkedHashSet<Object>();
        for (i = 0; i < elements.length; ++i) {
            URL[] compositeFileUrls = null;
            if (CompositeFileElementRegistry.isCompositeElement((Element)elements[i], (String)viewType)) {
                compositeFileUrls = CompositeFileElementRegistry.getCompositeFileURLs((Element)elements[i], (String)viewType);
            }
            if (compositeFileUrls != null) {
                ArrayList<URL> compositeFileUrls0 = new ArrayList<URL>(Arrays.asList(compositeFileUrls));
                Iterator itr = compositeFileUrls0.iterator();
                while (itr.hasNext()) {
                    if (URLFileSystem.exists((URL)((URL)itr.next()))) continue;
                    itr.remove();
                }
                compositeFileUrls = compositeFileUrls0.toArray(new URL[0]);
            }
            if (compositeFileUrls != null && compositeFileUrls.length > 0) {
                expandedElements.addAll(Arrays.asList(VCSModelUtils.findOrCreateNodes(compositeFileUrls)));
                continue;
            }
            expandedElements.add(elements[i]);
        }
        elements = expandedElements.toArray(new Element[0]);
        for (i = 0; i < elements.length; ++i) {
            if (!elements[i].getAttributes().isSet(ElementAttributes.DECORATES_DATA_ELEMENT)) continue;
            elements[i] = (Element)elements[i].getData();
        }
        return VCSModelUtils.getValidLocatables(elements, filter);
    }

    public static final String getContextViewType(Context context) {
        if (context == null || context.getView() == null) {
            return null;
        }
        return new ViewId(context.getView().getId()).getType().replaceAll(SUB_PREFIX, "");
    }
}

