/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.SelectFilesConfiguration;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSCollectionUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNodeCommands;
import oracle.jdeveloper.vcs.util.VCSStatusFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public class VCSCommandUtils {
    private static final String SKIP_SAVE_FILES_PERSISTENCE_KEY = "VCS.SaveFilesConfirm";

    private VCSCommandUtils() {
    }

    public static final Collection<Locatable> getFilteredSelection(Locatable[] locatables, VCSStatusCache cache, VCSStatus[] statuses) throws Exception {
        VCSStatus[] statuses2 = (VCSStatus[])VCSCollectionUtils.toArrayType(Arrays.asList(statuses), VCSStatus.class);
        return VCSCommandUtils.getFilteredSelection(locatables, cache, VCSStatusFilters.createStatusFilter(statuses2));
    }

    public static final Collection<Locatable> getFilteredSelection(Locatable[] locatables, VCSStatusCache cache, VCSStatusFilter filter) throws Exception {
        if (locatables.length == 0 || cache == null || filter == null) {
            return new ArrayList<Locatable>(Arrays.asList(locatables));
        }
        URL[] urls = VCSModelUtils.convertNodesToURLs(locatables);
        VCSStatus[] statuses = cache.get(urls);
        ArrayList<Locatable> nodes = new ArrayList<Locatable>();
        for (int i = 0; i < statuses.length; ++i) {
            if (!filter.accept(statuses[i])) continue;
            nodes.add(locatables[i]);
        }
        return nodes;
    }

    public static final Collection<Locatable> getVersionedSelection(Locatable[] locatables, VCSStatusCache cache) throws Exception {
        if (locatables.length == 0) {
            return Collections.emptySet();
        }
        VCSStatus[] statuses = cache.get(VCSModelUtils.convertNodesToURLs(locatables));
        ArrayList<Locatable> nodes = new ArrayList<Locatable>();
        for (int i = 0; i < statuses.length; ++i) {
            if (!statuses[i].isVersioned()) continue;
            nodes.add(locatables[i]);
        }
        return nodes;
    }

    public static final Collection<Locatable> getCandidateSelection(Locatable[] locatables, VCSStatusCache cache) throws Exception {
        if (locatables.length == 0) {
            return Collections.emptySet();
        }
        VCSStatus[] statuses = cache.get(VCSModelUtils.convertNodesToURLs(locatables));
        ArrayList<Locatable> nodes = new ArrayList<Locatable>();
        for (int i = 0; i < statuses.length; ++i) {
            if (!statuses[i].isCandidate()) continue;
            nodes.add(locatables[i]);
        }
        return nodes;
    }

    public static final boolean saveDirtyNodes(Locatable[] locatables) throws Exception {
        return VCSCommandUtils.saveDirtyNodes(locatables, MessageDialog.getPersistence().isHidden(SKIP_SAVE_FILES_PERSISTENCE_KEY), null);
    }

    public static final boolean saveDirtyNodesSilently(Locatable[] locatables) throws Exception {
        return VCSCommandUtils.saveDirtyNodes(locatables, true, null);
    }

    public static final boolean saveDirtyNodes(final Locatable[] locatables, final boolean silent, final String helpTopicId) throws Exception {
        if (!EventQueue.isDispatchThread()) {
            final boolean[] result = new boolean[1];
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public final void run() {
                        try {
                            result[0] = VCSCommandUtils.saveDirtyNodes(locatables, silent, helpTopicId);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                if (ite.getTargetException() instanceof Exception) {
                    throw (Exception)ite.getTargetException();
                }
                ite.printStackTrace();
            }
            return result[0];
        }
        ArrayList<URL> directoryUrls = new ArrayList<URL>();
        Node[] nodes = VCSCommandUtils.getDirtyNodes(locatables, directoryUrls);
        return VCSCommandUtils.saveDirtyNodesImpl(nodes, directoryUrls.toArray(new URL[0]), silent, helpTopicId);
    }

    public static final void closeMissingNodes(Node[] nodes) {
        VCSCommandUtils.closeFilteredNodes(nodes, new URLFilter(){

            public final boolean accept(URL url) {
                return url == null || URLFileSystem.exists((URL)url);
            }
        });
    }

    public static final void removeNonEditableNodes(Collection<?> nodes) {
        Iterator<?> itr = nodes.iterator();
        while (itr.hasNext()) {
            URL url = VCSModelUtils.getLocatableURL(itr.next());
            if (url == null || !VCSFileSystemUtils.isNonEditable(url)) continue;
            itr.remove();
        }
    }

    private static final Node[] getDirtyNodes(Locatable[] locatables, Collection<URL> directoryUrls) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < locatables.length; ++i) {
            URL url = locatables[i].getURL();
            if (url == null) continue;
            if (locatables[i] instanceof Node) {
                nodes.add((Node)locatables[i]);
                continue;
            }
            if (!URLFileSystem.isDirectoryPath((URL)url)) continue;
            directoryUrls.add(url);
        }
        return VCSModelUtils.getDirtyNodes(nodes.toArray(new Node[0]));
    }

    private static final boolean saveDirtyNodesImpl(Node[] nodes, URL[] directoryUrls, boolean silent, String helpTopicId) throws Exception {
        if (nodes.length <= 0) {
            return true;
        }
        if (!silent) {
            SelectFilesConfiguration selectFilesConfiguration = new SelectFilesConfiguration((Component)VCSWindowUtils.getCurrentWindow(), VCSArb.getString(46), VCSArb.format(48, URLFileSystem.getPlatformPathName((URL)nodes[0].getURL())), VCSArb.getString(47), VCSComponents.createCheckBoxListModel(nodes, false), false, 1, helpTopicId);
            selectFilesConfiguration.setOptionalId(SKIP_SAVE_FILES_PERSISTENCE_KEY);
            if (SelectFilesPanel.showDialog((SelectFilesConfiguration)selectFilesConfiguration) != 0) {
                return false;
            }
        }
        for (int i = 0; i < nodes.length; ++i) {
            URL url = nodes[i].getURL();
            if (URLFileSystem.exists((URL)url) && !URLFileSystem.setReadOnly((URL)url, (boolean)false)) continue;
            nodes[i].save();
        }
        return true;
    }

    private static final void closeFilteredNodesImpl(Node[] nodes, URLFilter filter) throws Exception {
        ArrayList<Node> c = new ArrayList<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            if (filter.accept(nodes[i].getURL())) continue;
            c.add(nodes[i]);
        }
        if (c.size() <= 0) {
            return;
        }
        Context context = Context.newIdeContext();
        context.setSelection(c.toArray(new Element[0]));
        Command command = VCSNodeCommands.createQuietCloseNodeCommand(context);
        command.doit();
    }

    private static final void closeFilteredNodes(final Node[] nodes, final URLFilter filter) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                try {
                    VCSCommandUtils.closeFilteredNodesImpl(nodes, filter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

