/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

public class VCSSingleSaveObserver
implements Observer {
    private final VCSStatusCache _cache;

    public VCSSingleSaveObserver(VCSStatusCache cache) {
        this._cache = cache;
    }

    public VCSStatusCache getStatusCache() {
        return this._cache;
    }

    protected boolean isStateChange(URL url) {
        return true;
    }

    protected void clearStatusCache(URL url) {
        URLFilter filter = VCSURLFilters.createSpecificURLFilter(new URL[]{url});
        this._cache.clear(filter);
        filter = VCSURLFilters.createSpecificURLFilter(VCSFileSystemUtils.getParentURLs(url));
        this._cache.clear(filter);
    }

    public void update(Object observed, UpdateMessage change) {
        if (!VCSModelUtils.isElementSaveUpdate(observed, change)) {
            return;
        }
        URL url = VCSModelUtils.getLocatableURL(observed);
        if (url == null) {
            return;
        }
        if (!this.isStateChange(url)) {
            return;
        }
        this.clearStatusCache(url);
    }
}

