/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import oracle.ide.composite.CompositeFileElementEvent;
import oracle.ide.composite.CompositeFileElementListener;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEBMessage;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSNodeUpdate;
import oracle.jdeveloper.vcs.spi.VCSOverlayItem;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public class VCSNodeOverlayTracker
extends IconOverlayTracker
implements Observer,
VCSEBComponent {
    private static final String VCS_OVERLAY_TYPE_ID = "vcsOverlayType";
    private static IconOverlay CONFUSED_COMPOSITE_OVERLAY;
    private final VCSOverlayItemProducer _overlayItemProducer;
    private final URLFilter _filter;
    private final String _vcsId;
    private Observer _controlCacheObserver;
    private final CompositeFileElementListener _compositeListener = new CompositeFileElementListener(){

        public void compositeStateChanged(CompositeFileElementEvent cfee) {
            Element[] compositeElements = cfee.getCompositeElements();
            for (int i = 0; i < compositeElements.length; ++i) {
                VCSNodeOverlayTracker.this.validateOverlay(compositeElements[i]);
            }
            VCSNodeOverlayTracker.this.repaintOverlays();
        }
    };

    private static final IconOverlay getConfusedCompositeOverlay() {
        if (CONFUSED_COMPOSITE_OVERLAY == null) {
            CONFUSED_COMPOSITE_OVERLAY = new IconOverlay(VCSArb.getInstance().getIconImpl(19), null, VCSArb.getString(20));
        }
        return CONFUSED_COMPOSITE_OVERLAY;
    }

    public VCSNodeOverlayTracker(int batchSize, VCSOverlayItemProducer overlayItemProducer, URLFilter filter, String vcsId) {
        super("vcsOverlayType." + vcsId, IconOverlayCache.getInstance(), batchSize);
        this._overlayItemProducer = overlayItemProducer;
        this._filter = filter;
        if (this._overlayItemProducer != null) {
            this._overlayItemProducer.getObservable().addObserver(this);
        }
        CompositeFileElementRegistry.addCompositeListener((CompositeFileElementListener)this._compositeListener);
        VCSEventBus.addToBus(this);
        this._vcsId = vcsId;
    }

    @Override
    public void update(Observable o, Object arg) {
        URL[] urls = (URL[])arg;
        Element[] elements = this.getValidElements();
        List<URL> urls0 = Arrays.asList(urls);
        for (int i = 0; i < elements.length; ++i) {
            URL url = VCSModelUtils.getLocatableURL(elements[i]);
            if (url == null) continue;
            url = URLFactory.replaceRefPart((URL)url, null);
            if (!urls0.contains(url = URLFactory.replaceQueryPart((URL)url, null))) continue;
            this.validateOverlay(elements[i]);
        }
        Element[] compositeElements = CompositeFileElementRegistry.getCachedCompositeElements((URL[])((URL[])arg));
        for (int i = 0; i < compositeElements.length; ++i) {
            this.validateOverlay(compositeElements[i]);
        }
        this.repaintOverlays();
    }

    @Override
    public void handleMessage(VCSEBMessage message) {
        if (!(message instanceof VCSNodeUpdate)) {
            return;
        }
        VCSNodeUpdate nodeUpdate = (VCSNodeUpdate)message;
        if (nodeUpdate.getWhat() == VCSNodeUpdate.RENAMED) {
            this.validateOverlay((Element)nodeUpdate.getNode());
            this.repaintOverlays();
            return;
        }
    }

    protected void startTracking() {
        if (this._controlCacheObserver == null) {
            this._controlCacheObserver = new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    if (arg != null && !arg.equals(VCSNodeOverlayTracker.this._vcsId)) {
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public final void run() {
                            VCSNodeOverlayTracker.this.validateOverlays();
                            VCSNodeOverlayTracker.this.repaintOverlays();
                        }
                    });
                }
            };
        }
        VCSControlCache.getInstance().addObserver(this._controlCacheObserver);
        super.startTracking();
    }

    public void stopTracking() {
        super.stopTracking();
        if (this._overlayItemProducer != null) {
            this._overlayItemProducer.getObservable().deleteObserver(this);
        }
        CompositeFileElementRegistry.removeCompositeListener((CompositeFileElementListener)this._compositeListener);
        VCSEventBus.removeFromBus(this);
        VCSControlCache.getInstance().deleteObserver(this._controlCacheObserver);
    }

    protected boolean isControlled(Element element) {
        if (CompositeFileElementRegistry.isCompositeElement((Element)element)) {
            URL[] compositeFileUrls = this.getCompositeFileURLs(element);
            if (compositeFileUrls == null) {
                return false;
            }
            for (URL url : compositeFileUrls) {
                if (!this.isControlled(url)) continue;
                return true;
            }
            return false;
        }
        return this.isControlled(VCSModelUtils.getLocatableURL(element));
    }

    protected IconOverlay[] getOverlays(Element[] elements) {
        try {
            IconOverlay[] overlays = new IconOverlay[elements.length];
            BitSet compositeElementBits = new BitSet(elements.length);
            ArrayList<Element> singularElements = new ArrayList<Element>();
            for (int i = 0; i < elements.length; ++i) {
                if (CompositeFileElementRegistry.isCompositeElement((Element)elements[i])) {
                    overlays[i] = this.getCompositeElementOverlay(elements[i]);
                    compositeElementBits.set(i);
                    continue;
                }
                singularElements.add(elements[i]);
            }
            URL[] urls = VCSModelUtils.convertNodesToURLs(singularElements.toArray(new Locatable[0]));
            VCSOverlayItem[] overlayItems = new VCSOverlayItem[urls.length];
            this.resolveJarFileURLs(urls);
            BitSet controlledUrlBits = new BitSet(urls.length);
            for (int i = 0; i < urls.length; ++i) {
                if (overlayItems[i] != null || !VCSControlCache.getInstance().isControlled(urls[i], this._vcsId)) continue;
                controlledUrlBits.set(i);
            }
            if (!controlledUrlBits.isEmpty()) {
                ArrayList<URL> controlledUrls = new ArrayList<URL>();
                for (int i = 0; i < urls.length; ++i) {
                    if (!controlledUrlBits.get(i)) continue;
                    controlledUrls.add(urls[i]);
                }
                VCSOverlayItem[] controlledOverlayItems = this._overlayItemProducer.getOverlayItems(controlledUrls.toArray(new URL[0]));
                int j = 0;
                for (int i = 0; i < urls.length; ++i) {
                    if (!controlledUrlBits.get(i)) continue;
                    overlayItems[i] = controlledOverlayItems[j++];
                }
            }
            int j = 0;
            for (int i = 0; i < elements.length; ++i) {
                if (compositeElementBits.get(i)) continue;
                overlays[i] = overlayItems[j] != null ? overlayItems[j].getOverlay() : null;
                ++j;
            }
            return overlays;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IconOverlay getCompositeElementOverlay(URL[] urls) throws Exception {
        VCSOverlayItem[] overlayItems = this._overlayItemProducer.getOverlayItems(urls);
        VCSOverlayItem overlayItem0 = overlayItems[0];
        for (int i = 1; i < overlayItems.length; ++i) {
            if (overlayItems[i].getStatus().equals(overlayItem0.getStatus())) continue;
            return VCSNodeOverlayTracker.getConfusedCompositeOverlay();
        }
        return overlayItem0.getOverlay();
    }

    private boolean isControlled(URL url) {
        return url != null && this._filter.accept(url) && VCSControlCache.getInstance().isControlled(url, this._vcsId);
    }

    private IconOverlay getCompositeElementOverlay(Element element) throws Exception {
        URL[] compositeFileUrls = this.getCompositeFileURLs(element);
        if (compositeFileUrls == null) {
            return null;
        }
        ArrayList<URL> controlledUrls = new ArrayList<URL>();
        for (int i = 0; i < compositeFileUrls.length; ++i) {
            if (!this.isControlled(compositeFileUrls[i]) || URLFileSystem.isDirectoryPath((URL)compositeFileUrls[i]) && !URLFileSystem.exists((URL)compositeFileUrls[i])) continue;
            controlledUrls.add(compositeFileUrls[i]);
        }
        if (controlledUrls.size() <= 0) {
            return null;
        }
        return this.getCompositeElementOverlay(controlledUrls.toArray(new URL[0]));
    }

    private final URL[] getCompositeFileURLs(Element element) {
        URL[] compositeFileUrls = CompositeFileElementRegistry.getCompositeFileURLs((Element)element);
        if (compositeFileUrls == null) {
            return null;
        }
        this.resolveJarFileURLs(compositeFileUrls);
        if (compositeFileUrls.length <= 0) {
            URL url = VCSModelUtils.getLocatableURL(element);
            if (url == null) {
                return null;
            }
            compositeFileUrls = new URL[]{url};
        }
        return compositeFileUrls;
    }

    private final void resolveJarFileURLs(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            if (!JarUtil.isJarURL((URL)urls[i]) || JarUtil.getJarEntry((URL)urls[i]) == null || !JarUtil.getJarEntry((URL)urls[i]).equals("")) continue;
            urls[i] = JarUtil.getJarFileURL((URL)urls[i]);
        }
    }
}

