/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controls.WaitCursor;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Log;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSCommandType;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSStatusFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public abstract class VCSCommand
extends Command {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int ERROR = -1;
    public static final int NOOP = 9;
    private VCSCommandStyle _commandStyle;
    private VCSCommandType _commandType;
    private VCSExceptionHandler _exceptionHandler;
    private static final Log LOG = new Log("vcs");

    protected VCSCommand(int cmdId) {
        super(cmdId, 1);
        this.initializeCommandStyle(VCSCommandStyle.NORMAL);
        this.initializeCommandType(VCSCommandType.BOTH);
    }

    protected VCSCommand(int cmdId, int type) {
        super(cmdId, type);
        this.initializeCommandStyle(VCSCommandStyle.NORMAL);
        this.initializeCommandType(VCSCommandType.BOTH);
    }

    protected VCSCommand(int cmdId, int type, String name) {
        super(cmdId, type, name);
        this.initializeCommandStyle(VCSCommandStyle.NORMAL);
        this.initializeCommandType(VCSCommandType.BOTH);
    }

    protected void initializeCommandStyle(VCSCommandStyle commandStyle) {
        this._commandStyle = commandStyle;
    }

    protected void initializeCommandType(VCSCommandType commandType) {
        this._commandType = commandType;
    }

    public int doit() throws Exception {
        int result;
        Context context = this.getContext();
        int n = result = context != null && context.getBoolean("VCSController.THREAD_AUTHORIZED") && this.isThreaded() ? this.doit2() : this.doit3();
        if (context != null) {
            context.setInt("VCSController.COMMAND_RESULT", result);
        }
        return result;
    }

    public boolean isAvailable() {
        try {
            return this.isAvailableImpl();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public void noOp() {
        try {
            this.noOpImpl();
        }
        catch (VCSException ce) {
            this.getExceptionHandler().handleException(ce);
        }
    }

    protected boolean isAvailableImpl() throws Exception {
        if (this._commandStyle == VCSCommandStyle.NORMAL && this._commandType == VCSCommandType.BOTH) {
            return true;
        }
        return this.isAvailableImpl(this.getContextLocatables());
    }

    protected boolean isAvailableImpl(Locatable[] locatables) throws Exception {
        if (!this.verifyStyle(locatables) || !this.verifyType(locatables)) {
            return false;
        }
        for (int i = 0; i < Math.min(locatables.length, 3); ++i) {
            if (!this.isAvailableImpl(locatables[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isAvailableImpl(Locatable locatable) throws Exception {
        URL url = locatable.getURL();
        if (url == null || this.getURLFilter() != null && !this.getURLFilter().accept(url)) {
            return false;
        }
        return this.isAvailableImpl(url);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (this.getStatusCache() == null || this.getStatusFilter() == null) {
            return true;
        }
        return this.getStatusFilter().accept(this.getStatusCache().get(url));
    }

    private boolean verifyStyle(Locatable[] locatables) {
        if (this._commandStyle == VCSCommandStyle.NORMAL) {
            return true;
        }
        if (this._commandStyle == VCSCommandStyle.MULTI) {
            if (locatables.length <= 0) {
                return false;
            }
            if (locatables.length > 1) {
                return true;
            }
        }
        if (this._commandStyle == VCSCommandStyle.SINGLE) {
            return locatables.length == 1;
        }
        return true;
    }

    private boolean verifyType(Locatable[] locatables) {
        if (this._commandType == VCSCommandType.BOTH) {
            return true;
        }
        if (this._commandType == VCSCommandType.FILE) {
            for (Locatable loc : locatables) {
                if (!URLFileSystem.isDirectoryPath((URL)loc.getURL())) continue;
                return false;
            }
            return true;
        }
        if (this._commandType == VCSCommandType.FOLDER) {
            for (Locatable loc : locatables) {
                if (!URLFileSystem.isRegularFile((URL)loc.getURL())) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    protected void noOpImpl() throws VCSException {
    }

    protected abstract int doitImpl() throws Exception;

    protected VCSExtension getExtension() {
        Object vcs;
        Context context = this.getContext();
        Object object = vcs = context != null ? context.getProperty("VCSController.VCS") : null;
        if (vcs == null) {
            LOG.trace("VCS: Warning... no VCS in context for command " + ((Object)((Object)this)).getClass());
            vcs = context != null ? VCSExtensionUtils.getActiveExtension(context) : null;
        }
        return vcs instanceof VCSExtension ? (VCSExtension)vcs : null;
    }

    protected VCSExceptionHandler getExceptionHandler() {
        if (this._exceptionHandler == null) {
            this._exceptionHandler = new VCSExceptionHandler();
        }
        return this._exceptionHandler;
    }

    protected URLFilter getURLFilter() {
        VCSExtension extension = this.getExtension();
        return extension != null ? extension.getURLFilter() : null;
    }

    protected VCSStatusCache getStatusCache() {
        VCSExtension extension = this.getExtension();
        return extension != null ? extension.getStatusCache() : null;
    }

    protected VCSStatusFilter getStatusFilter() {
        return null;
    }

    protected boolean isThreaded() {
        return false;
    }

    protected final Locatable[] getContextLocatables() {
        return VCSContextUtils.getContextLocatables(this.getContext(), this.getURLFilter());
    }

    protected final Context buildContextForEditor() {
        Context context = new Context(this.getContext());
        Locatable[] locatables = this.getContextLocatables();
        if (locatables.length > 0 && locatables[0] instanceof Node) {
            context.setNode((Node)locatables[0]);
        }
        return context;
    }

    protected final void updateReadOnlyStates(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i].isReadOnly();
        }
    }

    protected final VCSStatusFilter createStatusFilter(VCSStatus[] statuses) {
        return VCSStatusFilters.createStatusFilter(statuses);
    }

    protected final void fireSomeFilesCreated(URL[] urls) {
        ArrayList<URL> urls0 = new ArrayList<URL>();
        for (int i = 0; i < urls.length; ++i) {
            if (!URLFileSystem.exists((URL)urls[i])) continue;
            urls0.add(urls[i]);
        }
        if (!urls0.isEmpty()) {
            VCSFileEventSender.fireFilesCreated(urls0.toArray(new URL[0]));
        }
    }

    protected final void fireSomeFilesDeleted(URL[] urls) {
        ArrayList<URL> urls0 = new ArrayList<URL>();
        for (int i = 0; i < urls.length; ++i) {
            if (URLFileSystem.exists((URL)urls[i])) continue;
            urls0.add(urls[i]);
        }
        if (!urls0.isEmpty()) {
            VCSFileEventSender.fireFilesDeleted(urls0.toArray(new URL[0]));
        }
    }

    protected final void fireFileStructureChanged(URL[] urls) {
        VCSFileEventSender.fireFileStructureChanged(urls);
    }

    protected final Map storeTimestamps(Collection nodes) {
        return VCSBufferUtils.storeTimestamps(nodes);
    }

    protected final void reloadBuffers(Map timestampMap) {
        VCSBufferUtils.reloadBuffers(timestampMap);
    }

    protected final Collection getFilteredSelection() throws Exception {
        return this.getFilteredSelection(this.getContextLocatables());
    }

    protected final Collection getFilteredSelection(Locatable[] locatables) throws Exception {
        return VCSCommandUtils.getFilteredSelection(locatables, this.getStatusCache(), this.getStatusFilter());
    }

    protected URLFilter getLocatableURLFilter() {
        return this.getURLFilter();
    }

    private int doit2() {
        final WaitCursor wc = Ide.getWaitCursor();
        wc.show();
        Thread worker = new Thread("VCSCommand"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    VCSCommand.this.doit3();
                }
                catch (Exception e) {
                    try {
                        ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)e, (String)VCSArb.getString(11), (String)e.getMessage(), null);
                    }
                    catch (Throwable throwable) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                wc.hide();
                            }
                        });
                        throw throwable;
                    }
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        worker.start();
        return 0;
    }

    private int doit3() throws Exception {
        try {
            return this.doitImpl();
        }
        catch (Exception e) {
            if (e instanceof ChangeVetoException) {
                return 1;
            }
            if (!(e instanceof VCSException)) {
                throw e;
            }
            if (e instanceof VCSCancelException) {
                return 1;
            }
            this.getExceptionHandler().handleException(e);
            return -1;
        }
    }
}

