/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSInvokableState;
import oracle.jdeveloper.vcs.util.VCSProcessUtils;

public final class VCSBatchInvokableState
extends VCSInvokableState {
    public VCSBatchInvokableState(URL[] urls) {
        super(Arrays.asList(urls));
    }

    @Override
    public void reset() {
        this._n = this._urls.size();
        this._batches = new ArrayList();
        ArrayList<URL> batch = new ArrayList<URL>();
        for (URL url : this._urls) {
            if (batch.size() < this._maxBatchArguments) {
                batch.add(url);
                continue;
            }
            this.batchUrls(batch);
            batch = new ArrayList();
            batch.add(url);
        }
        if (batch.size() > 0) {
            this.batchUrls(batch);
        }
        this._batchCount = this._batches.size();
    }

    @Override
    protected String getProgressNote(URL parent) {
        Object[] params = new Object[]{String.valueOf(this.getBatchCount() - (this.getBatchesRemainingCount() - 1)), String.valueOf(this.getBatchCount())};
        return VCSArb.format(77, params);
    }

    private void batchUrls(Collection<URL> batch) {
        URL[] urls = batch.toArray(new URL[0]);
        URL[][] urlArgs = VCSProcessUtils.splitCommandArgumentURLs(urls, this._maxBatchArguments, false);
        this._batches.addAll(Arrays.asList(urlArgs));
    }
}

