/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.share;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.ide.wizard.Wizard;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

public class ShareWizard
extends Wizard {
    private static final Collection<Wizard> _wizards = new ArrayList<Wizard>();
    private final int _cmdId;
    private final String _name;
    private final Icon _icon;

    public ShareWizard(String name, Icon icon, int cmdId) {
        this._cmdId = cmdId;
        this._name = name;
        this._icon = icon;
    }

    public boolean isAvailable(Context context) {
        Locatable[] locatables = VCSContextUtils.getContextLocatables(context, this.getURLFilter());
        return locatables.length > 0;
    }

    protected URLFilter getURLFilter() {
        return VCSURLFilters.createFileProtocolFilter();
    }

    public boolean invoke(Context context) {
        try {
            IdeAction.find((int)this._cmdId).performAction(context);
            return true;
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)IdeUtil.getMainWindow(), (Exception)e);
            return false;
        }
    }

    public String getShortLabel() {
        return this._name;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public static final void registerShareWizard(Wizard wizard) {
        _wizards.add(wizard);
    }

    static final Collection<Wizard> getAvailableWizards(Context context) {
        ArrayList<Wizard> wizards = new ArrayList<Wizard>();
        for (Wizard wizard : _wizards) {
            if (!wizard.isAvailable(context)) continue;
            wizards.add(wizard);
        }
        return wizards;
    }
}

