/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.properties;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.properties.PropertiesPanelProvider;
import oracle.jdeveloper.vcs.properties.PropertiesUtil;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public abstract class VersionPropertiesPanelProvider
extends PropertiesPanelProvider {
    private static final URLFilter _localFileFilter = VCSContextUtils.createLocalProtocolFilter();
    private final VCSStatusCache _cache;

    public VersionPropertiesPanelProvider() {
        this(null);
    }

    public VersionPropertiesPanelProvider(VCSStatusCache cache) {
        this._cache = cache;
    }

    @Override
    public String getTabName() {
        return VCSArb.getString(146);
    }

    @Override
    public float getTabWeight() {
        return 1.0f;
    }

    @Override
    public boolean isDefaultTab() {
        return true;
    }

    @Override
    public boolean isHandled(Context context) {
        URL url = this.getContextURL(context);
        if (url == null || !this.isHandledURL(url)) {
            return false;
        }
        try {
            return this._cache == null || this._cache.get(url).isVersioned();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return false;
        }
    }

    protected Element getContextElement(Context context) {
        return PropertiesUtil.getContextElement(context);
    }

    protected URL getContextURL(Context context) {
        Element element = this.getContextElement(context);
        if (element == null) {
            return null;
        }
        String viewType = VCSContextUtils.getContextViewType(context);
        if (CompositeFileElementRegistry.isCompositeElement((Element)element, (String)viewType)) {
            URL[] compositeFileUrls = CompositeFileElementRegistry.getCompositeFileURLs((Element)element, (String)viewType);
            return compositeFileUrls != null && compositeFileUrls.length == 1 ? compositeFileUrls[0] : null;
        }
        return VCSModelUtils.getLocatableURL(element);
    }

    private boolean isHandledURL(URL url) {
        return _localFileFilter.accept(url) && URLFileSystem.exists((URL)url);
    }
}

