/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.patch;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;

public abstract class CreatePatchDialogVetoer
implements VetoableChangeListener {
    private final Component _parent;

    public CreatePatchDialogVetoer(Component parent) {
        this._parent = parent;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)e)) {
            return;
        }
        try {
            this.validateCustomOptions();
        }
        catch (VCSException vcse) {
            this.validationFailed(vcse.getMessage(), e);
        }
        if (!this.isFileTargetSelected()) {
            return;
        }
        URL url = this.getFileTargetURL();
        if (URLFileSystem.isDirectory((URL)url)) {
            this.validationFailed(VCSArb.getString(215), e);
        }
        if (!URLFileSystem.exists((URL)url)) {
            URL parentUrl = URLFileSystem.getParent((URL)url);
            if (!URLFileSystem.exists((URL)parentUrl) && !URLFileSystem.mkdirs((URL)parentUrl)) {
                this.validationFailed(VCSArb.getString(216), e);
            }
            return;
        }
        if (MessageDialog.confirm((Component)this._parent, (Object)VCSArb.format(217, URLFileSystem.getPlatformPathName((URL)url)), (String)VCSArb.getString(218), null)) {
            return;
        }
        this.throwPropertyVetoException(e);
    }

    protected abstract boolean isFileTargetSelected();

    protected abstract URL getFileTargetURL();

    protected void validateCustomOptions() throws VCSException {
    }

    protected void handleException(String message) {
        new VCSExceptionHandler().handleException(new ValidationException(message));
    }

    private void validationFailed(String message, PropertyChangeEvent e) throws PropertyVetoException {
        this.handleException(message);
        this.throwPropertyVetoException(e);
    }

    private void throwPropertyVetoException(PropertyChangeEvent e) throws PropertyVetoException {
        throw new PropertyVetoException("", e);
    }

    private class ValidationException
    extends VCSException {
        ValidationException(String message) {
            super(VCSArb.getString(219), message);
        }
    }
}

