/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.patch;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.compare.CompareManager;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryNode;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryURLHelper;
import oracle.jdevimpl.history.HistoryViewer;
import oracle.jdevimpl.vcs.util.FilePanel;

public abstract class AbstractPatchCommand
extends VCSCommand {
    private static final URLFilter _urlFilter = VCSURLFilters.createFileProtocolFilter();
    private VCSExceptionHandler _exceptionHandler;

    protected AbstractPatchCommand(int cmdId) {
        super(cmdId, 1);
        this.initializeCommandStyle(VCSCommandStyle.NORMAL);
    }

    @Override
    protected VCSExceptionHandler getExceptionHandler() {
        if (this._exceptionHandler == null) {
            this._exceptionHandler = new VCSExceptionHandler();
        }
        return this._exceptionHandler;
    }

    @Override
    protected boolean isAvailableImpl(URL url) throws Exception {
        return super.isAvailableImpl(url) && CompareManager.getCompareManager().isContentComparable(url);
    }

    public Context getContext() {
        Node realNode;
        Context context = super.getContext();
        if (context != null && context.getView() instanceof HistoryViewer) {
            context.setSelection(new Element[]{context.getNode()});
        }
        if (context != null && context.getNode() instanceof VersionHistoryNode && (realNode = NodeFactory.find((URL)VersionHistoryURLHelper.getRealURL(((VersionHistoryNode)context.getNode()).getURL()))) != null) {
            context.setNode(realNode);
            context.setElement((Element)realNode);
            context.setSelection(new Element[]{realNode});
        }
        return context;
    }

    @Override
    protected URLFilter getURLFilter() {
        return _urlFilter;
    }

    protected final Project getContextProject() {
        Locatable[] locatables = this.getContextLocatables();
        ArrayList<Locatable> projects = new ArrayList<Locatable>();
        for (int i = 0; i < locatables.length; ++i) {
            if (!(locatables[i] instanceof Project)) continue;
            projects.add(locatables[i]);
        }
        return projects.size() == 1 ? (Project)projects.iterator().next() : null;
    }

    protected final Locatable[] getProjectFolderNodes(Project project) {
        LinkedHashSet<VCSHashURL> urls = new LinkedHashSet<VCSHashURL>();
        URL projectParentUrl = URLFileSystem.getParent((URL)project.getURL());
        urls.add(new VCSHashURL(projectParentUrl));
        urls.addAll(VCSHashURL.convertFromURLs(Arrays.asList(this.getProjectSourcePathURLs(project))));
        return new LinkedHashSet<Locatable>(Arrays.asList(VCSModelUtils.findOrCreateNodes(VCSHashURL.convertToURLs(urls).toArray(new URL[0])))).toArray(new Locatable[0]);
    }

    private final URL[] getProjectSourcePathURLs(Project project) {
        LinkedHashSet<VCSHashURL> baseDirectoryUrls = new LinkedHashSet<VCSHashURL>();
        baseDirectoryUrls.add(new VCSHashURL(URLFileSystem.getParent((URL)project.getURL())));
        baseDirectoryUrls.addAll(VCSHashURL.convertFromURLs(ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs().asList()));
        return VCSHashURL.convertToURLs(baseDirectoryUrls).toArray(new URL[0]);
    }

    protected Collection processNodesForProjectOperation(Project project, Collection nodes) throws Exception {
        if (nodes.size() <= 1) {
            return nodes;
        }
        Locatable locatableFolder = this.showSelectPatchContextDialog(project, nodes);
        if (locatableFolder == null) {
            return null;
        }
        return Collections.singleton(locatableFolder);
    }

    protected URL getOperationWorkingDirectoryURL(URL[] urls) {
        if (urls.length <= 0) {
            return null;
        }
        if (urls.length == 1) {
            return URLFileSystem.isDirectoryPath((URL)urls[0]) ? urls[0] : URLFileSystem.getParent((URL)urls[0]);
        }
        URL operationWorkingDirectoryUrl = null;
        for (int i = 0; i < urls.length; ++i) {
            URL parentDirectoryUrl = URLFileSystem.getParent((URL)urls[i]);
            if (i <= 0) {
                operationWorkingDirectoryUrl = parentDirectoryUrl;
                continue;
            }
            if (URLFileSystem.equals((URL)operationWorkingDirectoryUrl, (URL)parentDirectoryUrl)) continue;
            return null;
        }
        return operationWorkingDirectoryUrl;
    }

    protected URL[] getOperationURLs(URL[] urls) {
        return urls;
    }

    protected void initializeFileChooserPanel(FilePanel filePanel, URL[] urls) {
        filePanel.setChooseFolders(false);
        filePanel.setURL(this.constructDefaultPatchURL(urls));
        filePanel.setURLFilter((URLFilter)new DefaultURLFilter(VCSArb.getString(150), new String[]{".patch", ".diff"}));
    }

    protected void initializePreferredSizeOfUI(JComponent component) {
        Dimension preferredSize = component.getPreferredSize();
        component.setPreferredSize(new Dimension(Math.max(500, preferredSize.width), preferredSize.height));
    }

    protected Locatable showSelectPatchContextDialog(Project project, Collection nodes) {
        final JEWTDialog dialog = new JEWTDialog(IdeUtil.getMainWindow(), VCSArb.getString(203), 7);
        final JRadioButton projectFileRadioButton = new JRadioButton();
        final JRadioButton projectContentProviderRadioButton = new JRadioButton();
        final JList<Object> projectContentProviderList = new JList<Object>(nodes.toArray());
        JScrollPane projectContentProviderScrollPane = new JScrollPane(projectContentProviderList);
        ResourceUtils.resButton((AbstractButton)projectFileRadioButton, (String)VCSArb.format(204, project.getShortLabel()));
        ResourceUtils.resButton((AbstractButton)projectContentProviderRadioButton, (String)VCSArb.getString(205));
        JPanel panel = new JPanel();
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)projectFileRadioButton, insets, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)projectContentProviderRadioButton, insets, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)projectContentProviderScrollPane, insets, 1, true, true);
        layoutBuilder.nl();
        layoutBuilder.addToPanel((Container)panel);
        this.initializePreferredSizeOfUI(panel);
        Dimension preferredSize = panel.getPreferredSize();
        panel.setPreferredSize(new Dimension(preferredSize.width, 200));
        ButtonGroup bg = new ButtonGroup();
        bg.add(projectFileRadioButton);
        bg.add(projectContentProviderRadioButton);
        projectContentProviderRadioButton.setSelected(true);
        projectContentProviderList.setSelectedIndex(0);
        projectContentProviderList.setSelectionMode(0);
        projectContentProviderList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Locatable locatable = (Locatable)value;
                if (locatable != null) {
                    value = URLFileSystem.getPlatformPathName((URL)locatable.getURL());
                }
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon(UIManager.getIcon("Tree.closedIcon"));
                return this;
            }
        });
        dialog.setInitialFocus((Component)projectContentProviderRadioButton);
        dialog.setContent((Component)panel);
        dialog.setResizable(true);
        class SelectContextEnablementListener
        implements ActionListener,
        ListSelectionListener {
            SelectContextEnablementListener() {
                this.updateComponentsEnabled();
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.updateComponentsEnabled();
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.updateComponentsEnabled();
            }

            private void updateComponentsEnabled() {
                projectContentProviderList.setEnabled(projectContentProviderRadioButton.isSelected());
                dialog.setOKButtonEnabled(projectFileRadioButton.isSelected() || projectContentProviderList.getSelectedValue() != null);
            }
        }
        SelectContextEnablementListener enablementListener = new SelectContextEnablementListener();
        projectFileRadioButton.addActionListener(enablementListener);
        projectContentProviderRadioButton.addActionListener(enablementListener);
        projectContentProviderList.addListSelectionListener(enablementListener);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_scsselectpatchcontext_html");
        if (!VCSDialogRunner.runDialog((JDialog)dialog)) {
            return null;
        }
        return projectFileRadioButton.isSelected() ? project : (Locatable)projectContentProviderList.getSelectedValue();
    }

    protected URL constructDefaultPatchURL(URL[] urls) {
        URL[] operationUrls = this.getOperationURLs(urls);
        URL operationWorkingDirectoryUrl = this.getOperationWorkingDirectoryURL(urls);
        URL patchNameUrl = operationUrls.length == 1 ? operationUrls[0] : operationWorkingDirectoryUrl;
        String fileName = URLFileSystem.getFileName((URL)patchNameUrl);
        if (!fileName.endsWith(".patch")) {
            fileName = fileName + ".patch";
        }
        return URLFactory.newURL((URL)operationWorkingDirectoryUrl, (String)fileName);
    }

    protected void copyStringToClipboard(String s) {
        StringSelection selection = new StringSelection(s);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    protected void saveStringAsURL(String s, String charsetName, URL url) throws IOException {
        OutputStream out = URLFileSystem.openOutputStream((URL)url);
        OutputStreamWriter osw = charsetName != null ? new OutputStreamWriter(out, charsetName) : new OutputStreamWriter(out);
        BufferedWriter bw = new BufferedWriter(osw);
        bw.write(s);
        bw.close();
    }

    protected void savePatchToClipboard(String patchSource) throws VCSException {
        this.copyStringToClipboard(patchSource);
        this.checkPatchSourceEmpty(patchSource);
        MessageDialog.information((Component)VCSWindowUtils.getCurrentWindow(), (Object)VCSArb.getString(229), (String)VCSArb.getString(230), null);
    }

    protected void savePatchToURL(String patchSource, String charsetName, URL patchUrl, boolean openEditor) throws VCSException, IOException, InstantiationException, IllegalAccessException {
        this.saveStringAsURL(patchSource, charsetName, patchUrl);
        Node patchNode = NodeFactory.findOrCreate((URL)patchUrl);
        if (openEditor) {
            this.awtOpenDefaultEditorInFrame(patchUrl);
        }
        if (patchNode != null) {
            this.awtRevertNodeReload(patchNode);
        }
        this.checkPatchSourceEmpty(patchSource);
    }

    protected void checkPatchSourceEmpty(String patchSource) throws VCSException {
        if (!this.isPatchSourceEmpty(patchSource)) {
            return;
        }
        throw new VCSException(VCSArb.getString(220), VCSArb.getString(221));
    }

    protected void awtOpenDefaultEditorInFrame(final URL url) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                EditorManager.getEditorManager().openDefaultEditorInFrame(url);
            }
        });
    }

    protected void awtRevertNodeReload(final Node node) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                RevertNodeCommand.reload((Node)node);
            }
        });
    }

    protected boolean isPatchSourceEmpty(String patchSource) {
        return patchSource.trim().equals("");
    }
}

