/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changeset.cmd;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Collections;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetChangeList;
import oracle.jdeveloper.vcs.changeset.cmd.BaseChangeSetCommand;
import oracle.jdeveloper.vcs.changeset.cmd.CommentTemplatesConfiguration;
import oracle.jdeveloper.vcs.changeset.cmd.NewChangeSetCommand;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;

public class EditChangeSetCommand
extends BaseChangeSetCommand {
    public EditChangeSetCommand() {
        super(ChangeSetChangeList.EDIT_CHANGE_SET_COMMAND_ID, 1);
    }

    public int doit() throws Exception {
        ChangeSetAdapter adapter = this.getContextChangeSetAdapter();
        if (adapter == null) {
            return 1;
        }
        String oldName = this.getContextChangeSetName();
        if (oldName == null) {
            return 1;
        }
        String oldComments = adapter.getChangeSetComments(oldName);
        VCSCommentsCustomizer commentsCustomizer = new VCSCommentsCustomizer();
        CommentTemplatesConfiguration.configure(commentsCustomizer, adapter.getSystemId());
        commentsCustomizer.setSuppressDefaultTemplate(true);
        commentsCustomizer.setOptions(Collections.singletonMap("setting_comments", oldComments));
        NewChangeSetCommand.EditChangeSetPanelUI ui = new NewChangeSetCommand.EditChangeSetPanelUI(commentsCustomizer);
        ui.getNameTextField().setText(oldName);
        JEWTDialog dialog = new JEWTDialog(IdeUtil.getMainWindow(), VCSArb.getString(101));
        dialog.setButtonMask(7);
        dialog.setContent((Component)ui);
        ui.attachToDialog(dialog);
        boolean wasDefault = oldName.equals(adapter.getDefaultChangeSet());
        NewChangeSetCommand.NameValidationListener nvl = new NewChangeSetCommand.NameValidationListener(this.getContext(), ui);
        nvl.setPermissableName(oldName);
        dialog.addVetoableChangeListener((VetoableChangeListener)nvl);
        HelpSystem.getHelpSystem().registerTopic((JComponent)dialog.getContent(), "f1_scseditchangelist_html");
        if (!dialog.runDialog()) {
            return 1;
        }
        String name = ui.getNameTextField().getText();
        String comment = null;
        comment = ui.getUseTitleCheckBox().isSelected() ? name : (String)commentsCustomizer.getOptions().get("setting_comments");
        if (oldName.equals(name)) {
            adapter.setChangeSetComments(name, comment);
        } else {
            URL[] urls = this.getContextChangeSetURLs(oldName);
            adapter.removeFromChangeSet(urls, oldName);
            adapter.addToChangeSet(urls, name);
            adapter.setChangeSetComments(name, comment);
            adapter.fireChangeSetsChanged();
            if (wasDefault) {
                adapter.setDefaultChangeSet(name);
            }
        }
        return 0;
    }
}

