/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changeset;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetException;
import oracle.jdeveloper.vcs.changeset.ChangeSetRegistry;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdevimpl.vcs.changeset.ChangeSetService;

public final class ChangeSetManager {
    private static final ChangeSetManager _instance = new ChangeSetManager();

    private ChangeSetManager() {
    }

    public static final ChangeSetManager getChangeSetManager() {
        return _instance;
    }

    public final String getChangeSetComments(URL[] contextUrls) {
        if (contextUrls == null || contextUrls.length == 0) {
            return null;
        }
        ChangeSetAdapter adapter = this.recognizeChangeSetContext(contextUrls[0]);
        if (adapter == null) {
            return null;
        }
        try {
            Collection<VCSHashURL> hashUrls = VCSHashURL.convertFromURLs(Arrays.asList(contextUrls));
            Map<String, Collection<VCSHashURL>> changesets = adapter.getChangeSets(contextUrls);
            for (Map.Entry<String, Collection<VCSHashURL>> entry : changesets.entrySet()) {
                hashUrls.removeAll(entry.getValue());
            }
            if (hashUrls.isEmpty() && changesets.size() == 1) {
                return adapter.getChangeSetComments(changesets.keySet().iterator().next());
            }
            return null;
        }
        catch (ChangeSetException cse) {
            cse.printStackTrace();
            return null;
        }
    }

    private final ChangeSetAdapter recognizeChangeSetContext(URL url) {
        VCSExtension extension = VCSExtensionUtils.getActiveExtension(url);
        if (extension == null) {
            return null;
        }
        for (String id : ChangeSetRegistry.keySet()) {
            if (!extension.getId().equals(id)) continue;
            return ChangeSetRegistry.lookup(id);
        }
        return null;
    }

    public final void fireChangesCommitted(String vcsId, URL[] urls, boolean recursive) {
        ChangeSetService.getInstance().fireChangesCommitted(vcsId, urls, recursive);
    }
}

