/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changeset;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.IdeAction;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSRegistry;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.vcs.changeset.ChangeSetEvent;
import oracle.jdeveloper.vcs.changeset.ChangeSetException;
import oracle.jdeveloper.vcs.changeset.ChangeSetHandler;
import oracle.jdeveloper.vcs.changeset.ChangeSetListener;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCacheListener;

public abstract class ChangeSetAdapter {
    private static final String NAMESPACE_URI = "http://xmlns.oracle.com/ide/changesets";
    private static final String ROOT_TAG = "ide:changesets";
    private static final String N_URLS = "urls";
    private static final String N_COMMENT = "comment";
    private static final String N_CHANGESETS = "changesets";
    private static final String N_DEFAULT = "default";
    private static final String N_EXPIRY = "expiry";
    private HashStructure _hash;
    private final URL _url;
    private final String _vcsId;
    private final ArrayList<ChangeSetListener> _changeSetListeners = new ArrayList();
    private boolean _expiryEnabled;

    public ChangeSetAdapter(String vcsId) {
        this._url = URLFactory.newURL((URL)URLFileSystem.getParent((URL)ClientSetting.findOrCreate((String)vcsId).getURL()), (String)"changesets.xml");
        this._vcsId = vcsId;
    }

    public final String getSystemId() {
        return this._vcsId;
    }

    final void addChangeSetListener(ChangeSetListener l) {
        this._changeSetListeners.add(l);
    }

    public final void addStatusListener(VCSURLBasedCacheListener l) {
        VCS vcs = VCSRegistry.lookup((String)this._vcsId);
        if (vcs instanceof VCSExtension) {
            ((VCSExtension)vcs).getStatusCache().addCacheListener(l);
        }
    }

    public abstract boolean isChanged(VCSStatus var1);

    public synchronized void addToChangeSet(URL[] urls, String name) throws ChangeSetException {
        try {
            this.removeFromChangeSets(urls);
            HashStructure changeset = this.getChangeSetsHash().getOrCreateHashStructure(name);
            ListStructure l = changeset.getOrCreateListStructure(N_URLS);
            for (URL url : urls) {
                l.add((Object)url);
            }
            this.purgeEmptyChangeSets();
            this.updateChangeSetExpiry(name);
            this.saveHash();
        }
        catch (IOException ioe) {
            throw new ChangeSetException(ioe);
        }
    }

    public synchronized void removeFromChangeSet(URL[] urls, String name) throws ChangeSetException {
        try {
            HashStructure changeset = this.getChangeSetsHash().getHashStructure(name);
            if (changeset == null) {
                return;
            }
            ListStructure l = changeset.getOrCreateListStructure(N_URLS);
            for (URL url : urls) {
                l.remove((Object)url);
            }
            this.updateChangeSetExpiry(name);
            if (l.isEmpty()) {
                this.purgeEmptyChangeSet(name);
            }
            this.saveHash();
        }
        catch (IOException ioe) {
            throw new ChangeSetException(ioe);
        }
    }

    private final synchronized void removeFromChangeSets(URL[] urls) throws IOException {
        HashMap<String, ArrayList<URL>> removeUrlsByName = new HashMap<String, ArrayList<URL>>();
        URLIterator itr = new URLIterator(this.getChangeSetsHash());
        block0: while (itr.hasNext()) {
            URL setUrl = itr.next();
            for (URL url : urls) {
                if (!URLFileSystem.equals((URL)setUrl, (URL)url)) continue;
                String name = itr.getChangeSetName();
                this.updateChangeSetExpiry(name);
                ArrayList<URL> removeUrls = (ArrayList<URL>)removeUrlsByName.get(name);
                if (removeUrls == null) {
                    removeUrls = new ArrayList<URL>();
                    removeUrlsByName.put(name, removeUrls);
                }
                removeUrls.add(setUrl);
                continue block0;
            }
        }
        for (Map.Entry entry : removeUrlsByName.entrySet()) {
            HashStructure changeset = this.getChangeSetsHash().getHashStructure((String)entry.getKey());
            ListStructure l = changeset.getListStructure(N_URLS);
            l.removeAll((Collection)entry.getValue());
        }
    }

    public final synchronized Map<String, Collection<VCSHashURL>> getChangeSets(URL[] urls) throws ChangeSetException {
        return this.getChangeSets(urls, false);
    }

    public final synchronized Map<String, Collection<VCSHashURL>> getChangeSets(URL[] urls, boolean recursive) throws ChangeSetException {
        final LinkedHashMap<String, Collection<VCSHashURL>> changesets = new LinkedHashMap<String, Collection<VCSHashURL>>();
        this.getChangeSetsImpl(urls, new ChangeSetHandler(){

            @Override
            public final void handle(URL url, String name) {
                ArrayList<VCSHashURL> urls = (ArrayList<VCSHashURL>)changesets.get(name);
                if (urls == null) {
                    urls = new ArrayList<VCSHashURL>();
                    changesets.put(name, urls);
                }
                urls.add(new VCSHashURL(url));
            }
        }, recursive);
        return changesets;
    }

    public final synchronized void setChangeSetComments(String name, String comment) throws ChangeSetException {
        try {
            HashStructure changeset = this.getChangeSetsHash().getOrCreateHashStructure(name);
            changeset.putString(N_COMMENT, comment);
            this.updateChangeSetExpiry(name);
            this.saveHash();
        }
        catch (IOException ioe) {
            throw new ChangeSetException(ioe);
        }
    }

    public synchronized URL[] getChangeSetURLs(String name, URL[] contextUrls) throws ChangeSetException {
        try {
            HashStructure changeset = this.getChangeSetsHash().getHashStructure(name);
            ListStructure l = changeset != null ? changeset.getListStructure(N_URLS) : null;
            return l != null ? (URL[])l.toArray((Object[])new URL[0]) : new URL[]{};
        }
        catch (IOException ioe) {
            throw new ChangeSetException(ioe);
        }
    }

    public final synchronized String getChangeSetComments(String name) throws ChangeSetException {
        try {
            HashStructure changeset = this.getChangeSetsHash().getHashStructure(name);
            return changeset != null ? changeset.getString(N_COMMENT) : null;
        }
        catch (IOException ioe) {
            throw new ChangeSetException(ioe);
        }
    }

    public final void fireChangeSetsChanged() {
        ChangeSetEvent cse = new ChangeSetEvent(this);
        for (int i = this._changeSetListeners.size() - 1; i >= 0; --i) {
            this._changeSetListeners.get(i).changeSetsChanged(cse);
        }
    }

    public final void fireDefaultChangeSetChanged() {
        ChangeSetEvent cse = new ChangeSetEvent(this);
        for (int i = this._changeSetListeners.size() - 1; i >= 0; --i) {
            this._changeSetListeners.get(i).defaultChangeSetChanged(cse);
        }
    }

    public final synchronized void setDefaultChangeSet(String name) throws ChangeSetException {
        try {
            if (name != null) {
                this.getHash().putString(N_DEFAULT, name);
                this.updateChangeSetExpiry(name);
            } else {
                this.getHash().remove(N_DEFAULT);
            }
            this.saveHash();
            this.fireDefaultChangeSetChanged();
        }
        catch (IOException ioe) {
            throw new ChangeSetException(ioe);
        }
    }

    public final synchronized String getDefaultChangeSet() throws ChangeSetException {
        try {
            return this.getHash().getString(N_DEFAULT);
        }
        catch (IOException ioe) {
            throw new ChangeSetException(ioe);
        }
    }

    public final void handlePending(URL[] urls) throws ChangeSetException {
        String name = this.getDefaultChangeSet();
        if (name == null) {
            return;
        }
        Collection<VCSHashURL> urls0 = VCSHashURL.convertFromURLs(Arrays.asList(urls));
        Map<String, Collection<VCSHashURL>> changesets = this.getChangeSets(urls);
        for (Map.Entry<String, Collection<VCSHashURL>> entry : changesets.entrySet()) {
            urls0.removeAll(entry.getValue());
        }
        if (!urls0.isEmpty()) {
            this.addToChangeSet(VCSHashURL.convertToURLs(urls0).toArray(new URL[urls0.size()]), name);
        }
    }

    public void handleCommitted(URL[] urls) throws ChangeSetException {
        try {
            this.removeFromChangeSets(urls);
            this.purgeEmptyChangeSets();
            this.saveHash();
        }
        catch (IOException ioe) {
            throw new ChangeSetException(ioe);
        }
    }

    public void handleRenamed(URL oldUrl, URL newUrl) throws ChangeSetException {
    }

    protected synchronized void getChangeSetsImpl(URL[] urls, ChangeSetHandler handler, boolean recursive) throws ChangeSetException {
        try {
            URLIterator itr = new URLIterator(this.getChangeSetsHash());
            while (itr.hasNext()) {
                URL setUrl = itr.next();
                for (URL url : urls) {
                    if (URLFileSystem.isDirectoryPath((URL)url)) {
                        if (!recursive || !URLFileSystem.isBaseURLFor((URL)url, (URL)setUrl)) continue;
                        handler.handle(setUrl, itr.getChangeSetName());
                        continue;
                    }
                    if (!URLFileSystem.equals((URL)setUrl, (URL)url)) continue;
                    handler.handle(setUrl, itr.getChangeSetName());
                }
            }
        }
        catch (IOException ioe) {
            throw new ChangeSetException(ioe);
        }
    }

    private final synchronized void purgeEmptyChangeSets() throws ChangeSetException, IOException {
        ArrayList<String> namesToPurge = new ArrayList<String>();
        for (String name : this.getChangeSetsHash().keySet()) {
            HashStructure changeset = this.getChangeSetsHash().getHashStructure(name);
            if (changeset == null) {
                return;
            }
            ListStructure l = changeset.getOrCreateListStructure(N_URLS);
            if (!l.isEmpty()) continue;
            namesToPurge.add(name);
        }
        for (String name : namesToPurge) {
            this.purgeEmptyChangeSet(name);
        }
    }

    private final synchronized void purgeEmptyChangeSet(String name) throws ChangeSetException, IOException {
        this.getChangeSetsHash().remove(name);
        if (name.equals(this.getDefaultChangeSet())) {
            this.setDefaultChangeSet(null);
        }
    }

    protected final void setExpiryEnabled(boolean expiryEnabled) {
        this._expiryEnabled = expiryEnabled;
    }

    protected final synchronized void updateChangeSetExpiry(String name) throws IOException {
        HashStructure changeset = this.getChangeSetsHash().getHashStructure(name);
        if (changeset == null) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(1, 1);
        changeset.putLong(N_EXPIRY, cal.getTimeInMillis());
    }

    public abstract IdeAction getCommitAction();

    private final HashStructure getChangeSetsHash() throws IOException {
        HashStructure changeSetsHash = this.getHash().getOrCreateHashStructure(N_CHANGESETS);
        if (!this._expiryEnabled) {
            return changeSetsHash;
        }
        long currentTime = System.currentTimeMillis();
        for (String name : new HashSet(changeSetsHash.keySet())) {
            long expiry;
            HashStructure changeset = changeSetsHash.getHashStructure(name);
            if (!changeset.containsKey(N_EXPIRY) || currentTime <= (expiry = changeset.getLong(N_EXPIRY))) continue;
            changeSetsHash.remove(name);
        }
        return changeSetsHash;
    }

    private final HashStructure getHash() throws IOException {
        if (this._hash == null) {
            if (URLFileSystem.exists((URL)this._url)) {
                HashStructureIO io = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
                this._hash = (HashStructure)io.load(this._url);
            } else {
                this._hash = HashStructure.newInstance();
            }
        }
        return this._hash;
    }

    private final synchronized void saveHash() throws IOException {
        URL parentUrl = URLFileSystem.getParent((URL)this._url);
        if (!URLFileSystem.exists((URL)parentUrl)) {
            URLFileSystem.mkdirs((URL)parentUrl);
        }
        HashStructureIO io = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        io.save(this._url, (Object)this._hash);
    }

    private static final class URLIterator
    implements Iterator<URL> {
        private HashStructure _hash;
        private URL _next;
        private String _lastName;
        private String _nextName;
        private String _name;
        private Iterator _urlItr;
        private Iterator _nameItr;

        URLIterator(HashStructure hash) throws IOException {
            this._hash = hash;
            this.next();
        }

        @Override
        public URL next() {
            URL next = this._next;
            this._lastName = this._nextName;
            this._next = this._next();
            this._nextName = this._name;
            return next;
        }

        private final URL _next() {
            if (this._urlItr != null && this._urlItr.hasNext()) {
                return (URL)this._urlItr.next();
            }
            if (this._nameItr == null) {
                this._nameItr = this._hash.keySet().iterator();
            }
            if (this._nameItr.hasNext()) {
                this._name = (String)this._nameItr.next();
                this._urlItr = this._hash.getOrCreateHashStructure(this._name).getOrCreateListStructure(ChangeSetAdapter.N_URLS).iterator();
                return this._next();
            }
            return null;
        }

        final String getChangeSetName() {
            return this._lastName;
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

