/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist.cmd;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;

public class OpenCommand
extends Command {
    public OpenCommand() {
        super(ChangeListWindow.OPEN_CMD_ID, 1);
    }

    protected OpenCommand(int cmdId) {
        super(cmdId, 1);
    }

    public int doit() throws Exception {
        Context context = this.getContext();
        if (context == null) {
            return -1;
        }
        Context[] contexts = (Context[])context.getProperty("ChangeListWindow.CONTEXTS");
        if (contexts == null) {
            return this._doit(context);
        }
        for (Context context2 : contexts) {
            this._doit(context2);
        }
        return 0;
    }

    private int _doit(Context context) throws Exception {
        URL url;
        Node node = context.getNode();
        if (node == null) {
            if (context.getElement() != null && context.getElement() instanceof ChangeListItem) {
                node = ((ChangeListItem)context.getElement()).findOrCreateNode();
            } else {
                return -1;
            }
        }
        if ((url = node.getURL()) == null) {
            return -1;
        }
        if (URLFileSystem.isDirectoryPath((URL)url)) {
            return -1;
        }
        if ("file".equals(url.getProtocol()) && !URLFileSystem.exists((URL)url)) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)VCSArb.format(84, URLFileSystem.getFileName((URL)url)), (String)VCSArb.getString(85), null, (boolean)false)) {
                return -1;
            }
            try {
                URL parentUrl = URLFileSystem.getParent((URL)url);
                if (!URLFileSystem.exists((URL)parentUrl) && !URLFileSystem.mkdirs((URL)parentUrl)) {
                    return -1;
                }
                if (!new File(URLFileSystem.getPlatformPathName((URL)url)).createNewFile()) {
                    return -1;
                }
            }
            catch (IOException ioe) {
                Assert.printStackTrace((Throwable)ioe);
            }
        }
        oracle.ide.cmd.OpenCommand oc = new oracle.ide.cmd.OpenCommand();
        oc.setContext(context);
        oc.openURL(url);
        return 0;
    }

    protected void openDefaultEditorInFrame(Context context) {
        EditorManager.getEditorManager().openDefaultEditorInFrame(context);
    }
}

