/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.Assert;
import oracle.ideri.util.Product;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSCollectionUtils;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;

public class ChangeListContextMenuListener
implements ContextMenuListener {
    private final ChangeList _changeList;

    public ChangeListContextMenuListener(ChangeList changeList) {
        this._changeList = changeList;
    }

    public ChangeList getChangeList() {
        return this._changeList;
    }

    public boolean handleDefaultAction(Context context) {
        if (!(context.getView() instanceof ChangeListWindow)) {
            return false;
        }
        if (this.getContextChangeList(context) != this._changeList) {
            return false;
        }
        return this.handleDefaultActionImpl(context);
    }

    protected boolean handleDefaultActionImpl(Context context) {
        if (!this._changeList.isFocusInOptions() && this.getLocatableSelection(context) != null && this.getLocatableSelection(context).length == 1) {
            Context newContext = context;
            try {
                Node n;
                if (context.getSelection()[0] instanceof ChangeListItem && (n = ((ChangeListItem)context.getSelection()[0]).findOrCreateNode()) != null) {
                    newContext = new Context(context);
                    newContext.setSelection(new Element[]{n});
                    newContext.setNode(n);
                }
                this.getDefaultAction(newContext).performAction(newContext);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        return false;
    }

    protected IdeAction getDefaultAction(Context context) {
        return this.getDefaultAction();
    }

    protected IdeAction getDefaultAction() {
        return IdeAction.find((int)ChangeListWindow.OPEN_CMD_ID);
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public void menuWillShow(ContextMenu popup) {
        if (!(popup.getContext().getView() instanceof ChangeListWindow)) {
            return;
        }
        if (this.getContextChangeList(popup.getContext()) != this._changeList) {
            return;
        }
        VCSOptionsCustomizer optionsCustomizer = this.getChangeList().getOptionsCustomizer();
        if (optionsCustomizer instanceof ChangeListCommentsCustomizer && optionsCustomizer.getComponent().isShowing()) {
            Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            ChangeListCommentsCustomizer commentsCustomizer = (ChangeListCommentsCustomizer)optionsCustomizer;
            if (commentsCustomizer.isShowTemplatesAndCommentsCombo() && c != null && SwingUtilities.isDescendingFrom(c, optionsCustomizer.getComponent())) {
                popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)ChangeListWindow.SET_COMMENTS_CMD_ID)), 2.1f);
            }
        }
        if (!Boolean.getBoolean("ide.vcs.noapplications") && !Product.isRaptor()) {
            popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)ChangeListWindow.SET_SCOPE_CMD_ID)), 2.1f);
        }
        if (this.getChangeList().isFocusInOptions()) {
            popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)17)), 3.0f);
            popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)18)), 3.0f);
            popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)19)), 3.0f);
        }
        if (this.getChangeList().getOptionsCustomizer() instanceof ChangeListCommentsCustomizer) {
            popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)ChangeListWindow.TOGGLE_COMMENTS_CMD_ID)), 5.0f);
        }
        if (!this.getChangeList().isFocusInOptions()) {
            this.addMenuItemCopyFileList(popup);
            this.addMenuItemRefresh(popup);
            this.addMenuItemSelectInNavigator(popup);
        }
        JMenu goToMenu = popup.createSubMenu(VCSArb.getString(264), null);
        popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)70)), goToMenu);
        popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)71)), goToMenu);
        popup.add((Component)goToMenu, 10.05f);
        this.addCategoryMenuItems(popup);
        this.menuWillShowImpl(popup);
    }

    protected void addCategoryMenuItems(ContextMenu popup) {
    }

    protected void menuWillShowImpl(ContextMenu popup) {
    }

    protected final void addMenuItemCopyFileList(ContextMenu popup) {
        if (popup.getIndexOfCommandId(popup.getGUI(true), ChangeListWindow.COPY_FILE_LIST_CMD_ID) >= 0) {
            return;
        }
        popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)ChangeListWindow.COPY_FILE_LIST_CMD_ID)), 3.0f);
    }

    protected final void addMenuItemSelectInNavigator(ContextMenu popup) {
        if (this.getLocatableSelection(popup.getContext()).length != 1 || popup.getContext().getNode() == null) {
            return;
        }
        if (popup.getContext().getNode() instanceof Workspace || popup.getContext().getNode() instanceof Project) {
            return;
        }
        if (popup.getIndexOfCommandId(popup.getGUI(true), 57) >= 0) {
            return;
        }
        popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)57)), 10.0f);
    }

    protected final void addMenuItemRefresh(ContextMenu popup) {
        if (popup.getIndexOfCommandId(popup.getGUI(true), 51) >= 0) {
            return;
        }
        popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)51)), 9.9f);
    }

    protected final void addMenuItemCompare(ContextMenu popup) {
        CompareViewer cv = CompareViewer.get();
        if (cv == null) {
            return;
        }
        if (popup.getIndexOfChild(popup.getGUI(true), (Component)cv.getContextCompareMenu()) >= 0) {
            return;
        }
        if (this.getLocatableSelection(popup.getContext()).length <= 0) {
            return;
        }
        ArrayList items = new ArrayList();
        VCSMenuUtils.addCompareSubmenu(items, popup.getContext());
        if (items.isEmpty()) {
            return;
        }
        popup.add((Component)cv.getContextCompareMenu(), 4.0f);
    }

    protected final void addMenuItemPreferences(ContextMenu popup) {
        if (popup.getIndexOfCommandId(popup.getGUI(true), ChangeListWindow.PREFERENCES_CMD_ID) >= 0) {
            return;
        }
        popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)ChangeListWindow.PREFERENCES_CMD_ID)), 10.1f);
    }

    private ChangeList getContextChangeList(Context context) {
        if (!(context.getView() instanceof ChangeListWindow)) {
            return null;
        }
        return ((ChangeListWindow)context.getView()).getContextChangeList();
    }

    protected IdeAction getLocalAction(ContextMenu popup, int cmdId) {
        return this.getLocalAction(popup.getContext(), cmdId);
    }

    protected IdeAction getLocalAction(Context context, int cmdId) {
        return ((ChangeListWindow)context.getView()).getLocalAction(cmdId);
    }

    protected final Locatable[] getLocatableSelection(Context context) {
        return context.getSelection() != null ? (Locatable[])VCSCollectionUtils.toArrayType(Arrays.asList(context.getSelection()), Locatable.class) : null;
    }
}

