/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.annotations;

import java.awt.Color;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

class AnnotationMark
implements Comparable<AnnotationMark> {
    public static Color BASECOLOR = new Color(14413567);
    public static Color SEPERATORCOLOR = Color.BLACK;
    public static Color BORDERCOLOR = Color.YELLOW;
    private LinkedHashSet<Integer> _scopeSet;
    private String _author;
    private String _revision;
    private Date _date;
    private Color _markColor;
    private HashSet<int[]> _scopePairSet;
    private DateFormat _dateFormat;
    private Comparable _comparable;
    private Collection<int[]> _virtualScopePairSet;

    public AnnotationMark(int line, String author, String revision, Date date) {
        this._scopeSet = new LinkedHashSet();
        this.addLineToScope(line);
        this._author = author;
        this._revision = revision;
        this._date = date;
    }

    public AnnotationMark(LinkedHashSet<Integer> scopeSet, String author, String revision, Date date) {
        this._scopeSet = scopeSet;
        this._author = author;
        this._revision = revision;
        this._date = date;
    }

    void setDateFormat(DateFormat dateFormat) {
        this._dateFormat = dateFormat;
    }

    void setComparable(Comparable comparable) {
        this._comparable = comparable;
    }

    @Override
    public int compareTo(AnnotationMark mark) {
        if (this._comparable != null && mark._comparable != null) {
            return this._comparable.compareTo(mark._comparable);
        }
        return this._date.compareTo(mark._date);
    }

    public void addLineToScope(int line) {
        this._scopeSet.add(new Integer(line));
    }

    public boolean inScope(int line) {
        return this._scopeSet.contains(new Integer(line));
    }

    public void createScopePairSet() {
        if (this._scopeSet == null) {
            return;
        }
        this._scopePairSet = new HashSet();
        int previousLine = -1;
        int beginBlockLine = 1;
        int line = 1;
        Iterator it = this._scopeSet.iterator();
        while (it.hasNext()) {
            line = (Integer)it.next();
            if (previousLine == -1) {
                beginBlockLine = line;
                previousLine = line;
            }
            if (this.beginOfBlock(previousLine, line)) {
                this._scopePairSet.add(this.createBlock(beginBlockLine, previousLine));
                beginBlockLine = line;
            }
            if (!it.hasNext()) {
                this._scopePairSet.add(this.createBlock(beginBlockLine, line));
            }
            previousLine = line;
        }
    }

    private boolean beginOfBlock(int previousLine, int line) {
        return Math.abs(previousLine - line) > 1;
    }

    private int[] createBlock(int beginBlockLine, int endBlockLine) {
        int[] newBlock = new int[]{beginBlockLine, endBlockLine};
        return newBlock;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnnotationMark)) {
            return false;
        }
        return this._revision.equals(((AnnotationMark)o).getRevision());
    }

    public int hashCode() {
        return this._revision.hashCode();
    }

    String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._revision);
        sb.append(' ');
        sb.append(this._author);
        if (this._dateFormat != null) {
            sb.append(' ');
            sb.append(this._dateFormat.format(this._date));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._revision);
        sb.append(' ');
        sb.append(this._author);
        sb.append(' ');
        sb.append(this._date.toString());
        return sb.toString();
    }

    public String getRevision() {
        return this._revision;
    }

    public Set<Integer> getScopeSet() {
        return this._scopeSet;
    }

    public void setColor(Color markColor) {
        this._markColor = markColor;
    }

    public Color getColor() {
        return this._markColor;
    }

    public Collection<int[]> getScopePairSet() {
        return this._scopePairSet;
    }

    void setVirtualScopePairSet(Collection<int[]> virtualScopePairSet) {
        this._virtualScopePairSet = virtualScopePairSet;
    }

    Collection<int[]> getVirtualScopePairSet() {
        return this._virtualScopePairSet;
    }
}

