/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.merge.MergeURLFileSystemHelper;
import oracle.jdevimpl.resource.CompareArb;

public class TextMergeNode
extends TextNode {
    private TextBuffer _textBuffer;

    public TextMergeNode(CompareContributor first, CompareContributor second, CompareContributor ancestor) {
        super(MergeURLFileSystemHelper.newMergeURL(first, second, ancestor));
        this.initializeAttributes();
    }

    public TextMergeNode(URL url) {
        this(url, null);
    }

    public TextMergeNode(URL url, TextBuffer textBuffer) {
        super(MergeURLFileSystemHelper.newMergeURL(url));
        this.initializeAttributes();
        this.setTextBuffer(textBuffer);
    }

    private void initializeAttributes() {
        this.getAttributes().unset(ElementAttributes.DELETEABLE);
        this.getAttributes().unset(ElementAttributes.RENAMEABLE);
        this.getAttributes().unset(ElementAttributes.SAVEABLE);
        this.getAttributes().unset(ElementAttributes.EDITOR_SAVEABLE_AS);
    }

    void setTextBuffer(TextBuffer textBuffer) {
        this._textBuffer = textBuffer;
    }

    protected TextBuffer getTextBufferDirectly() {
        return this._textBuffer;
    }

    protected Reader createReader(URL url) {
        return new StringReader(this._textBuffer != null ? this._textBuffer.getString(0, this._textBuffer.getLength()) : "");
    }

    public boolean setReadOnly(boolean readOnly) {
        return true;
    }

    protected boolean isTrackedInNodeCache() {
        return false;
    }

    protected void saveImpl() {
    }

    public Icon getIcon() {
        return CompareArb.getIcon((int)12);
    }

    public boolean isDirty() {
        return false;
    }
}

