/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.file;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.IdeRunner;
import oracle.ide.IdeStarter;
import oracle.ide.model.ContentSet;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.ideimpl.index.boot.MigratorStarter;
import oracle.ideimpl.index.file.DirFileTable;
import oracle.ideimpl.index.file.FileEntry;
import oracle.ideimpl.index.util.ContentSetRoot;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.ProjectLibrary;

public final class MigratorRunner
extends IdeRunner {
    public void runCommand(IdeStarter starter) {
        try {
            MigratorStarter migratorStarter = (MigratorStarter)starter;
            Collection<Project> projects = this.getProjects(migratorStarter.getArguments());
            if (projects.isEmpty()) {
                MigratorRunner.getLogger().severe("No projects to migrate");
                System.exit(1);
            }
            MigratorRunner.migrateIndexes(projects);
            System.exit(0);
        }
        catch (Throwable t) {
            MigratorRunner.getLogger().log(Level.SEVERE, "Unable to migrate", t);
            System.exit(1);
        }
    }

    private static final void migrateIndexes(Collection<Project> projects) {
        for (Project project : projects) {
            MigratorRunner.migrateIndex(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void migrateIndex(Project project) {
        block12: {
            final Logger logger = MigratorRunner.getLogger();
            long start = System.nanoTime();
            final int[] updated = new int[1];
            try {
                Storage storage = Storages.getProjectStorage((Project)project);
                storage.open();
                try {
                    final NameSpace namespace = storage.getNameSpace("$index.FileTable$", 1);
                    if (namespace == null) break block12;
                    try {
                        ContentSet content = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
                        Collection roots = ContentSetRoot.getContentSetRoots((Project)project, (ContentSet)content);
                        for (ContentSetRoot root : roots) {
                            new DirFileTable(project, root.getURL(), root.getFilters()){

                                public boolean updateFileTable() {
                                    this.loadFileTable(namespace);
                                    for (FileEntry file : this.files) {
                                        URL url = this.getFileURL(file);
                                        long lastModified = URLFileSystem.lastModified((URL)url);
                                        if (lastModified <= 0L || file.lastModified == lastModified) continue;
                                        if (logger.isLoggable(Level.FINEST)) {
                                            String path = URLFileSystem.getPlatformPathName((URL)url);
                                            long difference = file.lastModified > lastModified ? file.lastModified - lastModified : lastModified - file.lastModified;
                                            int hours = (int)(difference / 3600000L);
                                            logger.finest("Updating timestamp for " + path + " from " + file.lastModified + " to " + lastModified + " (" + hours + " hour difference)");
                                        }
                                        file.lastModified = lastModified;
                                        updated[0] = updated[0] + 1;
                                    }
                                    if (updated[0] > 0) {
                                        this.saveFileTable(namespace);
                                    }
                                    return true;
                                }
                            }.updateFileTable();
                        }
                    }
                    finally {
                        namespace.close();
                    }
                }
                finally {
                    storage.close();
                }
            }
            finally {
                if (logger.isLoggable(Level.FINE)) {
                    long elapsed = (System.nanoTime() - start) / 100000L;
                    logger.fine("Migrated " + project.getShortLabel() + " in " + elapsed + " milliseconds");
                }
                if (updated[0] > 0) {
                    logger.info("Fixed " + updated[0] + " incorrect timestamps in " + project.getShortLabel());
                }
            }
        }
    }

    private Collection<Project> getProjects(String[] arguments) {
        HashSet<Project> projects = new HashSet<Project>();
        for (String argument : arguments) {
            try {
                this.processArg(argument, projects);
            }
            catch (Throwable t) {
                MigratorRunner.getLogger().log(Level.SEVERE, "Unable to process argument: " + argument, t);
            }
        }
        return projects;
    }

    private void processArg(String argument, Collection<Project> projects) throws Exception {
        URL url = URLFactory.newFileURL((String)argument);
        if (URLFileSystem.exists((URL)url)) {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node instanceof Project) {
                projects.add((Project)node);
            } else if (node instanceof Workspace) {
                Workspace workspace = (Workspace)node;
                Iterator children = workspace.getChildren();
                while (children.hasNext()) {
                    Project project;
                    Object child = children.next();
                    if (!(child instanceof Project) || projects.contains(project = (Project)child)) continue;
                    projects.add(project);
                    DependencyConfiguration dc = DependencyConfiguration.getInstance((Project)project);
                    Iterator deps = dc.getDependencies();
                    while (deps.hasNext()) {
                        Object dependency = deps.next();
                        if (!(dependency instanceof ProjectLibrary)) continue;
                        ProjectLibrary lib = (ProjectLibrary)dependency;
                        projects.add(lib.getProject());
                    }
                }
            } else {
                System.err.println(argument + " is not a JDeveloper Project or Workspace file.");
            }
        } else {
            System.err.println(argument + " not found.");
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(MigratorRunner.class.getName());
    }
}

