/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.transaction.metadataStateManager;

import java.util.HashSet;
import oracle.olapi.transaction.Participant;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionInactiveException;
import oracle.olapi.transaction.TransactionTypeUnavailableException;
import oracle.olapi.transaction.TransactionalObject;
import oracle.olapi.transaction.TransactionalObjectInvalidException;
import oracle.olapi.transaction.WriteLockException;
import oracle.olapi.transaction.metadataStateManager.MetadataState;
import oracle.olapi.transaction.metadataStateManager.MetadataStateHolder;

public class MetadataStateManager
implements TransactionalObject {
    private MetadataStateHolder m_BottomHolder = null;
    private Object m_BottomHolderLock = new Object();
    private HashSet m_Participants = new HashSet(1);

    public MetadataStateManager(MetadataState metadataState, Transaction transaction) throws TransactionTypeUnavailableException, TransactionInactiveException {
        this.setBottomState(metadataState, transaction);
    }

    MetadataStateHolder getBottomHolder() {
        return this.m_BottomHolder;
    }

    private Object getBottomHolderLock() {
        return this.m_BottomHolderLock;
    }

    public final Transaction getActiveTransaction() {
        return this.getBottomHolder().getActiveTransaction();
    }

    public MetadataState getCurrentState(Transaction transaction) throws TransactionTypeUnavailableException, TransactionInactiveException, TransactionalObjectInvalidException {
        return this.getCurrentStateForWrite(transaction);
    }

    public MetadataState getCurrentStateForRead(Transaction transaction) throws TransactionTypeUnavailableException, TransactionInactiveException, TransactionalObjectInvalidException {
        Transaction transaction2 = transaction.getTransactionForMetadataRead();
        MetadataStateHolder metadataStateHolder = this.getCurrentStateHolder(transaction2, true);
        return metadataStateHolder.getState();
    }

    public MetadataState getCurrentStateForRead(Transaction transaction, boolean bl) throws TransactionTypeUnavailableException, TransactionInactiveException, TransactionalObjectInvalidException {
        Transaction transaction2 = transaction.getTransactionForMetadataRead();
        MetadataStateHolder metadataStateHolder = this.getCurrentStateHolder(transaction2, bl);
        if (null != metadataStateHolder) {
            return metadataStateHolder.getState();
        }
        return null;
    }

    public MetadataState getCurrentStateForWrite(Transaction transaction) throws TransactionTypeUnavailableException, TransactionInactiveException, TransactionalObjectInvalidException {
        MetadataState metadataState = this.getCurrentStateForRead(transaction);
        return (MetadataState)metadataState.clone();
    }

    public MetadataState findOrCreateCurrentStateForWrite(Transaction transaction) throws TransactionTypeUnavailableException, TransactionInactiveException, TransactionalObjectInvalidException {
        Transaction transaction2 = transaction.getTransactionForMetadataWrite();
        Object object = this.getBottomHolderLock();
        synchronized (object) {
            MetadataStateHolder metadataStateHolder = this.getBottomHolder();
            if (metadataStateHolder == null) {
                throw new TransactionalObjectInvalidException();
            }
            Transaction transaction3 = metadataStateHolder.getActiveTransaction();
            if (transaction3 != null && transaction3.equals(transaction2)) {
                return metadataStateHolder.getState();
            }
            if (transaction3 == null || transaction3.isAncestorOf(transaction2)) {
                MetadataStateHolder metadataStateHolder2 = this.getCurrentStateHolder(transaction2, true);
                MetadataState metadataState = (MetadataState)metadataStateHolder2.getState().clone();
                this.setBottomState(metadataState, transaction2);
                return metadataState;
            }
            MetadataStateHolder metadataStateHolder3 = metadataStateHolder;
            while (metadataStateHolder3.getParent() != null) {
                metadataStateHolder3 = metadataStateHolder3.getParent();
            }
            Transaction transaction4 = metadataStateHolder3.getActiveTransaction();
            if (transaction4 == null || transaction4.isAncestorOf(transaction2)) {
                throw new WriteLockException(null, transaction, transaction4);
            }
            throw new TransactionalObjectInvalidException();
        }
    }

    private MetadataStateHolder getCurrentStateHolder(Transaction transaction, boolean bl) throws TransactionTypeUnavailableException, TransactionInactiveException, TransactionalObjectInvalidException {
        Transaction transaction2 = transaction.getTransactionForMetadataRead();
        for (MetadataStateHolder metadataStateHolder = this.getBottomHolder(); metadataStateHolder != null; metadataStateHolder = metadataStateHolder.getParent()) {
            Transaction transaction3 = metadataStateHolder.getActiveTransaction();
            if (transaction3 != null && !transaction3.isAncestorOf(transaction2)) continue;
            return metadataStateHolder;
        }
        if (bl) {
            throw new TransactionalObjectInvalidException();
        }
        return null;
    }

    HashSet getParticipants() {
        return this.m_Participants;
    }

    public Transaction getWriteLockTransaction() throws TransactionalObjectInvalidException {
        if (this.getBottomHolder() != null) {
            return this.getBottomHolder().getActiveTransaction();
        }
        throw new TransactionalObjectInvalidException();
    }

    public boolean hasCurrentState(Transaction transaction) throws TransactionTypeUnavailableException, TransactionInactiveException {
        Transaction transaction2 = transaction.getTransactionForMetadataRead();
        for (MetadataStateHolder metadataStateHolder = this.getBottomHolder(); metadataStateHolder != null; metadataStateHolder = metadataStateHolder.getParent()) {
            Transaction transaction3 = metadataStateHolder.getActiveTransaction();
            if (transaction3 != null && !transaction3.isAncestorOf(transaction2)) continue;
            return true;
        }
        return false;
    }

    public final boolean isModified(Transaction transaction) {
        if (null == transaction) {
            return false;
        }
        for (MetadataStateHolder metadataStateHolder = this.getBottomHolder(); metadataStateHolder != null; metadataStateHolder = metadataStateHolder.getParent()) {
            Transaction transaction2 = metadataStateHolder.getActiveTransaction();
            if (transaction2 != transaction) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerParticipant(Participant participant) {
        HashSet hashSet = this.getParticipants();
        synchronized (hashSet) {
            this.getParticipants().add(participant);
        }
    }

    final void setBottomHolder(MetadataStateHolder metadataStateHolder) {
        this.m_BottomHolder = metadataStateHolder;
    }

    private void setBottomState(MetadataState metadataState, Transaction transaction) {
        this.m_BottomHolder = new MetadataStateHolder(metadataState, this, transaction, this.m_BottomHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentState(MetadataState metadataState, Transaction transaction) throws TransactionTypeUnavailableException, TransactionInactiveException, TransactionalObjectInvalidException, WriteLockException {
        Transaction transaction2 = transaction.getTransactionForMetadataWrite();
        Object object = this.getBottomHolderLock();
        synchronized (object) {
            MetadataStateHolder metadataStateHolder = this.getBottomHolder();
            if (metadataStateHolder == null) {
                throw new TransactionalObjectInvalidException();
            }
            Transaction transaction3 = metadataStateHolder.getActiveTransaction();
            if (transaction3 != null && transaction3.equals(transaction2)) {
                metadataStateHolder.setState((MetadataState)metadataState.clone());
            } else if (transaction3 == null || transaction3.isAncestorOf(transaction2)) {
                this.setBottomState((MetadataState)metadataState.clone(), transaction2);
            } else {
                MetadataStateHolder metadataStateHolder2 = metadataStateHolder;
                while (metadataStateHolder2.getParent() != null) {
                    metadataStateHolder2 = metadataStateHolder2.getParent();
                }
                Transaction transaction4 = metadataStateHolder2.getActiveTransaction();
                if (transaction4 == null || transaction4.isAncestorOf(transaction)) {
                    throw new WriteLockException(metadataState, transaction, transaction4);
                }
                throw new TransactionalObjectInvalidException();
            }
        }
    }

    public Object getTransactionalState(Transaction transaction) {
        return this.getCurrentStateForRead(transaction);
    }
}

