/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.transaction.metadataStateManager;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.Participant;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.metadataStateManager.MetadataState;
import oracle.olapi.transaction.metadataStateManager.MetadataStateManager;

final class MetadataStateHolder
implements Participant {
    private MetadataState m_State = null;
    private MetadataStateManager m_Manager = null;
    private Transaction m_ActiveTransaction = null;
    private MetadataStateHolder m_Parent = null;

    public MetadataStateHolder(MetadataState metadataState, MetadataStateManager metadataStateManager, Transaction transaction, MetadataStateHolder metadataStateHolder) {
        this.setState(metadataState);
        this.setManager(metadataStateManager);
        this.setActiveTransaction(transaction);
        this.setParent(metadataStateHolder);
        if (null != transaction) {
            transaction.registerParticipant(this);
        }
    }

    public MetadataState getState() {
        return this.m_State;
    }

    public void setState(MetadataState metadataState) {
        this.m_State = metadataState;
    }

    public Transaction getActiveTransaction() {
        return this.m_ActiveTransaction;
    }

    public void setActiveTransaction(Transaction transaction) {
        this.m_ActiveTransaction = transaction;
    }

    public MetadataStateHolder getParent() {
        return this.m_Parent;
    }

    public void setParent(MetadataStateHolder metadataStateHolder) {
        this.m_Parent = metadataStateHolder;
    }

    private MetadataStateManager getManager() {
        return this.m_Manager;
    }

    private void setManager(MetadataStateManager metadataStateManager) {
        this.m_Manager = metadataStateManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void prepare(Transaction transaction) throws NotCommittableException {
        HashSet hashSet = this.getManager().getParticipants();
        synchronized (hashSet) {
            Iterator iterator = this.getManager().getParticipants().iterator();
            while (iterator.hasNext()) {
                ((Participant)iterator.next()).prepare(transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit(Transaction transaction) {
        HashSet hashSet = this.getManager().getParticipants();
        synchronized (hashSet) {
            Iterator iterator = this.getManager().getParticipants().iterator();
            while (iterator.hasNext()) {
                ((Participant)iterator.next()).commit(transaction);
            }
        }
        this.setActiveTransaction(transaction);
        if (this.getParent() != null && this.getParent().getActiveTransaction() == transaction && transaction != null) {
            transaction.unregisterParticipant(this.getParent());
            this.setParent(this.getParent().getParent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback() {
        HashSet hashSet = this.getManager().getParticipants();
        synchronized (hashSet) {
            ArrayList arrayList = new ArrayList(this.getManager().getParticipants());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((Participant)iterator.next()).rollback();
            }
        }
        if (this.getManager().getBottomHolder() != null) {
            this.getManager().setBottomHolder(this.getManager().getBottomHolder().getParent());
        }
    }
}

