/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.transaction;

import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.NotPreparedException;
import oracle.olapi.transaction.Participant;
import oracle.olapi.transaction.TransactionInactiveException;
import oracle.olapi.transaction.TransactionProvider;
import oracle.olapi.transaction.TransactionTypeUnavailableException;
import oracle.olapi.transaction.UpdateAwareParticipant;

public interface Transaction {
    public static final int STATUS_ACTIVE = 0;
    public static final int STATUS_PREPARING = 1;
    public static final int STATUS_PREPARED = 2;
    public static final int STATUS_COMMITTING = 3;
    public static final int STATUS_COMMITTED = 4;
    public static final int STATUS_ROLLING_BACK = 5;
    public static final int STATUS_ROLLED_BACK = 6;

    public int getStatus();

    public TransactionProvider getTransactionProvider();

    public void registerParticipant(Participant var1) throws TransactionInactiveException;

    public void unregisterParticipant(Participant var1);

    public void registerUpdateAwareParticipant(UpdateAwareParticipant var1) throws TransactionInactiveException;

    public void unregisterUpdateAwareParticipant(UpdateAwareParticipant var1);

    public Transaction getParent();

    public boolean isAncestorOf(Transaction var1);

    public void prepare() throws NotCommittableException, TransactionInactiveException;

    public void commit() throws NotPreparedException, TransactionInactiveException;

    public void rollback() throws NotPreparedException, TransactionInactiveException;

    public Transaction createSubtransaction() throws TransactionInactiveException;

    public Transaction getTransactionForMetadataRead() throws TransactionTypeUnavailableException, TransactionInactiveException;

    public Transaction getTransactionForMetadataWrite() throws TransactionTypeUnavailableException, TransactionInactiveException;

    public Transaction getTransactionForDataRead() throws TransactionTypeUnavailableException, TransactionInactiveException;

    public Transaction getTransactionForDataWrite() throws TransactionTypeUnavailableException, TransactionInactiveException;

    public boolean isTransactionForDataWrite();
}

