/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mtm;

import java.util.Iterator;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.MetadataFactoryException;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mtm.MtmAggregationSpecification;
import oracle.olapi.metadata.mtm.MtmAggregationStep;
import oracle.olapi.metadata.mtm.MtmBaseCube;
import oracle.olapi.metadata.mtm.MtmCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmDimensionMap;
import oracle.olapi.metadata.mtm.MtmObject;
import oracle.olapi.metadata.mtm.MtmObjectVisitor;
import oracle.olapi.metadata.mtm.MtmSolveSpecification;
import oracle.olapi.metadata.mtm.MtmSourceMap;
import oracle.olapi.metadata.mtm.MtmValueExpression;

public class MtmUnsolvedCube
extends MtmBaseCube {
    MtmUnsolvedCube(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    public Object acceptVisitor(MtmObjectVisitor mtmObjectVisitor, Object object) {
        return mtmObjectVisitor.visitMtmUnsolvedCube(this, object);
    }

    public String getAggregationForm() {
        return this.getPropertyStringValue("MvSumType");
    }

    public MtmSolveSpecification getSolveSpecification() {
        MetadataObject metadataObject = this.getPropertyObjectValue("SolveSpec");
        if (metadataObject == null) {
            return null;
        }
        return (MtmSolveSpecification)metadataObject;
    }

    public String getSQLHint() {
        return this.getPropertyStringValue("SQLHint");
    }

    protected String getXMLTagName() {
        return "MtmUnsolvedCube";
    }

    protected boolean initializeProperty(String string, String string2) {
        if (string == "MvSumType" || string == "SQLHint") {
            this.createStringProperty(string, string2);
            return true;
        }
        if (string == "SolveSpec") {
            this.createObjectProperty(string, string2);
            return true;
        }
        return super.initializeProperty(string, string2);
    }

    public void setAggregationForm(String string) {
        this.setPropertyStringValue("MvSumType", string);
    }

    public void setSolveSpecification(MtmSolveSpecification mtmSolveSpecification) {
        if (!this.isServerVersionLaterThan(new int[]{9, 2, 0, 4, 0})) {
            throw new UnsupportedOperationException();
        }
        this.setPropertyObjectValue("SolveSpec", mtmSolveSpecification);
    }

    public void setSQLHint(String string) {
        this.setPropertyStringValue("SQLHint", string);
    }

    public void addDimensionality(MtmCubeDimensionality mtmCubeDimensionality) {
        super.addDimensionality(mtmCubeDimensionality);
        if (this.getSolveSpecification() instanceof MtmAggregationSpecification) {
            MtmAggregationSpecification mtmAggregationSpecification = (MtmAggregationSpecification)this.getSolveSpecification();
            mtmAggregationSpecification.addDimensionMap(mtmCubeDimensionality.getDimensionMap());
        }
    }

    public void removeDimensionality(MtmCubeDimensionality mtmCubeDimensionality) {
        super.removeDimensionality(mtmCubeDimensionality);
        if (this.getSolveSpecification() instanceof MtmAggregationSpecification) {
            MtmAggregationSpecification mtmAggregationSpecification = (MtmAggregationSpecification)this.getSolveSpecification();
            mtmAggregationSpecification.removeDimensionMap(mtmCubeDimensionality.getDimensionMap());
        }
    }

    public void applyAggregationStep(MtmAggregationStep mtmAggregationStep) {
        MtmObject mtmObject;
        Iterator iterator;
        if (mtmAggregationStep.getDimensionMaps().isEmpty()) {
            iterator = this.getDimensionMaps().iterator();
            while (iterator.hasNext()) {
                mtmObject = (MtmDimensionMap)iterator.next();
                mtmAggregationStep.addDimensionMap((MtmDimensionMap)mtmObject);
            }
        }
        iterator = mtmAggregationStep.getDimensionMaps().iterator();
        while (iterator.hasNext()) {
            mtmObject = (MtmDimensionMap)iterator.next();
            if (this.getDimensionMaps().contains(mtmObject)) continue;
            throw new MetadataFactoryException("AggregationDimensionNotInCube_2", ((MtmSourceMap)mtmObject).getMdmSource().getID(), this.getID());
        }
        if (!(this.getSolveSpecification() instanceof MtmAggregationSpecification)) {
            throw new MetadataFactoryException("AggregationSpecificationNotFound_1", this.getID());
        }
        mtmObject = (MtmAggregationSpecification)this.getSolveSpecification();
        ((MtmAggregationSpecification)mtmObject).applyAggregationStep(mtmAggregationStep);
    }

    public void aggregateSimple(MdmHierarchy mdmHierarchy, String string, MtmValueExpression mtmValueExpression) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.m_MetadataProvider).getMtmCustomObjectFactory().createSimpleAggregationStep(mdmHierarchy, string, mtmValueExpression);
        this.applyAggregationStep(mtmAggregationStep);
    }

    public void aggregateSum(MdmHierarchy mdmHierarchy) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.m_MetadataProvider).getMtmCustomObjectFactory().createSumAggregationStep(mdmHierarchy);
        this.applyAggregationStep(mtmAggregationStep);
    }

    public void aggregateFirst(MdmHierarchy mdmHierarchy, boolean bl) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.m_MetadataProvider).getMtmCustomObjectFactory().createFirstAggregationStep(mdmHierarchy, bl);
        this.applyAggregationStep(mtmAggregationStep);
    }

    public void aggregateLast(MdmHierarchy mdmHierarchy, boolean bl) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.m_MetadataProvider).getMtmCustomObjectFactory().createLastAggregationStep(mdmHierarchy, bl);
        this.applyAggregationStep(mtmAggregationStep);
    }

    public void aggregateWeightedAverage(MdmHierarchy mdmHierarchy, MtmValueExpression mtmValueExpression, boolean bl) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.m_MetadataProvider).getMtmCustomObjectFactory().createWeightedAverageAggregationStep(mdmHierarchy, mtmValueExpression, bl);
        this.applyAggregationStep(mtmAggregationStep);
    }

    public void removeAggregation(MdmHierarchy mdmHierarchy) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.m_MetadataProvider).getMtmCustomObjectFactory().createNoAggregationStep(mdmHierarchy);
        this.applyAggregationStep(mtmAggregationStep);
    }
}

