/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mtm;

import java.util.Iterator;
import java.util.List;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mtm.MtmBaseCube;
import oracle.olapi.metadata.mtm.MtmCube;
import oracle.olapi.metadata.mtm.MtmMeasureMap;
import oracle.olapi.metadata.mtm.MtmObjectVisitor;
import oracle.olapi.metadata.mtm.MtmValueExpression;

public class MtmPartitionedCube
extends MtmCube {
    MtmPartitionedCube(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    public Object acceptVisitor(MtmObjectVisitor mtmObjectVisitor, Object object) {
        return mtmObjectVisitor.visitMtmPartitionedCube(this, object);
    }

    public List getBaseCubes() {
        return this.getPropertyListValues("CubeRef");
    }

    public String getCubeName() {
        return this.getPropertyStringValue("CubeID");
    }

    public MtmBaseCube getDefaultBaseCube() {
        return (MtmBaseCube)this.getPropertyObjectValue("DefaultBaseCube");
    }

    public String getDescription() {
        return this.getPropertyStringValue("Description");
    }

    public void setDescription(String string) {
        this.setPropertyStringValue("Description", string);
    }

    protected String getXMLTagName() {
        return "MtmPartitionedCube";
    }

    protected boolean initializeProperty(String string, String string2) {
        if (string == "CubeRef") {
            this.createListProperty(string, string2);
            return true;
        }
        if (string == "CubeID" || string == "Description") {
            this.createStringProperty(string, string2);
            return true;
        }
        if (string == "DefaultBaseCube") {
            this.createObjectProperty(string, string2);
            return true;
        }
        return super.initializeProperty(string, string2);
    }

    void setCubeNAME(String string) {
        this.setPropertyStringValue("CubeID", string);
    }

    public void setDefaultBaseCube(MtmBaseCube mtmBaseCube) {
        if (!this.isServerVersionLaterThan(new int[]{10, 2, 0, 0})) {
            throw new UnsupportedOperationException();
        }
        this.setPropertyObjectValue("DefaultBaseCube", mtmBaseCube);
        mtmBaseCube.setPartitionedCube(this);
    }

    public void addBaseCube(MtmBaseCube mtmBaseCube) {
        this.addToListProperty("CubeRef", mtmBaseCube);
        mtmBaseCube.setPartitionedCube(this);
    }

    public void removeBaseCube(MtmBaseCube mtmBaseCube) {
        this.removeFromListProperty("CubeRef", mtmBaseCube);
    }

    public void addDimension(MdmDimension mdmDimension) {
        this.addToListProperty("DimMapRef", mdmDimension.getSourceMap());
    }

    public void removeDimension(MdmDimension mdmDimension) {
        this.removeFromListProperty("DimMapRef", mdmDimension.getSourceMap());
        Iterator iterator = this.getBaseCubes().iterator();
        while (iterator.hasNext()) {
            MtmBaseCube mtmBaseCube = (MtmBaseCube)iterator.next();
            mtmBaseCube.removeDimension(mdmDimension);
        }
    }

    public void addMeasureMap(MtmMeasureMap mtmMeasureMap) {
        this.addToListProperty("MeasMapRef", mtmMeasureMap);
        mtmMeasureMap.setCube(this);
    }

    public void removeMeasureMap(MtmMeasureMap mtmMeasureMap) {
        this.removeFromListProperty("MeasMapRef", mtmMeasureMap);
        mtmMeasureMap.setCube(null);
    }

    public MdmMeasure createNumericMeasure(String string, MtmValueExpression mtmValueExpression) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createNumericMeasure(string, this, mtmValueExpression);
    }

    public MdmMeasure createNumericMeasure(String string, String string2) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createNumericMeasure(string, this, string2);
    }

    public MdmMeasure createBooleanMeasure(String string, MtmValueExpression mtmValueExpression) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createBooleanMeasure(string, this, mtmValueExpression);
    }

    public MdmMeasure createBooleanMeasure(String string, String string2) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createBooleanMeasure(string, this, string2);
    }

    public MdmMeasure createStringMeasure(String string, MtmValueExpression mtmValueExpression) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createStringMeasure(string, this, mtmValueExpression);
    }

    public MdmMeasure createStringMeasure(String string, String string2) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createStringMeasure(string, this, string2);
    }

    public MdmMeasure createDateMeasure(String string, MtmValueExpression mtmValueExpression) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createDateMeasure(string, this, mtmValueExpression);
    }

    public MdmMeasure createDateMeasure(String string, String string2) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createDateMeasure(string, this, string2);
    }

    public void removeMeasure(MdmMeasure mdmMeasure) {
        this.removeMeasureMap((MtmMeasureMap)mdmMeasure.getSourceMap());
    }
}

