/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mtm;

import java.util.Iterator;
import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mtm.MtmCube;
import oracle.olapi.metadata.mtm.MtmCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmDimensionMap;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;
import oracle.olapi.metadata.mtm.MtmTabularSource;
import oracle.olapi.metadata.mtm.MtmValueExpression;

public abstract class MtmBaseCube
extends MtmCube {
    MtmBaseCube(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    public List getDimensionality() {
        return this.getPropertyListValues("DimlRef");
    }

    public MtmTabularSource getTable() {
        return (MtmTabularSource)this.getPropertyObjectValue("Table");
    }

    protected boolean initializeProperty(String string, String string2) {
        if (string == "PartitionedCube") {
            this.createObjectProperty(string, string2);
            return true;
        }
        if (string == "Table") {
            this.createObjectProperty(string, string2);
            return true;
        }
        if (string == "DimlRef") {
            this.createListProperty(string, string2);
            return true;
        }
        return super.initializeProperty(string, string2);
    }

    void setTable(MtmTabularSource mtmTabularSource) {
        this.setPropertyObjectValue("Table", mtmTabularSource);
    }

    public void addMeasure(MdmMeasure mdmMeasure, MtmValueExpression mtmValueExpression) {
        this.addToListProperty("MeasMapRef", mdmMeasure.getMeasureMap());
        if (mtmValueExpression != null) {
            mdmMeasure.getMeasureMap().setMappedExpression(this, mtmValueExpression);
        }
    }

    public void removeMeasure(MdmMeasure mdmMeasure) {
        this.removeFromListProperty("MeasMapRef", mdmMeasure.getMeasureMap());
    }

    public void addDimensionality(MtmCubeDimensionality mtmCubeDimensionality) {
        this.addToListProperty("DimlRef", mtmCubeDimensionality);
        this.addToListProperty("DimMapRef", mtmCubeDimensionality.getDimensionMap());
    }

    public void removeDimensionality(MtmCubeDimensionality mtmCubeDimensionality) {
        this.removeFromListProperty("DimlRef", mtmCubeDimensionality);
        this.removeFromListProperty("DimMapRef", mtmCubeDimensionality.getDimensionMap());
    }

    private MtmCubeDimensionality getDimensionalityForDimension(MdmDimension mdmDimension) {
        Iterator iterator = this.getDimensionality().iterator();
        while (iterator.hasNext()) {
            MtmCubeDimensionality mtmCubeDimensionality = (MtmCubeDimensionality)iterator.next();
            if (mtmCubeDimensionality.getDimensionMap().getMdmSource() != mdmDimension) continue;
            return mtmCubeDimensionality;
        }
        return null;
    }

    public void removeDimension(MdmDimension mdmDimension) {
        MtmCubeDimensionality mtmCubeDimensionality = this.getDimensionalityForDimension(mdmDimension);
        if (mtmCubeDimensionality != null) {
            this.removeDimensionality(mtmCubeDimensionality);
        }
        this.removeFromListProperty("DimMapRef", (MtmDimensionMap)mdmDimension.getSourceMap());
    }

    public MtmPartitionedCube getPartitionedCube() {
        return (MtmPartitionedCube)this.getPropertyObjectValue("PartitionedCube");
    }

    void setPartitionedCube(MtmPartitionedCube mtmPartitionedCube) {
        this.setPropertyObjectValue("PartitionedCube", mtmPartitionedCube);
    }
}

