/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.List;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmModel;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmSourceDefinition;
import oracle.olapi.metadata.mtm.MtmSourceMap;
import oracle.olapi.transaction.Transaction;

public abstract class MdmSource
extends MdmObject {
    private SourceDefinition _sourceDefinition;

    public FundamentalMetadataObject getDataType() {
        try {
            for (MetadataObject metadataObject = this; metadataObject != null; metadataObject = metadataObject.getType()) {
                if (!(metadataObject instanceof FundamentalMetadataObject)) continue;
                return (FundamentalMetadataObject)metadataObject;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public final MdmModel getModel() {
        return (MdmModel)this.getPropertyObjectValue("Model");
    }

    public final MtmSourceMap getSourceMap() throws MetadataNotFoundException {
        return (MtmSourceMap)this.getPropertyObjectValue("MetaDataMap");
    }

    public final Source getSource() {
        if (null == this.getSourceDefinition()) {
            this.initializeSourceDefinition();
        }
        return this.getSourceDefinition().getSource();
    }

    protected final SourceDefinition getSourceDefinition() {
        return this._sourceDefinition;
    }

    public MetadataObject getType() {
        MetadataObject metadataObject = this.getPropertyObjectValue("MdmType");
        if (null == metadataObject) {
            metadataObject = this.getMetadataProvider().getDataProvider().getFundamentalMetadataProvider().getValueDataType();
        }
        return metadataObject;
    }

    protected boolean initializeProperty(String string, String string2) {
        if (string == "MdmType" || string == "MetaDataMap" || string == "Model") {
            this.createObjectProperty(string, string2);
            return true;
        }
        return super.initializeProperty(string, string2);
    }

    void initializeSourceDefinition() {
        this.setSourceDefinition(new MdmSourceDefinition(this.getMetadataProvider(), this, this.getMetadataProvider().getDataProvider()));
    }

    protected final void setSourceDefinition(SourceDefinition sourceDefinition) {
        this._sourceDefinition = sourceDefinition;
    }

    final void setSourceMap(MtmSourceMap mtmSourceMap) {
        this.setPropertyObjectValue("MetaDataMap", mtmSourceMap);
        mtmSourceMap.setMdmSource(this);
    }

    public void setType(MetadataObject metadataObject) {
        this.setPropertyObjectValue("MdmType", metadataObject);
        if (this.getModel() != null) {
            this.getModel().setDefaultPrecedence(this.getModel().getDefaultPrecedence());
        }
    }

    public final void setModel(MdmModel mdmModel) {
        this.setPropertyObjectValue("Model", mdmModel);
    }

    public void gatherReferencedSources(List list, Transaction transaction) {
        if (this.getSourceMap() == null) {
            list.add(this.getSource());
        }
        super.gatherReferencedSources(list, transaction);
    }

    protected void appendAdditionalXMLAttributes(MetadataToXMLConverter metadataToXMLConverter) {
        if (this.getSourceMap() == null) {
            metadataToXMLConverter.appendAttribute("SourceDefRef", this.getSourceDefinition().getID());
        }
        super.appendAdditionalXMLAttributes(metadataToXMLConverter);
    }

    MdmSource(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }
}

