/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.metadata.mdm.MdmDimensionedObject;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmMember;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mtm.MtmMeasureMap;

public class MdmMeasure
extends MdmDimensionedObject
implements MdmMember {
    public MtmMeasureMap getMeasureMap() throws MetadataNotFoundException {
        return (MtmMeasureMap)this.getSourceMap();
    }

    protected String getXMLTagName() {
        return "MdmMeasure";
    }

    MdmMeasure(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public String getValue() {
        if (this.getSourceMap() != null) {
            return this.getSource().getID();
        }
        return this.getMetadataProvider().getDataProvider()._getSourceIDProvider().createHiddenID(this.getMetadataProvider().getID(), this.getID(), this.getMetadataProvider().getDataProvider());
    }

    public String getLocalValue() {
        return this.getName();
    }

    public MdmPrimaryDimension getOwnerDimension() {
        return this.getMeasureDimension();
    }

    public MdmMeasureDimension getMeasureDimension() {
        return this.getMetadataProvider().getRootSchema().getMeasureDimension();
    }

    public MdmLevel getLevel() {
        MdmLevelHierarchy mdmLevelHierarchy = (MdmLevelHierarchy)this.getMeasureDimension().getHierarchies().get(0);
        return (MdmLevel)mdmLevelHierarchy.getLevels().get(0);
    }

    public int getLevelDepth() {
        return 0;
    }

    public String getParentValue() {
        return null;
    }

    public String getParentLocalValue() {
        return null;
    }

    public MdmLevel getParentLevel() {
        return null;
    }

    public int getPrecedence() {
        return this.getPropertyIntegerValue("Precedence", 0);
    }

    public String getValueFormat() {
        return this.getPropertyStringValue("MeasureFormat");
    }

    public void setValueFormat(String string) {
        this.setPropertyStringValue("MeasureFormat", string);
    }

    public String getUnits() {
        String string = this.getPropertyStringValue("MeasureUnits");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setUnits(String string) {
        this.setPropertyStringValue("MeasureUnits", string);
    }

    public void setPrecedence(int n) {
        this.setPropertyIntegerValue("Precedence", n);
    }

    protected boolean initializeProperty(String string, String string2) {
        if (string == "MeasureUnits" || string == "MeasureFormat") {
            this.createStringProperty(string, string2);
            return true;
        }
        if (string == "Precedence") {
            this.createIntegerProperty(string, string2);
            return true;
        }
        return super.initializeProperty(string, string2);
    }

    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        return mdmObjectVisitor.visitMdmMeasure(this, object);
    }
}

