/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.Arrays;
import java.util.Iterator;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmInvalidValueException;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmSubDimension;
import oracle.olapi.metadata.mtm.MtmLevelMap;

public class MdmLevel
extends MdmSubDimension {
    public static final String LEVELTYPE_STANDARD = "STANDARD";
    public static final String LEVELTYPE_YEAR = "YEAR";
    public static final String LEVELTYPE_HALFYEAR = "HALFYEAR";
    public static final String LEVELTYPE_QUARTER = "QUARTER";
    public static final String LEVELTYPE_MONTH = "MONTH";
    public static final String LEVELTYPE_WEEK = "WEEK";
    public static final String LEVELTYPE_DAY = "DAY";
    public static final String LEVELTYPE_HOUR = "HOUR";
    public static final String LEVELTYPE_MINUTE = "MINUTE";
    public static final String LEVELTYPE_SECOND = "SECOND";
    private static String[] levelTypeTranslationMap = new String[]{"STANDARD", "STANDARD", "TIME_YEAR", "YEAR", "TIME_HALFYEAR", "HALFYEAR", "TIME_QUARTER", "QUARTER", "TIME_MONTH", "MONTH", "TIME_WEEK", "WEEK", "TIME_DAY", "DAY", "TIME_HOUR", "HOUR", "TIME_MINUTE", "MINUTE", "TIME_SECOND", "SECOND"};

    MdmLevel(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        return mdmObjectVisitor.visitMdmLevel(this, object);
    }

    public MdmLevelHierarchy getLevelHierarchy() {
        return (MdmLevelHierarchy)this.getPropertyObjectValue("ID");
    }

    public MtmLevelMap getLevelMap() throws MetadataNotFoundException {
        return (MtmLevelMap)this.getSourceMap();
    }

    public String getLevelType() throws MetadataNotFoundException {
        String string = this.getPropertyStringValue("LevelType");
        int n = Arrays.asList(levelTypeTranslationMap).indexOf(string);
        String string2 = n <= 1 || n % 2 != 0 ? LEVELTYPE_STANDARD : levelTypeTranslationMap[n + 1];
        return string2;
    }

    public void setLevelType(String string) throws MdmInvalidValueException {
        int n = Arrays.asList(levelTypeTranslationMap).indexOf(string);
        if (n < 0 || n >= 2 && n % 2 != 1) {
            throw new MdmInvalidValueException();
        }
        String string2 = levelTypeTranslationMap[n - 1];
        this.setPropertyStringValue("LevelType", string2);
    }

    protected String getXMLTagName() {
        return "MdmLevel";
    }

    protected boolean initializeProperty(String string, String string2) {
        if (string == "ID") {
            this.createObjectProperty(string, string2);
            return true;
        }
        if (string == "PluralDesc" || string == "LevelType") {
            this.createStringProperty(string, string2);
            return true;
        }
        return super.initializeProperty(string, string2);
    }

    public MdmDimension getEnclosingDimension() {
        return this.getLevelHierarchy();
    }

    void setLevelHierarchy(MdmLevelHierarchy mdmLevelHierarchy) {
        this.setPropertyObjectValue("ID", mdmLevelHierarchy);
    }

    public int getLevelDepth() {
        Iterator iterator = this.getLevelHierarchy().getLevels().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            MdmLevel mdmLevel = (MdmLevel)iterator.next();
            if (mdmLevel == this) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

