/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.olapi.data.source.Assignment;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.LiteralQualification;
import oracle.olapi.data.source.Qualification;
import oracle.olapi.data.source.Source;
import oracle.olapi.metadata.mdm.Mdm10_1_0_3_ObjectVisitor;
import oracle.olapi.metadata.mdm.MdmMember;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmModel;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSource;

public class MdmDimensionCalculationModel
extends MdmModel {
    public MdmDimensionCalculationModel(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    protected String getXMLTagName() {
        return "MdmDimensionCalculationModel";
    }

    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        Mdm10_1_0_3_ObjectVisitor mdm10_1_0_3_ObjectVisitor = null;
        try {
            mdm10_1_0_3_ObjectVisitor = (Mdm10_1_0_3_ObjectVisitor)mdmObjectVisitor;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return mdm10_1_0_3_ObjectVisitor.visitMdmDimensionCalculationModel(this, object);
    }

    public final MdmPrimaryDimension getMdmDimension() {
        return (MdmPrimaryDimension)this.getPropertyObjectValue("DimRef");
    }

    public final MdmSource getMdmSource() {
        return this.getMdmDimension();
    }

    public final FundamentalMetadataObject getDataType() {
        return (FundamentalMetadataObject)this.getPropertyObjectValue("MdmType");
    }

    public final Source getType() {
        return this.getDataType().getSource();
    }

    public final List getInputs() {
        ArrayList<Source> arrayList = new ArrayList<Source>();
        arrayList.add(this.getMdmDimension().getSource());
        return arrayList;
    }

    public final List getParentModels() {
        ArrayList<MdmDimensionCalculationModel> arrayList = new ArrayList<MdmDimensionCalculationModel>();
        if (this.getDataType() == this.getType().getDataProvider().getFundamentalMetadataProvider().getValueDataType()) {
            arrayList.add(this.getMdmDimension().getBooleanCalcModel());
            arrayList.add(this.getMdmDimension().getStringCalcModel());
            arrayList.add(this.getMdmDimension().getDateCalcModel());
            arrayList.add(this.getMdmDimension().getNumberCalcModel());
        }
        return arrayList;
    }

    public void setDataType(FundamentalMetadataObject fundamentalMetadataObject) {
        this.setPropertyObjectValue("MdmType", fundamentalMetadataObject);
    }

    public void setMdmDimension(MdmPrimaryDimension mdmPrimaryDimension) {
        this.setPropertyObjectValue("DimRef", mdmPrimaryDimension);
    }

    protected boolean initializeProperty(String string, String string2) {
        if (string == "MdmType" || string == "DimRef") {
            this.createObjectProperty(string, string2);
            return true;
        }
        return super.initializeProperty(string, string2);
    }

    public List getAutoAssignments() {
        ArrayList<Assignment> arrayList = new ArrayList<Assignment>();
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getType().getDataProvider().getFundamentalMetadataProvider();
        Iterator iterator = this.getMdmDimension().getMembers().iterator();
        while (iterator.hasNext()) {
            MdmMember mdmMember = (MdmMember)iterator.next();
            if (this.getDataType() != mdmMember.getDataType() && !mdmMember.getDataType().getSource().isSubtypeOf(this.getDataType().getSource())) continue;
            LiteralQualification literalQualification = new LiteralQualification(this.getMdmDimension().getSource(), mdmMember.getValue());
            Assignment assignment = new Assignment(this, new Qualification[]{literalQualification}, mdmMember.getSource(), mdmMember.getPrecedence());
            arrayList.add(assignment);
        }
        return arrayList;
    }
}

