/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.Date;
import java.util.Iterator;
import oracle.express.olapi.data.full.ExpressDataProvider;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.internal.CopyException;
import oracle.olapi.internal.DeepCopyPolicy;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataFactoryException;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.mdm.Mdm10_1_0_3_NamingConvention;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmAttributeModel;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionCalculationModel;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmMeasureModel;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmModel;
import oracle.olapi.metadata.mdm.MdmNamingConvention;
import oracle.olapi.metadata.mdm.MdmObjectFactory;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.metadata.mdm.MdmSourceDefinition;
import oracle.olapi.metadata.mdm.MdmStandardDimension;
import oracle.olapi.metadata.mdm.MdmStandardMember;
import oracle.olapi.metadata.mdm.MdmTimeDimension;
import oracle.olapi.metadata.mdm.MdmTimeMember;
import oracle.olapi.metadata.mdm.MdmValueHierarchy;
import oracle.olapi.metadata.mtm.MtmAWColumnExpression;
import oracle.olapi.metadata.mtm.MtmBaseCube;
import oracle.olapi.metadata.mtm.MtmColumnExpression;
import oracle.olapi.metadata.mtm.MtmCustomExpression;
import oracle.olapi.metadata.mtm.MtmCustomObjectFactory;
import oracle.olapi.metadata.mtm.MtmDerivedAttributeMap;
import oracle.olapi.metadata.mtm.MtmDimensionMap;
import oracle.olapi.metadata.mtm.MtmDimensionOrderSpecification;
import oracle.olapi.metadata.mtm.MtmExpression;
import oracle.olapi.metadata.mtm.MtmLevelHierarchyMap;
import oracle.olapi.metadata.mtm.MtmLevelMap;
import oracle.olapi.metadata.mtm.MtmMeasureMap;
import oracle.olapi.metadata.mtm.MtmObjectFactory;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;
import oracle.olapi.metadata.mtm.MtmPrimaryDimensionMap;
import oracle.olapi.metadata.mtm.MtmRDBMSColumnExpression;
import oracle.olapi.metadata.mtm.MtmSolvedLevelHierarchyMap;
import oracle.olapi.metadata.mtm.MtmSourceMap;
import oracle.olapi.metadata.mtm.MtmStoredAttributeMap;
import oracle.olapi.metadata.mtm.MtmTabularSource;
import oracle.olapi.metadata.mtm.MtmUnsolvedLevelHierarchyMap;
import oracle.olapi.metadata.mtm.MtmValueExpression;
import oracle.olapi.metadata.mtm.MtmValueLevelHierarchyMap;

public final class MdmCustomObjectFactory {
    private MdmMetadataProvider m_MdmMetadataProvider = null;

    public MdmCustomObjectFactory(MdmMetadataProvider mdmMetadataProvider) {
        this.setMdmMetadataProvider(mdmMetadataProvider);
    }

    public boolean isCustomObjectFactorySupported() {
        return ((ExpressDataProvider)this.getMdmMetadataProvider().getDataProvider()).isServerVersionLaterThan(new int[]{9, 2, 0, 4, 0});
    }

    public MdmMeasure createNumericMeasure(String string, MtmPartitionedCube mtmPartitionedCube, MtmValueExpression mtmValueExpression) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getNumberDataType();
        return this.createMeasure(string, mtmPartitionedCube, mtmValueExpression, fundamentalMetadataObject);
    }

    public MdmMeasure createNumericMeasure(String string, MtmPartitionedCube mtmPartitionedCube, String string2) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getNumberDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createMeasure(string, mtmPartitionedCube, mtmCustomExpression, fundamentalMetadataObject);
    }

    public MdmMeasure createDateMeasure(String string, MtmPartitionedCube mtmPartitionedCube, MtmValueExpression mtmValueExpression) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getDateDataType();
        return this.createMeasure(string, mtmPartitionedCube, mtmValueExpression, fundamentalMetadataObject);
    }

    public MdmMeasure createDateMeasure(String string, MtmPartitionedCube mtmPartitionedCube, String string2) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getDateDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createMeasure(string, mtmPartitionedCube, mtmCustomExpression, fundamentalMetadataObject);
    }

    public MdmMeasure createStringMeasure(String string, MtmPartitionedCube mtmPartitionedCube, MtmValueExpression mtmValueExpression) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getStringDataType();
        return this.createMeasure(string, mtmPartitionedCube, mtmValueExpression, fundamentalMetadataObject);
    }

    public MdmMeasure createStringMeasure(String string, MtmPartitionedCube mtmPartitionedCube, String string2) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getStringDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createMeasure(string, mtmPartitionedCube, mtmCustomExpression, fundamentalMetadataObject);
    }

    public MdmMeasure createBooleanMeasure(String string, MtmPartitionedCube mtmPartitionedCube, MtmValueExpression mtmValueExpression) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getBooleanDataType();
        return this.createMeasure(string, mtmPartitionedCube, mtmValueExpression, fundamentalMetadataObject);
    }

    public MdmMeasure createBooleanMeasure(String string, MtmPartitionedCube mtmPartitionedCube, String string2) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getBooleanDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createMeasure(string, mtmPartitionedCube, mtmCustomExpression, fundamentalMetadataObject);
    }

    private MdmMeasure createMeasure(String string, MtmPartitionedCube mtmPartitionedCube, MtmValueExpression mtmValueExpression, MetadataObject metadataObject) {
        BaseMetadataObject baseMetadataObject;
        Object object;
        String string2 = this.getMdmNamingConvention().generateMeasureID(mtmPartitionedCube, string);
        MdmMeasure mdmMeasure = this.getMdmObjectFactory().createMeasure(string2);
        mdmMeasure.setName(string);
        mdmMeasure.setType(metadataObject);
        MtmMeasureMap mtmMeasureMap = this.getMtmObjectFactory().createMeasureMap();
        mdmMeasure.setSourceMap(mtmMeasureMap);
        Mdm10_1_0_3_NamingConvention mdm10_1_0_3_NamingConvention = this.getMdm10_1_0_3_NamingConvention();
        if (mdm10_1_0_3_NamingConvention != null && ((ExpressDataProvider)this.getMdmMetadataProvider().getDataProvider()).isServerVersionLaterThan(new int[]{10, 1, 0, 3, 0})) {
            object = mdm10_1_0_3_NamingConvention.generateMeasureModelID(mdmMeasure);
            baseMetadataObject = this.getMdmObjectFactory().createMeasureModel((String)object);
            mdmMeasure.setModel((MdmModel)baseMetadataObject);
            ((MdmMeasureModel)baseMetadataObject).setMdmMeasure(mdmMeasure);
        }
        mtmMeasureMap.setDefaultMappedExpression(mtmValueExpression);
        object = mtmPartitionedCube.getDimensionMaps().iterator();
        while (object.hasNext()) {
            baseMetadataObject = (MtmDimensionMap)object.next();
            mdmMeasure.addDimension((MdmDimension)((MtmSourceMap)baseMetadataObject).getMdmSource());
        }
        mtmPartitionedCube.addMeasureMap(mtmMeasureMap);
        return mdmMeasure;
    }

    public MdmAttribute createNumericAttribute(String string, MdmPrimaryDimension mdmPrimaryDimension, MtmValueExpression mtmValueExpression) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getNumberDataType();
        return this.createAttribute(string, mdmPrimaryDimension, mtmValueExpression, fundamentalMetadataObject);
    }

    public MdmAttribute createNumericAttribute(String string, MdmPrimaryDimension mdmPrimaryDimension, String string2) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getNumberDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createAttribute(string, mdmPrimaryDimension, mtmCustomExpression, fundamentalMetadataObject);
    }

    public MdmAttribute createDateAttribute(String string, MdmPrimaryDimension mdmPrimaryDimension, MtmValueExpression mtmValueExpression) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getDateDataType();
        return this.createAttribute(string, mdmPrimaryDimension, mtmValueExpression, fundamentalMetadataObject);
    }

    public MdmAttribute createDateAttribute(String string, MdmPrimaryDimension mdmPrimaryDimension, String string2) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getDateDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createAttribute(string, mdmPrimaryDimension, mtmCustomExpression, fundamentalMetadataObject);
    }

    public MdmAttribute createStringAttribute(String string, MdmPrimaryDimension mdmPrimaryDimension, MtmValueExpression mtmValueExpression) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getStringDataType();
        return this.createAttribute(string, mdmPrimaryDimension, mtmValueExpression, fundamentalMetadataObject);
    }

    public MdmAttribute createStringAttribute(String string, MdmPrimaryDimension mdmPrimaryDimension, String string2) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getStringDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createAttribute(string, mdmPrimaryDimension, mtmCustomExpression, fundamentalMetadataObject);
    }

    public MdmAttribute createBooleanAttribute(String string, MdmPrimaryDimension mdmPrimaryDimension, MtmValueExpression mtmValueExpression) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getBooleanDataType();
        return this.createAttribute(string, mdmPrimaryDimension, mtmValueExpression, fundamentalMetadataObject);
    }

    public MdmAttribute createBooleanAttribute(String string, MdmPrimaryDimension mdmPrimaryDimension, String string2) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getBooleanDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createAttribute(string, mdmPrimaryDimension, mtmCustomExpression, fundamentalMetadataObject);
    }

    private MdmAttribute createAttribute(String string, MdmPrimaryDimension mdmPrimaryDimension, MtmValueExpression mtmValueExpression, MetadataObject metadataObject) {
        String string2 = this.getMdmNamingConvention().generateAttributeID(mdmPrimaryDimension, string);
        MdmAttribute mdmAttribute = this.getMdmObjectFactory().createAttribute(string2);
        mdmAttribute.setName(string);
        mdmAttribute.setType(metadataObject);
        MtmStoredAttributeMap mtmStoredAttributeMap = this.getMtmObjectFactory().createStoredAttributeMap();
        mdmAttribute.setSourceMap(mtmStoredAttributeMap);
        Mdm10_1_0_3_NamingConvention mdm10_1_0_3_NamingConvention = this.getMdm10_1_0_3_NamingConvention();
        if (mdm10_1_0_3_NamingConvention != null && ((ExpressDataProvider)this.getMdmMetadataProvider().getDataProvider()).isServerVersionLaterThan(new int[]{10, 1, 0, 3, 0})) {
            String string3 = mdm10_1_0_3_NamingConvention.generateAttributeModelID(mdmAttribute);
            MdmAttributeModel mdmAttributeModel = this.getMdmObjectFactory().createAttributeModel(string3);
            mdmAttribute.setModel(mdmAttributeModel);
            mdmAttributeModel.setMdmAttribute(mdmAttribute);
        }
        mtmStoredAttributeMap.setDefaultMappedExpression(mtmValueExpression);
        mdmAttribute.addDimension(mdmPrimaryDimension);
        mdmPrimaryDimension.addAttribute(mdmAttribute);
        mdmPrimaryDimension.setDescription(mdmPrimaryDimension.getDescription());
        return mdmAttribute;
    }

    private MdmAttribute createDerivedAttribute(String string, MdmPrimaryDimension mdmPrimaryDimension, String string2, String string3, MetadataObject metadataObject) {
        String string4 = this.getMdmNamingConvention().generateDerivedAttributeID(mdmPrimaryDimension, string3);
        MdmAttribute mdmAttribute = this.getMdmObjectFactory().createAttribute(string4);
        mdmAttribute.setName(string);
        mdmAttribute.setType(metadataObject);
        MtmDerivedAttributeMap mtmDerivedAttributeMap = this.getMtmObjectFactory().createDerivedAttributeMap(string3);
        mdmAttribute.setSourceMap(mtmDerivedAttributeMap);
        Mdm10_1_0_3_NamingConvention mdm10_1_0_3_NamingConvention = this.getMdm10_1_0_3_NamingConvention();
        if (mdm10_1_0_3_NamingConvention != null && ((ExpressDataProvider)this.getMdmMetadataProvider().getDataProvider()).isServerVersionLaterThan(new int[]{10, 1, 0, 3, 0})) {
            String string5 = mdm10_1_0_3_NamingConvention.generateAttributeModelID(mdmAttribute);
            MdmAttributeModel mdmAttributeModel = this.getMdmObjectFactory().createAttributeModel(string5);
            mdmAttribute.setModel(mdmAttributeModel);
            mdmAttributeModel.setMdmAttribute(mdmAttribute);
        }
        mdmAttribute.addDimension(mdmPrimaryDimension);
        mdmPrimaryDimension.setDerivedAttribute(string2, mdmAttribute);
        mdmPrimaryDimension.setDescription(mdmPrimaryDimension.getDescription());
        return mdmAttribute;
    }

    public MdmAttribute createEndDateAttribute(MdmTimeDimension mdmTimeDimension, MtmValueExpression mtmValueExpression) {
        if (!mtmValueExpression.getDataType().getSqlDataType().equals("DATE")) {
            throw new MetadataFactoryException("EndDateBadDatatype");
        }
        MdmAttribute mdmAttribute = this.createDateAttribute("END_DATE", (MdmPrimaryDimension)mdmTimeDimension, mtmValueExpression);
        mdmTimeDimension.setEndDateAttribute(mdmAttribute);
        return mdmAttribute;
    }

    public MdmAttribute createTimeSpanAttribute(MdmTimeDimension mdmTimeDimension, MtmValueExpression mtmValueExpression) {
        if (!mtmValueExpression.getDataType().getSqlDataType().equals("NUMBER")) {
            throw new MetadataFactoryException("TimeSpanBadDatatype");
        }
        MdmAttribute mdmAttribute = this.createNumericAttribute("TIMESPAN", (MdmPrimaryDimension)mdmTimeDimension, mtmValueExpression);
        mdmTimeDimension.setTimeSpanAttribute(mdmAttribute);
        return mdmAttribute;
    }

    public MdmLevel createNumericLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, MtmValueExpression mtmValueExpression, int n) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getNumberDataType();
        return this.createLevel(string, mdmLevelHierarchy, mtmValueExpression, (MetadataObject)fundamentalMetadataObject, n);
    }

    public MdmLevel createNumericLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, String string2, int n) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getNumberDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createLevel(string, mdmLevelHierarchy, (MtmValueExpression)mtmCustomExpression, (MetadataObject)fundamentalMetadataObject, n);
    }

    public MdmLevel createNumericLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, MtmValueExpression mtmValueExpression, MdmLevel mdmLevel) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getNumberDataType();
        return this.createLevel(string, mdmLevelHierarchy, mtmValueExpression, (MetadataObject)fundamentalMetadataObject, mdmLevel);
    }

    public MdmLevel createNumericLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, String string2, MdmLevel mdmLevel) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getNumberDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createLevel(string, mdmLevelHierarchy, (MtmValueExpression)mtmCustomExpression, (MetadataObject)fundamentalMetadataObject, mdmLevel);
    }

    public MdmLevel createStringLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, MtmValueExpression mtmValueExpression, int n) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getStringDataType();
        return this.createLevel(string, mdmLevelHierarchy, mtmValueExpression, (MetadataObject)fundamentalMetadataObject, n);
    }

    public MdmLevel createStringLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, String string2, int n) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getStringDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createLevel(string, mdmLevelHierarchy, (MtmValueExpression)mtmCustomExpression, (MetadataObject)fundamentalMetadataObject, n);
    }

    public MdmLevel createStringLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, MtmValueExpression mtmValueExpression, MdmLevel mdmLevel) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getStringDataType();
        return this.createLevel(string, mdmLevelHierarchy, mtmValueExpression, (MetadataObject)fundamentalMetadataObject, mdmLevel);
    }

    public MdmLevel createStringLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, String string2, MdmLevel mdmLevel) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getStringDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createLevel(string, mdmLevelHierarchy, (MtmValueExpression)mtmCustomExpression, (MetadataObject)fundamentalMetadataObject, mdmLevel);
    }

    public MdmLevel createDateLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, MtmValueExpression mtmValueExpression, int n) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getDateDataType();
        MdmLevel mdmLevel = this.createLevel(string, mdmLevelHierarchy, mtmValueExpression, (MetadataObject)fundamentalMetadataObject, n);
        return mdmLevel;
    }

    public MdmLevel createDateLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, String string2, int n) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getDateDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createLevel(string, mdmLevelHierarchy, (MtmValueExpression)mtmCustomExpression, (MetadataObject)fundamentalMetadataObject, n);
    }

    public MdmLevel createDateLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, MtmValueExpression mtmValueExpression, MdmLevel mdmLevel) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getDateDataType();
        return this.createLevel(string, mdmLevelHierarchy, mtmValueExpression, (MetadataObject)fundamentalMetadataObject, mdmLevel);
    }

    public MdmLevel createDateLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, String string2, MdmLevel mdmLevel) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getDateDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createLevel(string, mdmLevelHierarchy, (MtmValueExpression)mtmCustomExpression, (MetadataObject)fundamentalMetadataObject, mdmLevel);
    }

    public MdmLevel createBooleanLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, MtmValueExpression mtmValueExpression, int n) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getBooleanDataType();
        return this.createLevel(string, mdmLevelHierarchy, mtmValueExpression, (MetadataObject)fundamentalMetadataObject, n);
    }

    public MdmLevel createBooleanLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, String string2, int n) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getBooleanDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createLevel(string, mdmLevelHierarchy, (MtmValueExpression)mtmCustomExpression, (MetadataObject)fundamentalMetadataObject, n);
    }

    public MdmLevel createBooleanLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, MtmValueExpression mtmValueExpression, MdmLevel mdmLevel) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getBooleanDataType();
        return this.createLevel(string, mdmLevelHierarchy, mtmValueExpression, (MetadataObject)fundamentalMetadataObject, mdmLevel);
    }

    public MdmLevel createBooleanLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, String string2, MdmLevel mdmLevel) {
        FundamentalMetadataObject fundamentalMetadataObject = this.getFundamentalMetadataProvider().getBooleanDataType();
        MtmCustomExpression mtmCustomExpression = this.createCustomExpression(string2, fundamentalMetadataObject);
        return this.createLevel(string, mdmLevelHierarchy, (MtmValueExpression)mtmCustomExpression, (MetadataObject)fundamentalMetadataObject, mdmLevel);
    }

    private MdmLevel createLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, MtmValueExpression mtmValueExpression, MetadataObject metadataObject, int n) {
        String string2 = this.getMdmNamingConvention().generateLevelID(mdmLevelHierarchy, string);
        MdmLevel mdmLevel = this.getMdmObjectFactory().createLevel(string2);
        mdmLevel.setName(string);
        mdmLevel.setType(mdmLevelHierarchy);
        mdmLevel.setLevelHierarchy(mdmLevelHierarchy);
        mdmLevel.setPrimaryDimension(mdmLevelHierarchy.getPrimaryDimension());
        mdmLevel.setDescription(string);
        mdmLevel.setShortDescription(string);
        mdmLevel.setPluralDescription(string);
        mdmLevel.setShortPluralDescription(string);
        MtmLevelMap mtmLevelMap = this.getMtmObjectFactory().createLevelMap();
        mtmLevelMap.setLevelExpression(mtmValueExpression);
        mdmLevel.setSourceMap(mtmLevelMap);
        mdmLevelHierarchy.addLevel(mdmLevel, n);
        return mdmLevel;
    }

    private MdmLevel createLevel(String string, MdmLevelHierarchy mdmLevelHierarchy, MtmValueExpression mtmValueExpression, MetadataObject metadataObject, MdmLevel mdmLevel) {
        int n = 0;
        if (mdmLevel != null) {
            int n2 = mdmLevelHierarchy.getLevels().indexOf(mdmLevel);
            if (n2 < 0) {
                throw new MetadataFactoryException("LevelNotFound_2", mdmLevel.getName(), mdmLevelHierarchy.getName());
            }
            n = n2 + 1;
        }
        return this.createLevel(string, mdmLevelHierarchy, mtmValueExpression, metadataObject, n);
    }

    public MdmLevelHierarchy createLevelHierarchy(String string, MdmPrimaryDimension mdmPrimaryDimension, MdmLevelHierarchy mdmLevelHierarchy) {
        if (mdmLevelHierarchy.getPrimaryDimension() != mdmPrimaryDimension) {
            throw new MetadataFactoryException("HierarchyNotFound_2", mdmLevelHierarchy.getName(), mdmPrimaryDimension.getName());
        }
        MtmLevelHierarchyMap mtmLevelHierarchyMap = mdmLevelHierarchy.getLevelHierarchyMap();
        if (mtmLevelHierarchyMap instanceof MtmSolvedLevelHierarchyMap) {
            throw new MetadataFactoryException("HierarchyNotUnsolvedForCopy_1", mdmLevelHierarchy.getName());
        }
        DeepCopyNoExpressionsPolicy deepCopyNoExpressionsPolicy = new DeepCopyNoExpressionsPolicy();
        MdmLevelHierarchy mdmLevelHierarchy2 = (MdmLevelHierarchy)deepCopyNoExpressionsPolicy.deepCopy(mdmLevelHierarchy);
        mdmLevelHierarchy2.setName(string);
        mdmLevelHierarchy2.setType(mdmPrimaryDimension);
        mdmLevelHierarchy2.setDescription(string);
        mdmLevelHierarchy2.setShortDescription(string);
        mdmLevelHierarchy2.setPluralDescription(string);
        mdmLevelHierarchy2.setShortPluralDescription(string);
        Iterator iterator = this.getMdmMetadataProvider().getPartitionedCubes().iterator();
        while (iterator.hasNext()) {
            MtmPartitionedCube mtmPartitionedCube = (MtmPartitionedCube)iterator.next();
            if (!mtmPartitionedCube.getDimensionMaps().contains(mdmPrimaryDimension.getSourceMap())) continue;
            Iterator iterator2 = mtmPartitionedCube.getBaseCubes().iterator();
            while (iterator2.hasNext()) {
                MtmBaseCube mtmBaseCube = (MtmBaseCube)iterator2.next();
                if (!mtmBaseCube.getDimensionMaps().contains(mtmLevelHierarchyMap)) continue;
                MtmBaseCube mtmBaseCube2 = (MtmBaseCube)deepCopyNoExpressionsPolicy.deepCopy(mtmBaseCube);
                mtmPartitionedCube.addBaseCube(mtmBaseCube2);
            }
        }
        mdmPrimaryDimension.addHierarchy(mdmLevelHierarchy2);
        return mdmLevelHierarchy2;
    }

    public MdmLevelHierarchy createUnsolvedLevelHierarchy(String string, MdmPrimaryDimension mdmPrimaryDimension, MtmTabularSource mtmTabularSource) {
        String string2 = this.getMdmNamingConvention().generateHierarchyID(mdmPrimaryDimension, string);
        MdmLevelHierarchy mdmLevelHierarchy = this.getMdmObjectFactory().createLevelHierarchy(string2);
        mdmLevelHierarchy.setName(string);
        mdmLevelHierarchy.setType(mdmPrimaryDimension);
        mdmLevelHierarchy.setDescription(string);
        mdmLevelHierarchy.setShortDescription(string);
        mdmLevelHierarchy.setPluralDescription(string);
        mdmLevelHierarchy.setShortPluralDescription(string);
        MtmUnsolvedLevelHierarchyMap mtmUnsolvedLevelHierarchyMap = this.getMtmObjectFactory().createUnsolvedLevelHierarchyMap();
        mtmUnsolvedLevelHierarchyMap.setTable(mtmTabularSource);
        mdmLevelHierarchy.setSourceMap(mtmUnsolvedLevelHierarchyMap);
        mdmPrimaryDimension.addHierarchy(mdmLevelHierarchy);
        return mdmLevelHierarchy;
    }

    public MdmLevelHierarchy createSolvedLevelHierarchy(String string, MdmPrimaryDimension mdmPrimaryDimension, MtmTabularSource mtmTabularSource, MtmValueExpression mtmValueExpression, MtmValueExpression mtmValueExpression2, MtmValueExpression mtmValueExpression3, MtmValueExpression mtmValueExpression4) {
        String string2 = this.getMdmNamingConvention().generateHierarchyID(mdmPrimaryDimension, string);
        MdmLevelHierarchy mdmLevelHierarchy = this.getMdmObjectFactory().createLevelHierarchy(string2);
        mdmLevelHierarchy.setName(string);
        mdmLevelHierarchy.setType(mdmPrimaryDimension);
        mdmLevelHierarchy.setDescription(string);
        mdmLevelHierarchy.setShortDescription(string);
        mdmLevelHierarchy.setPluralDescription(string);
        mdmLevelHierarchy.setShortPluralDescription(string);
        MtmSolvedLevelHierarchyMap mtmSolvedLevelHierarchyMap = this.getMtmObjectFactory().createSolvedLevelHierarchyMap();
        mtmSolvedLevelHierarchyMap.setTable(mtmTabularSource);
        mtmSolvedLevelHierarchyMap.setGroupingIDExpression(mtmValueExpression);
        mtmSolvedLevelHierarchyMap.setETExpression(mtmValueExpression2);
        mtmSolvedLevelHierarchyMap.setParentGroupingIDExpression(mtmValueExpression3);
        mtmSolvedLevelHierarchyMap.setParentETExpression(mtmValueExpression4);
        mdmLevelHierarchy.setSourceMap(mtmSolvedLevelHierarchyMap);
        mdmPrimaryDimension.addHierarchy(mdmLevelHierarchy);
        return mdmLevelHierarchy;
    }

    public MdmValueHierarchy createValueHierarchy(String string, MdmPrimaryDimension mdmPrimaryDimension, MdmLevelHierarchy mdmLevelHierarchy) {
        if (mdmLevelHierarchy.getPrimaryDimension() != mdmPrimaryDimension) {
            throw new MetadataFactoryException("HierarchyNotFound_2", mdmLevelHierarchy.getID(), mdmPrimaryDimension.getID());
        }
        if (!(mdmLevelHierarchy.getLevelHierarchyMap() instanceof MtmSolvedLevelHierarchyMap)) {
            throw new MetadataFactoryException("HierarchyNotSolvedForValueHierarchy_1", mdmLevelHierarchy.getID());
        }
        MtmSolvedLevelHierarchyMap mtmSolvedLevelHierarchyMap = (MtmSolvedLevelHierarchyMap)mdmLevelHierarchy.getLevelHierarchyMap();
        MtmSolvedLevelHierarchyMap mtmSolvedLevelHierarchyMap2 = (MtmSolvedLevelHierarchyMap)new DeepCopyNoExpressionsPolicy().deepCopy(mtmSolvedLevelHierarchyMap);
        MtmValueLevelHierarchyMap mtmValueLevelHierarchyMap = this.getMtmObjectFactory().createValueLevelHierarchyMap();
        mtmValueLevelHierarchyMap.setSolvedLevelHierarchyMap(mtmSolvedLevelHierarchyMap2);
        Iterator iterator = mtmSolvedLevelHierarchyMap.getOrderSpecifications().iterator();
        while (iterator.hasNext()) {
            mtmValueLevelHierarchyMap.addOrderSpecification((MtmDimensionOrderSpecification)iterator.next());
        }
        String string2 = this.getMdmNamingConvention().generateHierarchyID(mdmPrimaryDimension, string);
        MdmValueHierarchy mdmValueHierarchy = this.getMdmObjectFactory().createValueHierarchy(string2);
        mdmValueHierarchy.setSourceMap(mtmValueLevelHierarchyMap);
        mdmValueHierarchy.setName(string);
        mdmValueHierarchy.setType(mdmPrimaryDimension);
        mdmValueHierarchy.setDescription(string);
        mdmValueHierarchy.setShortDescription(string);
        mdmValueHierarchy.setPluralDescription(string);
        mdmValueHierarchy.setShortPluralDescription(string);
        mdmPrimaryDimension.addHierarchy(mdmValueHierarchy);
        return mdmValueHierarchy;
    }

    private void populateDimensionAttributes(MdmPrimaryDimension mdmPrimaryDimension) {
        MdmAttribute mdmAttribute = this.createDerivedAttribute(mdmPrimaryDimension.getName() + ".ANCESTORS", mdmPrimaryDimension, "AncestorsAttribute", "Ancestors", mdmPrimaryDimension.getDataType());
        MdmAttribute mdmAttribute2 = this.createDerivedAttribute(mdmPrimaryDimension.getName() + ".PARENT", mdmPrimaryDimension, "ParentAttribute", "Parent", mdmPrimaryDimension.getDataType());
        MdmAttribute mdmAttribute3 = this.createDerivedAttribute(mdmPrimaryDimension.getName() + ".LEVEL_ATTRIBUTE", mdmPrimaryDimension, "LevelAttribute", "Level", this.getFundamentalMetadataProvider().getStringDataType());
        MdmAttribute mdmAttribute4 = this.createDerivedAttribute(mdmPrimaryDimension.getName() + ".LEVEL_DEPTH", mdmPrimaryDimension, "LevelDepthAttribute", "LevelDepth", this.getFundamentalMetadataProvider().getNumberDataType());
        MdmAttribute mdmAttribute5 = this.createDerivedAttribute(mdmPrimaryDimension.getName() + ".LOCAL_VALUE", mdmPrimaryDimension, "LocalValueAttribute", "LocalValue", this.getFundamentalMetadataProvider().getStringDataType());
        if (((ExpressDataProvider)this.getMdmMetadataProvider().getDataProvider()).isServerVersionLaterThan(new int[]{10, 2, 0, 0})) {
            MdmAttribute mdmAttribute6 = this.createDerivedAttribute(mdmPrimaryDimension.getName() + ".VALUE_LINEAGE", mdmPrimaryDimension, "ValueLineageAttribute", "ValueLineage", this.getFundamentalMetadataProvider().getStringDataType());
        }
    }

    private void populateDimCalcModels(MdmPrimaryDimension mdmPrimaryDimension) {
        Mdm10_1_0_3_NamingConvention mdm10_1_0_3_NamingConvention = this.getMdm10_1_0_3_NamingConvention();
        if (mdm10_1_0_3_NamingConvention == null && ((ExpressDataProvider)this.getMdmMetadataProvider().getDataProvider()).isServerVersionLaterThan(new int[]{10, 1, 0, 3, 0})) {
            return;
        }
        String string = mdm10_1_0_3_NamingConvention.generateDimensionCalculationModelID(mdmPrimaryDimension, "Boolean");
        MdmDimensionCalculationModel mdmDimensionCalculationModel = this.getMdmObjectFactory().createDimensionCalculationModel(string);
        mdmDimensionCalculationModel.setMdmDimension(mdmPrimaryDimension);
        mdmDimensionCalculationModel.setDataType(this.getFundamentalMetadataProvider().getBooleanDataType());
        mdmPrimaryDimension.setBooleanCalcModel(mdmDimensionCalculationModel);
        string = mdm10_1_0_3_NamingConvention.generateDimensionCalculationModelID(mdmPrimaryDimension, "String");
        mdmDimensionCalculationModel = this.getMdmObjectFactory().createDimensionCalculationModel(string);
        mdmDimensionCalculationModel.setMdmDimension(mdmPrimaryDimension);
        mdmDimensionCalculationModel.setDataType(this.getFundamentalMetadataProvider().getStringDataType());
        mdmPrimaryDimension.setStringCalcModel(mdmDimensionCalculationModel);
        string = mdm10_1_0_3_NamingConvention.generateDimensionCalculationModelID(mdmPrimaryDimension, "Date");
        mdmDimensionCalculationModel = this.getMdmObjectFactory().createDimensionCalculationModel(string);
        mdmDimensionCalculationModel.setMdmDimension(mdmPrimaryDimension);
        mdmDimensionCalculationModel.setDataType(this.getFundamentalMetadataProvider().getDateDataType());
        mdmPrimaryDimension.setDateCalcModel(mdmDimensionCalculationModel);
        string = mdm10_1_0_3_NamingConvention.generateDimensionCalculationModelID(mdmPrimaryDimension, "Number");
        mdmDimensionCalculationModel = this.getMdmObjectFactory().createDimensionCalculationModel(string);
        mdmDimensionCalculationModel.setMdmDimension(mdmPrimaryDimension);
        mdmDimensionCalculationModel.setDataType(this.getFundamentalMetadataProvider().getNumberDataType());
        mdmPrimaryDimension.setNumberCalcModel(mdmDimensionCalculationModel);
        if (mdmPrimaryDimension instanceof MdmMeasureDimension) {
            MdmMeasureDimension mdmMeasureDimension = (MdmMeasureDimension)mdmPrimaryDimension;
            string = mdm10_1_0_3_NamingConvention.generateDimensionCalculationModelID(mdmPrimaryDimension, "Value");
            mdmDimensionCalculationModel = this.getMdmObjectFactory().createDimensionCalculationModel(string);
            mdmDimensionCalculationModel.setMdmDimension(mdmPrimaryDimension);
            mdmDimensionCalculationModel.setDataType(this.getFundamentalMetadataProvider().getValueDataType());
            mdmMeasureDimension.setValueCalcModel(mdmDimensionCalculationModel);
        }
    }

    public MdmStandardDimension createStandardDimension(String string) {
        String string2 = this.getMdmNamingConvention().generatePrimaryDimensionID(string);
        MdmStandardDimension mdmStandardDimension = this.getMdmObjectFactory().createStandardDimension(string2);
        mdmStandardDimension.setName(string);
        mdmStandardDimension.setType(this.getFundamentalMetadataProvider().getStringDataType());
        mdmStandardDimension.setDescription(string);
        mdmStandardDimension.setShortDescription(string);
        mdmStandardDimension.setPluralDescription(string);
        mdmStandardDimension.setShortPluralDescription(string);
        MtmPrimaryDimensionMap mtmPrimaryDimensionMap = this.getMtmObjectFactory().createPrimaryDimensionMap();
        mdmStandardDimension.setSourceMap(mtmPrimaryDimensionMap);
        this.populateDimensionAttributes(mdmStandardDimension);
        this.populateDimCalcModels(mdmStandardDimension);
        return mdmStandardDimension;
    }

    public MdmTimeDimension createTimeDimension(String string) {
        String string2 = this.getMdmNamingConvention().generatePrimaryDimensionID(string);
        MdmTimeDimension mdmTimeDimension = this.getMdmObjectFactory().createTimeDimension(string2);
        mdmTimeDimension.setName(string);
        mdmTimeDimension.setType(this.getFundamentalMetadataProvider().getStringDataType());
        mdmTimeDimension.setDescription(string);
        mdmTimeDimension.setShortDescription(string);
        mdmTimeDimension.setPluralDescription(string);
        mdmTimeDimension.setShortPluralDescription(string);
        MtmPrimaryDimensionMap mtmPrimaryDimensionMap = this.getMtmObjectFactory().createPrimaryDimensionMap();
        mdmTimeDimension.setSourceMap(mtmPrimaryDimensionMap);
        this.populateDimensionAttributes(mdmTimeDimension);
        this.populateDimCalcModels(mdmTimeDimension);
        return mdmTimeDimension;
    }

    public MdmMeasureDimension createMeasureDimension(String string) {
        String string2 = this.getMdmNamingConvention().generateMeasureDimensionID();
        MdmMeasureDimension mdmMeasureDimension = this.getMdmObjectFactory().createMeasureDimension(string2);
        mdmMeasureDimension.setName(string);
        mdmMeasureDimension.setType(this.getFundamentalMetadataProvider().getStringDataType());
        mdmMeasureDimension.setDescription(string);
        mdmMeasureDimension.setShortDescription(string);
        mdmMeasureDimension.setPluralDescription(string);
        mdmMeasureDimension.setShortPluralDescription(string);
        MtmPrimaryDimensionMap mtmPrimaryDimensionMap = this.getMtmObjectFactory().createPrimaryDimensionMap();
        mdmMeasureDimension.setSourceMap(mtmPrimaryDimensionMap);
        this.populateDimensionAttributes(mdmMeasureDimension);
        this.populateDimCalcModels(mdmMeasureDimension);
        return mdmMeasureDimension;
    }

    private FundamentalMetadataObject findDataType(Source source) {
        Source source2 = source.getDataType();
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        FundamentalMetadataObject fundamentalMetadataObject = fundamentalMetadataProvider.getValueDataType();
        if (source2 == fundamentalMetadataProvider.getNumberDataType().getSource()) {
            fundamentalMetadataObject = fundamentalMetadataProvider.getNumberDataType();
        } else if (source2 == fundamentalMetadataProvider.getShortDataType().getSource()) {
            fundamentalMetadataObject = fundamentalMetadataProvider.getShortDataType();
        } else if (source2 == fundamentalMetadataProvider.getIntegerDataType().getSource()) {
            fundamentalMetadataObject = fundamentalMetadataProvider.getIntegerDataType();
        } else if (source2 == fundamentalMetadataProvider.getFloatDataType().getSource()) {
            fundamentalMetadataObject = fundamentalMetadataProvider.getFloatDataType();
        } else if (source2 == fundamentalMetadataProvider.getDoubleDataType().getSource()) {
            fundamentalMetadataObject = fundamentalMetadataProvider.getDoubleDataType();
        } else if (source2 == fundamentalMetadataProvider.getStringDataType().getSource()) {
            fundamentalMetadataObject = fundamentalMetadataProvider.getStringDataType();
        } else if (source2 == fundamentalMetadataProvider.getDateDataType().getSource()) {
            fundamentalMetadataObject = fundamentalMetadataProvider.getDateDataType();
        } else if (source2 == fundamentalMetadataProvider.getBooleanDataType().getSource()) {
            fundamentalMetadataObject = fundamentalMetadataProvider.getBooleanDataType();
        }
        return fundamentalMetadataObject;
    }

    public MdmStandardMember createStandardCustomMember(String string, MdmStandardDimension mdmStandardDimension, MdmLevel mdmLevel, String string2, Source source, int n) {
        MdmLevel mdmLevel2 = null;
        String string3 = null;
        if (mdmLevel.getLevelDepth() > 0) {
            mdmLevel2 = (MdmLevel)mdmLevel.getLevelHierarchy().getLevels().get(mdmLevel.getLevelDepth() - 1);
            string3 = string2;
        }
        return this.createStandardCustomMember(string, mdmStandardDimension, mdmLevel, string3, mdmLevel2, source, n);
    }

    public MdmStandardMember createStandardCustomMember(String string, MdmStandardDimension mdmStandardDimension, MdmLevel mdmLevel, String string2, MdmLevel mdmLevel2, Source source, int n) {
        return this.createStandardCustomMember(string, mdmStandardDimension, mdmLevel, null, string2, mdmLevel2, source, n);
    }

    public MdmStandardMember createStandardCustomMember(String string, MdmStandardDimension mdmStandardDimension, MdmValueHierarchy mdmValueHierarchy, Source source, int n) {
        return this.createStandardCustomMember(string, mdmStandardDimension, null, mdmValueHierarchy, null, null, source, n);
    }

    private MdmStandardMember createStandardCustomMember(String string, MdmStandardDimension mdmStandardDimension, MdmLevel mdmLevel, MdmValueHierarchy mdmValueHierarchy, String string2, MdmLevel mdmLevel2, Source source, int n) {
        if (!this.getMdmMetadataProvider().usingUniqueValues()) {
            throw new MetadataFactoryException("CustMembNoLocal");
        }
        Mdm10_1_0_3_NamingConvention mdm10_1_0_3_NamingConvention = this.getMdm10_1_0_3_NamingConvention();
        if (mdm10_1_0_3_NamingConvention == null && ((ExpressDataProvider)this.getMdmMetadataProvider().getDataProvider()).isServerVersionLaterThan(new int[]{10, 1, 0, 3, 0})) {
            return null;
        }
        String string3 = null;
        string3 = mdmLevel != null ? mdm10_1_0_3_NamingConvention.generateCustomMemberID(mdmLevel, string) : mdm10_1_0_3_NamingConvention.generateCustomMemberID(mdmValueHierarchy, string);
        MdmStandardMember mdmStandardMember = this.getMdmObjectFactory().createStandardMember(string3);
        mdmStandardMember.setName(string);
        if (mdmLevel != null) {
            mdmStandardMember.setLevel(mdmLevel);
        }
        if (mdmValueHierarchy != null) {
            mdmStandardMember.setValueHierarchy(mdmValueHierarchy);
        }
        mdmStandardMember.setParentLocalValue(string2);
        if (mdmLevel2 != null) {
            mdmStandardMember.setParentLevel(mdmLevel2);
        }
        mdmStandardMember.setSourceDefinition(source.getDefinition());
        mdmStandardMember.setPrecedence(n);
        mdmStandardMember.setDescription(string);
        mdmStandardMember.setShortDescription(string);
        mdmStandardMember.setType(this.findDataType(source));
        mdmStandardDimension.addCustomMember(mdmStandardMember);
        return mdmStandardMember;
    }

    public MdmTimeMember createTimeCustomMember(String string, MdmTimeDimension mdmTimeDimension, MdmLevel mdmLevel, String string2, Date date, int n, Source source, int n2) {
        MdmLevel mdmLevel2 = null;
        String string3 = null;
        if (mdmLevel.getLevelDepth() > 0) {
            mdmLevel2 = (MdmLevel)mdmLevel.getLevelHierarchy().getLevels().get(mdmLevel.getLevelDepth() - 1);
            string3 = string2;
        }
        return this.createTimeCustomMember(string, mdmTimeDimension, mdmLevel, string3, mdmLevel2, date, n, source, n2);
    }

    public MdmTimeMember createTimeCustomMember(String string, MdmTimeDimension mdmTimeDimension, MdmLevel mdmLevel, String string2, MdmLevel mdmLevel2, Date date, int n, Source source, int n2) {
        return this.createTimeCustomMember(string, mdmTimeDimension, mdmLevel, null, string2, mdmLevel2, date, n, source, n2);
    }

    public MdmTimeMember createTimeCustomMember(String string, MdmTimeDimension mdmTimeDimension, MdmValueHierarchy mdmValueHierarchy, Date date, int n, Source source, int n2) {
        return this.createTimeCustomMember(string, mdmTimeDimension, null, mdmValueHierarchy, null, null, date, n, source, n2);
    }

    private MdmTimeMember createTimeCustomMember(String string, MdmTimeDimension mdmTimeDimension, MdmLevel mdmLevel, MdmValueHierarchy mdmValueHierarchy, String string2, MdmLevel mdmLevel2, Date date, int n, Source source, int n2) {
        if (!this.getMdmMetadataProvider().usingUniqueValues()) {
            throw new MetadataFactoryException("CustMembNoLocal");
        }
        Mdm10_1_0_3_NamingConvention mdm10_1_0_3_NamingConvention = this.getMdm10_1_0_3_NamingConvention();
        if (mdm10_1_0_3_NamingConvention == null && ((ExpressDataProvider)this.getMdmMetadataProvider().getDataProvider()).isServerVersionLaterThan(new int[]{10, 1, 0, 3, 0})) {
            return null;
        }
        String string3 = null;
        string3 = mdmLevel != null ? mdm10_1_0_3_NamingConvention.generateCustomMemberID(mdmLevel, string) : mdm10_1_0_3_NamingConvention.generateCustomMemberID(mdmValueHierarchy, string);
        MdmTimeMember mdmTimeMember = this.getMdmObjectFactory().createTimeMember(string3);
        mdmTimeMember.setName(string);
        if (mdmLevel != null) {
            mdmTimeMember.setLevel(mdmLevel);
        }
        if (mdmValueHierarchy != null) {
            mdmTimeMember.setValueHierarchy(mdmValueHierarchy);
        }
        mdmTimeMember.setParentLocalValue(string2);
        if (mdmLevel2 != null) {
            mdmTimeMember.setParentLevel(mdmLevel2);
        }
        mdmTimeMember.setEndDate(date);
        mdmTimeMember.setTimeSpan(n);
        mdmTimeMember.setSourceDefinition(source.getDefinition());
        mdmTimeMember.setPrecedence(n2);
        mdmTimeMember.setDescription(string);
        mdmTimeMember.setShortDescription(string);
        mdmTimeMember.setType(this.findDataType(source));
        mdmTimeDimension.addCustomMember(mdmTimeMember);
        return mdmTimeMember;
    }

    public MdmMeasure createCustomMeasure(String string, Source source, int n) {
        return this.createCustomMeasure(string, this.getMdmMetadataProvider().getRootSchema().getMeasureDimension(), source, n);
    }

    public MdmMeasure createCustomMeasure(String string, MdmMeasureDimension mdmMeasureDimension, Source source, int n) {
        return this.createCustomMeasure(string, mdmMeasureDimension, this.getMdmMetadataProvider().getRootSchema(), source, n);
    }

    public MdmMeasure createCustomMeasure(String string, MdmMeasureDimension mdmMeasureDimension, MdmSchema mdmSchema, Source source, int n) {
        if (!this.getMdmMetadataProvider().usingUniqueValues()) {
            throw new MetadataFactoryException("CustMembNoLocal");
        }
        Mdm10_1_0_3_NamingConvention mdm10_1_0_3_NamingConvention = this.getMdm10_1_0_3_NamingConvention();
        if (mdm10_1_0_3_NamingConvention == null && ((ExpressDataProvider)this.getMdmMetadataProvider().getDataProvider()).isServerVersionLaterThan(new int[]{10, 1, 0, 3, 0})) {
            return null;
        }
        String string2 = mdm10_1_0_3_NamingConvention.generateCustomMeasureID(mdmMeasureDimension, string);
        MdmMeasure mdmMeasure = this.getMdmObjectFactory().createMeasure(string2);
        mdmMeasure.setName(string);
        mdmMeasure.setSourceDefinition(source.getDefinition());
        mdmMeasure.setPrecedence(n);
        mdmMeasure.setType(this.findDataType(source));
        String string3 = mdm10_1_0_3_NamingConvention.generateMeasureModelID(mdmMeasure);
        MdmMeasureModel mdmMeasureModel = this.getMdmObjectFactory().createMeasureModel(string3);
        mdmMeasure.setModel(mdmMeasureModel);
        mdmMeasureModel.setMdmMeasure(mdmMeasure);
        Iterator iterator = source.getInputs().iterator();
        while (iterator.hasNext()) {
            MdmSourceDefinition mdmSourceDefinition;
            Source source2 = (Source)iterator.next();
            if (!(source2.getDefinition() instanceof MdmSourceDefinition) || !((mdmSourceDefinition = (MdmSourceDefinition)source2.getDefinition()).getMdmSource() instanceof MdmDimension)) continue;
            mdmMeasure.addDimension((MdmDimension)mdmSourceDefinition.getMdmSource());
        }
        if (mdmMeasureDimension != mdmSchema.getMeasureDimension()) {
            mdmMeasureDimension.addMeasure(mdmMeasure);
        }
        mdmSchema.addMeasure(mdmMeasure);
        return mdmMeasure;
    }

    public MdmSchema createSchema(String string) {
        String string2 = this.getMdmNamingConvention().generateSchemaID(string);
        MdmSchema mdmSchema = this.getMdmObjectFactory().createSchema(string2);
        mdmSchema.setName(string);
        return mdmSchema;
    }

    public MtmColumnExpression createColumnExpression(String string) {
        MtmRDBMSColumnExpression mtmRDBMSColumnExpression = this.getMtmObjectFactory().createRDBMSColumnExpression();
        mtmRDBMSColumnExpression.setColumnName(string);
        return mtmRDBMSColumnExpression;
    }

    public MtmAWColumnExpression createAWColumnExpression(String string, String string2) {
        MtmAWColumnExpression mtmAWColumnExpression = this.getMtmObjectFactory().createAWColumnExpression();
        mtmAWColumnExpression.setColumnName(string);
        mtmAWColumnExpression.setAWObjectName(string2);
        return mtmAWColumnExpression;
    }

    public MtmCustomExpression createCustomExpression(String string, MetadataObject metadataObject) {
        return this.getMtmCustomObjectFactory().createCustomExpression(string, metadataObject);
    }

    public MtmCustomExpression createCustomExpression(String string) {
        return this.createCustomExpression(string, null);
    }

    public final MdmMetadataProvider getMdmMetadataProvider() {
        return this.m_MdmMetadataProvider;
    }

    public final MdmNamingConvention getMdmNamingConvention() {
        return this.getMdmMetadataProvider().getMdmNamingConvention();
    }

    private Mdm10_1_0_3_NamingConvention getMdm10_1_0_3_NamingConvention() {
        Mdm10_1_0_3_NamingConvention mdm10_1_0_3_NamingConvention = null;
        try {
            mdm10_1_0_3_NamingConvention = (Mdm10_1_0_3_NamingConvention)this.getMdmNamingConvention();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return mdm10_1_0_3_NamingConvention;
    }

    private MdmObjectFactory getMdmObjectFactory() {
        return this.getMdmMetadataProvider().getMdmObjectFactory();
    }

    private MtmObjectFactory getMtmObjectFactory() {
        return this.getMdmMetadataProvider().getMtmObjectFactory();
    }

    private MtmCustomObjectFactory getMtmCustomObjectFactory() {
        return this.getMdmMetadataProvider().getMtmCustomObjectFactory();
    }

    private void setMdmMetadataProvider(MdmMetadataProvider mdmMetadataProvider) {
        this.m_MdmMetadataProvider = mdmMetadataProvider;
    }

    private FundamentalMetadataProvider getFundamentalMetadataProvider() {
        return this.getMdmMetadataProvider().getDataProvider().getFundamentalMetadataProvider();
    }

    private static class DeepCopyNoExpressionsPolicy
    extends DeepCopyPolicy {
        private DeepCopyNoExpressionsPolicy() {
        }

        public Object copyDownReference(Object object) throws CopyException {
            if (object instanceof MtmExpression || object instanceof MtmTabularSource) {
                return this.copyExternalReference(object);
            }
            return super.copyDownReference(object);
        }
    }
}

