/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.KeyValuePair;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataProperty;
import oracle.olapi.metadata.MetadataToXMLConverter;

final class MetadataMapProperty
extends MetadataProperty {
    private List m_Pairs = new ArrayList();

    MetadataMapProperty(String string) {
        super(string);
    }

    private KeyValuePair findPair(String string) {
        Iterator iterator = this.getPairs().iterator();
        while (iterator.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)iterator.next();
            if (!keyValuePair.getKeyHolder().getObjectID().equals(string)) continue;
            return keyValuePair;
        }
        return null;
    }

    MetadataObject getObject(MetadataObject metadataObject, BaseMetadataProvider baseMetadataProvider) {
        KeyValuePair keyValuePair = this.findPair(metadataObject.getID());
        if (null == keyValuePair) {
            return null;
        }
        return baseMetadataProvider.fetchMetadataObject(keyValuePair.getValueHolder());
    }

    void putObject(MetadataObjectHolder metadataObjectHolder, MetadataObjectHolder metadataObjectHolder2) {
        KeyValuePair keyValuePair = this.findPair(metadataObjectHolder.getObjectID());
        if (null == keyValuePair) {
            this.getPairs().add(new KeyValuePair(metadataObjectHolder, metadataObjectHolder2));
        } else if (null == metadataObjectHolder2) {
            this.getPairs().remove(keyValuePair);
        } else {
            keyValuePair.setValueHolder(metadataObjectHolder2);
        }
    }

    String getValue(MetadataObject metadataObject, BaseMetadataProvider baseMetadataProvider) {
        KeyValuePair keyValuePair = this.findPair(metadataObject.getID());
        if (null == keyValuePair) {
            return null;
        }
        return keyValuePair.getValue();
    }

    void putValue(MetadataObjectHolder metadataObjectHolder, String string) {
        KeyValuePair keyValuePair = this.findPair(metadataObjectHolder.getObjectID());
        if (null == keyValuePair) {
            this.getPairs().add(new KeyValuePair(metadataObjectHolder, string));
        } else if (null == string) {
            this.getPairs().remove(keyValuePair);
        } else {
            keyValuePair.setValue(string);
        }
    }

    boolean addChildrenToXMLWriter(MetadataToXMLConverter metadataToXMLConverter, List list) {
        boolean bl = false;
        Iterator iterator = this.getPairs().iterator();
        while (iterator.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)iterator.next();
            bl = metadataToXMLConverter.addMetadataObject(keyValuePair.getKeyHolder(), list);
            if (null == keyValuePair.getValueHolder()) continue;
            bl = metadataToXMLConverter.addMetadataObject(keyValuePair.getValueHolder(), list) || bl;
        }
        return bl;
    }

    void appendXMLString(MetadataToXMLConverter metadataToXMLConverter) {
        Iterator iterator = this.getPairs().iterator();
        while (iterator.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)iterator.next();
            metadataToXMLConverter.beginElement(this.getPropertyName());
            metadataToXMLConverter.appendAttribute("Key", keyValuePair.getKeyHolder());
            if (null == keyValuePair.getValueHolder()) {
                metadataToXMLConverter.appendAttribute("Value", keyValuePair.getValue());
            } else {
                metadataToXMLConverter.appendAttribute("Value", keyValuePair.getValueHolder());
            }
            metadataToXMLConverter.endElement();
        }
    }

    List getPairs() {
        return this.m_Pairs;
    }

    boolean isAttribute() {
        return false;
    }

    public Object clone() {
        MetadataMapProperty metadataMapProperty = new MetadataMapProperty(this.getPropertyName());
        Iterator iterator = this.getPairs().iterator();
        while (iterator.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)iterator.next();
            metadataMapProperty.getPairs().add(keyValuePair.clone());
        }
        return metadataMapProperty;
    }
}

