/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import oracle.express.ObjectClosedException;
import oracle.express.idl.ExpressMdmModule.MetadataProviderInterface;
import oracle.express.olapi.data.full.ExpressDataProvider;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.ClientXMLMetadataFetcher;
import oracle.olapi.metadata.MdmXMLReaderObjectFactory;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.MetadataXMLReaderFactory;
import oracle.olapi.metadata.MtmXMLReaderObjectFactory;
import oracle.olapi.metadata.XMLFetcher;
import oracle.olapi.metadata.XMLFetcher9201;
import oracle.olapi.metadata.XMLFetcher9202;
import oracle.olapi.metadata.XMLFetcher9203;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;

final class MetadataFetcher {
    private BaseMetadataProvider m_BaseMetadataProvider = null;
    private XMLFetcher m_XMLFetcher = null;
    private boolean m_SupportsMetadataUpdate = false;
    private int m_maxFetchSize = 10;
    static final short TRANSIENT_METADATA = 0;
    static final short SERVER_PERSISTENT_METADATA = 1;
    static final short CLIENT_PERSISTENT_METADATA = 2;

    MetadataFetcher(BaseMetadataProvider baseMetadataProvider, ClientXMLMetadataFetcher clientXMLMetadataFetcher) {
        this.setBaseMetadataProvider(baseMetadataProvider);
        this.initialize(clientXMLMetadataFetcher);
    }

    private void initialize(ClientXMLMetadataFetcher clientXMLMetadataFetcher) {
        String string = ((ExpressDataProvider)this.getBaseMetadataProvider().getDataProvider()).getProperty("XMLFetchSize");
        if (null != string) {
            try {
                this.m_maxFetchSize = Integer.valueOf(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ExpressDataProvider expressDataProvider = (ExpressDataProvider)this.getBaseMetadataProvider().getDataProvider();
        MetadataProviderInterface metadataProviderInterface = expressDataProvider.getMetadataProviderInterface();
        XMLFetcher xMLFetcher = null;
        xMLFetcher = null != clientXMLMetadataFetcher ? clientXMLMetadataFetcher : (expressDataProvider.isServerVersionLaterThan(new int[]{9, 2, 0, 3, 0}) ? new XMLFetcher9203(metadataProviderInterface) : (expressDataProvider.isServerVersionLaterThan(new int[]{9, 2, 0, 1, 0}) ? new XMLFetcher9202(metadataProviderInterface) : new XMLFetcher9201(metadataProviderInterface)));
        this.setXMLFetcher(xMLFetcher);
        if (expressDataProvider.isServerVersionLaterThan(new int[]{9, 2, 0, 3, 0})) {
            this.setSupportsMetadataUpdate(true);
        } else {
            this.setSupportsMetadataUpdate(false);
        }
    }

    private XMLReader createXMLReader() {
        short s = this.getXMLFetcher().getPersistenceType();
        MdmMetadataProvider mdmMetadataProvider = (MdmMetadataProvider)this.getBaseMetadataProvider();
        ArrayList<MetadataXMLReaderFactory> arrayList = new ArrayList<MetadataXMLReaderFactory>();
        arrayList.add(new MdmXMLReaderObjectFactory(mdmMetadataProvider, s));
        arrayList.add(new MtmXMLReaderObjectFactory(mdmMetadataProvider, s));
        MetadataXMLReader metadataXMLReader = new MetadataXMLReader(arrayList, this.getBaseMetadataProvider());
        ParserAdapter parserAdapter = new ParserAdapter((Parser)new SAXParser());
        parserAdapter.setContentHandler(metadataXMLReader);
        parserAdapter.setEntityResolver(metadataXMLReader);
        parserAdapter.setErrorHandler(metadataXMLReader);
        return parserAdapter;
    }

    void fetchBaseMetadataObjects(String[] stringArray) throws ObjectClosedException {
        XMLReader xMLReader = this.createXMLReader();
        ExpressDataProvider expressDataProvider = (ExpressDataProvider)this.getBaseMetadataProvider().getDataProvider();
        if (expressDataProvider.isServerVersionLaterThan(new int[]{9, 2, 0, 2, 0}) && !expressDataProvider.isServerVersionLaterThan(new int[]{9, 2, 0, 3, 0})) {
            int n = stringArray.length;
            for (int i = 0; i < n; i += this.m_maxFetchSize) {
                String[] stringArray2 = null;
                if (n <= this.m_maxFetchSize) {
                    stringArray2 = stringArray;
                } else {
                    int n2 = this.m_maxFetchSize;
                    if (i + n2 >= n) {
                        n2 = n - i;
                    }
                    stringArray2 = new String[n2];
                    System.arraycopy(stringArray, i, stringArray2, 0, n2);
                }
                InputSource inputSource = this.getXMLFetcher().fetchXML(stringArray2);
                this.processXML(inputSource, xMLReader);
            }
        } else {
            InputSource inputSource = this.getXMLFetcher().fetchXML(stringArray);
            this.processXML(inputSource, xMLReader);
        }
    }

    public BaseMetadataProvider getBaseMetadataProvider() {
        return this.m_BaseMetadataProvider;
    }

    String getID() {
        return this.getXMLFetcher().getID();
    }

    private XMLFetcher getXMLFetcher() {
        return this.m_XMLFetcher;
    }

    void invalidate() {
    }

    private void processXML(InputSource inputSource, XMLReader xMLReader) {
        if (null == inputSource) {
            return;
        }
        try {
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void setBaseMetadataProvider(BaseMetadataProvider baseMetadataProvider) {
        this.m_BaseMetadataProvider = baseMetadataProvider;
    }

    private void setSupportsMetadataUpdate(boolean bl) {
        this.m_SupportsMetadataUpdate = bl;
    }

    private void setXMLFetcher(XMLFetcher xMLFetcher) {
        this.m_XMLFetcher = xMLFetcher;
    }

    private boolean supportsMetadataUpdate() {
        return this.m_SupportsMetadataUpdate;
    }
}

