/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.express.ObjectClosedException;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.ClientXMLMetadataFetcher;
import oracle.olapi.metadata.DuplicateMetadataIDException;
import oracle.olapi.metadata.MetadataFetcher;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataObjectHolder;

public class BaseMetadataProvider {
    private HashMap m_ObjectMap = new HashMap();
    private MetadataFetcher m_MetadataFetcher = null;
    private DataProvider m_DataProvider = null;
    private String m_ID = null;

    protected BaseMetadataProvider(DataProvider dataProvider) throws ObjectClosedException {
        this(dataProvider, null);
    }

    protected BaseMetadataProvider(DataProvider dataProvider, ClientXMLMetadataFetcher clientXMLMetadataFetcher) throws ObjectClosedException {
        this.setDataProvider(dataProvider);
        this.setMetadataFetcher(new MetadataFetcher(this, clientXMLMetadataFetcher));
    }

    public final void flushDeletedObjects() {
        HashMap<String, BaseMetadataObject> hashMap = new HashMap<String, BaseMetadataObject>();
        Iterator iterator = this.getObjectMap().values().iterator();
        while (iterator.hasNext()) {
            BaseMetadataObject baseMetadataObject = (BaseMetadataObject)iterator.next();
            if (!baseMetadataObject.isDeleted()) {
                hashMap.put(baseMetadataObject.getID(), baseMetadataObject);
            }
            iterator.next();
        }
        this.setObjectMap(hashMap);
    }

    public final MetadataObject fetchMetadataObject(String string) throws ObjectClosedException {
        return this.fetchMetadataObject(this.getObjectHolder(string));
    }

    public final List fetchMetadataObjects(String[] stringArray) throws ObjectClosedException {
        if (stringArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        MetadataObjectHolder[] metadataObjectHolderArray = new MetadataObjectHolder[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            metadataObjectHolderArray[i] = this.getObjectHolder(stringArray[i]);
        }
        ArrayList arrayList = new ArrayList(stringArray.length);
        this.fetchMetadataObjects(metadataObjectHolderArray, arrayList);
        return arrayList;
    }

    final synchronized MetadataObject fetchMetadataObject(MetadataObjectHolder metadataObjectHolder) throws ObjectClosedException {
        if (null == metadataObjectHolder) {
            return null;
        }
        if (null != metadataObjectHolder.getMetadataObject()) {
            return metadataObjectHolder.getMetadataObject();
        }
        String[] stringArray = new String[]{metadataObjectHolder.getObjectID()};
        this.getMetadataFetcher().fetchBaseMetadataObjects(stringArray);
        return metadataObjectHolder.getMetadataObject();
    }

    final synchronized void fetchMetadataObjects(List list, ArrayList arrayList) throws ObjectClosedException {
        int n;
        if (list.isEmpty()) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            if (null != ((MetadataObjectHolder)list.get(n)).getMetadataObject()) continue;
            ++n2;
        }
        if (0 != n2) {
            String[] stringArray = new String[n2];
            int n3 = 0;
            for (int i = 0; i < list.size(); ++i) {
                MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)list.get(i);
                if (null != metadataObjectHolder.getMetadataObject()) continue;
                stringArray[n3] = metadataObjectHolder.getObjectID();
                ++n3;
            }
            this.getMetadataFetcher().fetchBaseMetadataObjects(stringArray);
        }
        arrayList.ensureCapacity(list.size());
        for (n = 0; n < list.size(); ++n) {
            MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)list.get(n);
            arrayList.add(metadataObjectHolder.getMetadataObject());
        }
    }

    final synchronized void fetchMetadataObjects(MetadataObjectHolder[] metadataObjectHolderArray, ArrayList arrayList) throws ObjectClosedException {
        int n;
        if (0 == metadataObjectHolderArray.length) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < metadataObjectHolderArray.length; ++n) {
            if (null != metadataObjectHolderArray[n].getMetadataObject()) continue;
            ++n2;
        }
        if (n2 != 0) {
            String[] stringArray = new String[n2];
            int n3 = 0;
            for (int i = 0; i < metadataObjectHolderArray.length; ++i) {
                if (null != metadataObjectHolderArray[i].getMetadataObject()) continue;
                stringArray[n3] = metadataObjectHolderArray[i].getObjectID();
                ++n3;
            }
            this.getMetadataFetcher().fetchBaseMetadataObjects(stringArray);
        }
        arrayList.ensureCapacity(metadataObjectHolderArray.length);
        for (n = 0; n < metadataObjectHolderArray.length; ++n) {
            arrayList.add(metadataObjectHolderArray[n].getMetadataObject());
        }
    }

    public DataProvider getDataProvider() {
        return this.m_DataProvider;
    }

    public String getID() {
        if (null == this.m_ID) {
            this.m_ID = this.getMetadataFetcher().getID();
        }
        return this.m_ID;
    }

    private MetadataFetcher getMetadataFetcher() {
        return this.m_MetadataFetcher;
    }

    final synchronized MetadataObjectHolder getObjectHolder(String string) {
        MetadataObjectHolder metadataObjectHolder = null;
        metadataObjectHolder = (MetadataObjectHolder)this.m_ObjectMap.get(string);
        if (null == metadataObjectHolder) {
            FundamentalMetadataProvider fundamentalMetadataProvider = this.m_DataProvider.getFundamentalMetadataProvider();
            FundamentalMetadataObject fundamentalMetadataObject = fundamentalMetadataProvider.getMetadataObject(string);
            metadataObjectHolder = new MetadataObjectHolder(string, fundamentalMetadataObject);
            this.m_ObjectMap.put(string, metadataObjectHolder);
        }
        return metadataObjectHolder;
    }

    private HashMap getObjectMap() {
        return this.m_ObjectMap;
    }

    final void registerMetadataObject(String string, BaseMetadataObject baseMetadataObject) {
        MetadataObjectHolder metadataObjectHolder = this.getObjectHolder(string);
        if (null != metadataObjectHolder.getMetadataObject()) {
            throw new DuplicateMetadataIDException(string);
        }
        metadataObjectHolder.setMetadataObject(baseMetadataObject);
        baseMetadataObject.setHolder(metadataObjectHolder);
    }

    private void setDataProvider(DataProvider dataProvider) {
        this.m_DataProvider = dataProvider;
    }

    private void setMetadataFetcher(MetadataFetcher metadataFetcher) {
        this.m_MetadataFetcher = metadataFetcher;
    }

    private void setObjectMap(HashMap hashMap) {
        this.m_ObjectMap = hashMap;
    }

    public final void update() {
        this.getMetadataFetcher().invalidate();
        Iterator iterator = this.getObjectMap().values().iterator();
        while (iterator.hasNext()) {
            BaseMetadataObject baseMetadataObject;
            MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)iterator.next();
            if (!(metadataObjectHolder.getMetadataObject() instanceof BaseMetadataObject) || !(baseMetadataObject = (BaseMetadataObject)metadataObjectHolder.getMetadataObject()).isPersistent()) continue;
            baseMetadataObject.invalidate();
        }
    }

    public final boolean supportsMetadataUpdate() {
        return true;
    }
}

