/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.olapi.internal.CopyException;
import oracle.olapi.internal.CopyPolicy;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.KeyValuePair;
import oracle.olapi.metadata.MetadataAssociationProperty;
import oracle.olapi.metadata.MetadataListProperty;
import oracle.olapi.metadata.MetadataMapProperty;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataProperty;
import oracle.olapi.metadata.MetadataStringProperty;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.transaction.metadataStateManager.MetadataState;

final class BaseMetadataObjectState
implements MetadataState {
    private HashMap m_properties = new HashMap();

    BaseMetadataObjectState() {
    }

    private void addProperty(MetadataProperty metadataProperty) {
        this.m_properties.put(metadataProperty.m_PropertyName, metadataProperty);
    }

    final boolean addChildrenToXMLWriter(MetadataToXMLConverter metadataToXMLConverter, List list) {
        boolean bl = false;
        Iterator iterator = this.m_properties.values().iterator();
        while (iterator.hasNext()) {
            bl = ((MetadataProperty)iterator.next()).addChildrenToXMLWriter(metadataToXMLConverter, list) || bl;
        }
        return bl;
    }

    final void addToListProperty(String string, MetadataObjectHolder metadataObjectHolder) {
        MetadataListProperty metadataListProperty = (MetadataListProperty)this.findProperty(string);
        if (null == metadataListProperty) {
            metadataListProperty = new MetadataListProperty(string);
            this.addProperty(metadataListProperty);
        }
        metadataListProperty.addHolder(metadataObjectHolder);
    }

    final void addToListProperty(String string, MetadataObjectHolder metadataObjectHolder, int n) {
        MetadataListProperty metadataListProperty = (MetadataListProperty)this.findProperty(string);
        if (null == metadataListProperty) {
            metadataListProperty = new MetadataListProperty(string);
            this.addProperty(metadataListProperty);
        }
        metadataListProperty.addHolder(metadataObjectHolder, n);
    }

    final void removeFromListProperty(String string, MetadataObjectHolder metadataObjectHolder) {
        MetadataListProperty metadataListProperty = (MetadataListProperty)this.findProperty(string);
        if (null == metadataListProperty) {
            return;
        }
        metadataListProperty.removeHolder(metadataObjectHolder);
    }

    protected void mapObject(String string, MetadataObjectHolder metadataObjectHolder, MetadataObjectHolder metadataObjectHolder2) {
        MetadataMapProperty metadataMapProperty = (MetadataMapProperty)this.findProperty(string);
        if (null == metadataMapProperty) {
            metadataMapProperty = new MetadataMapProperty(string);
            this.addProperty(metadataMapProperty);
        }
        metadataMapProperty.putObject(metadataObjectHolder, metadataObjectHolder2);
    }

    protected MetadataObject getMappedObject(String string, MetadataObject metadataObject, BaseMetadataProvider baseMetadataProvider) {
        MetadataMapProperty metadataMapProperty = (MetadataMapProperty)this.findProperty(string);
        if (null == metadataMapProperty) {
            return null;
        }
        return metadataMapProperty.getObject(metadataObject, baseMetadataProvider);
    }

    protected void mapValue(String string, MetadataObjectHolder metadataObjectHolder, String string2) {
        MetadataMapProperty metadataMapProperty = (MetadataMapProperty)this.findProperty(string);
        if (null == metadataMapProperty) {
            metadataMapProperty = new MetadataMapProperty(string);
            this.addProperty(metadataMapProperty);
        }
        metadataMapProperty.putValue(metadataObjectHolder, string2);
    }

    protected String getMappedValue(String string, MetadataObject metadataObject, BaseMetadataProvider baseMetadataProvider) {
        MetadataMapProperty metadataMapProperty = (MetadataMapProperty)this.findProperty(string);
        if (null == metadataMapProperty) {
            return null;
        }
        return metadataMapProperty.getValue(metadataObject, baseMetadataProvider);
    }

    final void appendXMLString(MetadataToXMLConverter metadataToXMLConverter) {
        MetadataProperty metadataProperty = null;
        Iterator iterator = this.m_properties.values().iterator();
        while (iterator.hasNext()) {
            metadataProperty = (MetadataProperty)iterator.next();
            if (!metadataProperty.isAttribute()) continue;
            metadataProperty.appendXMLString(metadataToXMLConverter);
        }
        metadataToXMLConverter.closeTag();
        iterator = this.m_properties.values().iterator();
        metadataProperty = null;
        while (iterator.hasNext()) {
            metadataProperty = (MetadataProperty)iterator.next();
            if (metadataProperty.isAttribute()) continue;
            metadataProperty.appendXMLString(metadataToXMLConverter);
        }
    }

    public Object clone() {
        BaseMetadataObjectState baseMetadataObjectState = new BaseMetadataObjectState();
        MetadataProperty metadataProperty = null;
        Iterator iterator = this.m_properties.values().iterator();
        while (iterator.hasNext()) {
            metadataProperty = (MetadataProperty)iterator.next();
            baseMetadataObjectState.addProperty((MetadataProperty)metadataProperty.clone());
        }
        return baseMetadataObjectState;
    }

    private MetadataProperty findProperty(String string) {
        return (MetadataProperty)this.m_properties.get(string);
    }

    List getPropertyListValues(String string, BaseMetadataProvider baseMetadataProvider) {
        MetadataListProperty metadataListProperty = (MetadataListProperty)this.findProperty(string);
        ArrayList arrayList = new ArrayList();
        if (null != metadataListProperty) {
            metadataListProperty.getObjects(arrayList, baseMetadataProvider);
        }
        return arrayList;
    }

    MetadataObject getPropertyObjectValue(String string, BaseMetadataProvider baseMetadataProvider) {
        MetadataAssociationProperty metadataAssociationProperty = (MetadataAssociationProperty)this.findProperty(string);
        if (null == metadataAssociationProperty) {
            return null;
        }
        return metadataAssociationProperty.getObject(baseMetadataProvider);
    }

    String getPropertyStringValue(String string) {
        MetadataStringProperty metadataStringProperty = (MetadataStringProperty)this.findProperty(string);
        if (null == metadataStringProperty) {
            return "";
        }
        return metadataStringProperty.getPropertyValue();
    }

    int getPropertyIntegerValue(String string, int n) {
        MetadataStringProperty metadataStringProperty = (MetadataStringProperty)this.findProperty(string);
        if (null == metadataStringProperty) {
            return n;
        }
        return Integer.parseInt(metadataStringProperty.getPropertyValue());
    }

    protected void setPropertyObjectValue(String string, MetadataObjectHolder metadataObjectHolder) {
        MetadataAssociationProperty metadataAssociationProperty = (MetadataAssociationProperty)this.findProperty(string);
        if (null == metadataAssociationProperty) {
            metadataAssociationProperty = new MetadataAssociationProperty(string, metadataObjectHolder);
            this.addProperty(metadataAssociationProperty);
        } else {
            metadataAssociationProperty.setObjectHolder(metadataObjectHolder);
        }
    }

    protected void setPropertyStringValue(String string, String string2) {
        MetadataStringProperty metadataStringProperty = (MetadataStringProperty)this.findProperty(string);
        if (null == metadataStringProperty) {
            metadataStringProperty = new MetadataStringProperty(string, string2);
            this.addProperty(metadataStringProperty);
        } else {
            metadataStringProperty.setPropertyValue(string2);
        }
    }

    protected void setPropertyIntegerValue(String string, int n) {
        String string2 = Integer.toString(n);
        MetadataStringProperty metadataStringProperty = (MetadataStringProperty)this.findProperty(string);
        if (null == metadataStringProperty) {
            metadataStringProperty = new MetadataStringProperty(string, string2);
            this.addProperty(metadataStringProperty);
        } else {
            metadataStringProperty.setPropertyValue(string2);
        }
    }

    void copyPropertyTo(BaseMetadataObjectState baseMetadataObjectState, String string, BaseMetadataProvider baseMetadataProvider, CopyPolicy copyPolicy, CopyPolicy.CopyReferenceType copyReferenceType) throws CopyException {
        MetadataProperty metadataProperty = this.findProperty(string);
        if (metadataProperty != null) {
            this.copyPropertyTo(baseMetadataObjectState, metadataProperty, baseMetadataProvider, copyPolicy, copyReferenceType);
        }
    }

    private void copyPropertyTo(BaseMetadataObjectState baseMetadataObjectState, MetadataProperty metadataProperty, BaseMetadataProvider baseMetadataProvider, CopyPolicy copyPolicy, CopyPolicy.CopyReferenceType copyReferenceType) throws CopyException {
        if (metadataProperty instanceof MetadataListProperty) {
            MetadataListProperty metadataListProperty = (MetadataListProperty)metadataProperty;
            ArrayList arrayList = new ArrayList();
            metadataListProperty.getObjects(arrayList, baseMetadataProvider);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                BaseMetadataObject baseMetadataObject = (BaseMetadataObject)iterator.next();
                baseMetadataObjectState.addToListProperty(metadataListProperty.getPropertyName(), ((BaseMetadataObject)copyPolicy.copyReference(baseMetadataObject, copyReferenceType)).getHolder());
            }
        } else if (metadataProperty instanceof MetadataMapProperty) {
            MetadataMapProperty metadataMapProperty = (MetadataMapProperty)metadataProperty;
            Iterator iterator = metadataMapProperty.getPairs().iterator();
            while (iterator.hasNext()) {
                Object object;
                KeyValuePair keyValuePair = (KeyValuePair)iterator.next();
                BaseMetadataObject baseMetadataObject = (BaseMetadataObject)copyPolicy.copyExternalReference(baseMetadataProvider.fetchMetadataObject(keyValuePair.getKeyHolder()));
                if (keyValuePair.getValueHolder() != null) {
                    object = (BaseMetadataObject)copyPolicy.copyReference(baseMetadataProvider.fetchMetadataObject(keyValuePair.getValueHolder()), copyReferenceType);
                    baseMetadataObjectState.mapObject(metadataProperty.getPropertyName(), baseMetadataObject.getHolder(), ((BaseMetadataObject)object).getHolder());
                    continue;
                }
                object = (String)copyPolicy.copyReference(keyValuePair.getValue(), copyReferenceType);
                baseMetadataObjectState.mapValue(metadataProperty.getPropertyName(), baseMetadataObject.getHolder(), (String)object);
            }
        } else if (metadataProperty instanceof MetadataStringProperty) {
            MetadataStringProperty metadataStringProperty = (MetadataStringProperty)metadataProperty;
            baseMetadataObjectState.setPropertyStringValue(metadataProperty.getPropertyName(), (String)copyPolicy.copyReference(metadataStringProperty.getPropertyValue(), copyReferenceType));
        } else if (metadataProperty instanceof MetadataAssociationProperty) {
            MetadataAssociationProperty metadataAssociationProperty = (MetadataAssociationProperty)metadataProperty;
            baseMetadataObjectState.setPropertyObjectValue(metadataProperty.getPropertyName(), ((BaseMetadataObject)copyPolicy.copyReference(metadataAssociationProperty.getObject(baseMetadataProvider), copyReferenceType)).getHolder());
        } else {
            throw new CopyException("Unknown property type.");
        }
    }

    void copyAllPropertiesTo(BaseMetadataObjectState baseMetadataObjectState, BaseMetadataProvider baseMetadataProvider, CopyPolicy copyPolicy, CopyPolicy.CopyReferenceType copyReferenceType) throws CopyException {
        MetadataProperty metadataProperty = null;
        Iterator iterator = this.m_properties.values().iterator();
        while (iterator.hasNext()) {
            metadataProperty = (MetadataProperty)iterator.next();
            if (null != baseMetadataObjectState.findProperty(metadataProperty.getPropertyName())) continue;
            this.copyPropertyTo(baseMetadataObjectState, metadataProperty, baseMetadataProvider, copyPolicy, copyReferenceType);
        }
    }
}

