/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.log;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.olapi.log.Log;
import oracle.olapi.log.LogEndEvent;
import oracle.olapi.log.LogEvent;
import oracle.olapi.log.LogEventFactory;
import oracle.olapi.log.LogHandler;
import oracle.olapi.log.LogHandlerCreator;
import oracle.olapi.log.LogSessionState;
import oracle.olapi.log.LogStartEvent;

public class LogSession
implements LogSessionState {
    private String tag = null;
    private Log instance = null;
    private Vector[] logHandlers = null;
    private Hashtable allHandlers = null;
    private int nestingLevel = 0;
    private LogEventFactory factory = null;

    private LogSession(Log log, String string) {
        this.instance = log;
        this.tag = string;
        this.logHandlers = new Vector[4];
        this.factory = new LogEventFactory(this);
        for (int i = 0; i < this.logHandlers.length; ++i) {
            this.logHandlers[i] = new Vector(2, 2);
        }
        this.allHandlers = new Hashtable();
        this.init();
    }

    static LogSession createInstance(Log log, String string) {
        LogSession logSession = new LogSession(log, string);
        log._registerSession(logSession);
        return logSession;
    }

    public final void destroy() {
        try {
            this.removeAllHandlers();
            this.cleanup();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasHandlers() {
        return !this.allHandlers.isEmpty();
    }

    public void incNestingLevel() {
        ++this.nestingLevel;
    }

    public void decNestingLevel() {
        if (this.nestingLevel > 0) {
            --this.nestingLevel;
        }
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public LogEvent createEvent(int n, String string) {
        return this.factory.createSimpleEvent(n, string);
    }

    public LogStartEvent createStartEvent(int n, String string) {
        return this.factory.createStartEvent(n, string);
    }

    public LogEndEvent createElapsedEvent(LogEvent logEvent, String string) {
        return this.factory.createElapsedEvent(logEvent, string);
    }

    public LogEndEvent createElapsedEvent(LogEvent logEvent) {
        return this.factory.createElapsedEvent(logEvent, logEvent.getMessage());
    }

    public LogEndEvent createEndEvent(LogStartEvent logStartEvent, String string) {
        return this.factory.createEndEvent(logStartEvent, string);
    }

    public LogEndEvent createEndEvent(LogStartEvent logStartEvent) {
        return this.factory.createEndEvent(logStartEvent, logStartEvent.getMessage());
    }

    public LogEvent createExceptionEvent(int n, String string, Throwable throwable) {
        return this.factory.createExceptionEvent(n, string, throwable);
    }

    public void addMessage(LogEvent logEvent) {
        Enumeration enumeration = this.logHandlers[this.getIndex(logEvent.getLevel())].elements();
        while (enumeration.hasMoreElements()) {
            ((LogHandler)enumeration.nextElement()).addMessage(logEvent);
        }
    }

    protected int getIndex(int n) {
        return n - 1;
    }

    public void addHandler(LogHandler logHandler, int n) throws Exception {
        if (logHandler != null) {
            if (this.allHandlers.contains(logHandler)) {
                this._removeHandler(logHandler);
            } else {
                logHandler.start();
            }
            this._addHandler(logHandler, n);
        }
    }

    public void removeHandler(LogHandler logHandler) {
        if (logHandler != null && this.allHandlers.contains(logHandler)) {
            this._removeHandler(logHandler);
            logHandler.stop();
        }
    }

    public void removeAllHandlers() {
        Hashtable hashtable = (Hashtable)this.allHandlers.clone();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ((LogHandler)enumeration.nextElement()).stop();
        }
        for (int i = 0; i < this.logHandlers.length; ++i) {
            this.logHandlers[i] = new Vector();
        }
        this.allHandlers.clear();
    }

    public void addHandlers(String string, Properties properties) throws Exception {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":, ", false);
        while (stringTokenizer.hasMoreElements()) {
            try {
                String string2;
                LogHandler logHandler;
                String string3 = stringTokenizer.nextToken();
                int n = Log.getLevelFromString(stringTokenizer.nextToken());
                if (!Log.isValidLevel(n) || (logHandler = LogHandlerCreator.createHandlerFromString(string2 = properties.getProperty(string3), properties)) == null) continue;
                this.addHandler(logHandler, n);
            }
            catch (Exception exception) {}
        }
    }

    protected void init() {
    }

    private void _addHandler(LogHandler logHandler, int n) {
        if (!Log.isValidLevel(n)) {
            return;
        }
        for (int i = this.getIndex(4); i >= this.getIndex(n); --i) {
            this.logHandlers[i].addElement(logHandler);
        }
        this.allHandlers.put(logHandler, new Integer(n));
    }

    private void _removeHandler(LogHandler logHandler) {
        Integer n = (Integer)this.allHandlers.get(logHandler);
        if (n != null) {
            int n2 = this.getIndex(n);
            for (int i = this.getIndex(4); i >= n2; --i) {
                this.logHandlers[i].removeElement(logHandler);
            }
            this.allHandlers.remove(logHandler);
        }
    }

    protected void cleanup() {
        this.instance._unregisterSession(this);
    }
}

