/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.olapi.data.source.AliasDefinition;
import oracle.olapi.data.source.Assignment;
import oracle.olapi.data.source.ConstantListDefinition;
import oracle.olapi.data.source.CustomModel;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.DistinctDefinition;
import oracle.olapi.data.source.DynamicDefinition;
import oracle.olapi.data.source.ExtractDefinition;
import oracle.olapi.data.source.HiddenDefinition;
import oracle.olapi.data.source.JoinDefinition;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.ModelSolutionDefinition;
import oracle.olapi.data.source.NullSourceDefinition;
import oracle.olapi.data.source.PositionDefinition;
import oracle.olapi.data.source.Qualification;
import oracle.olapi.data.source.RangeDefinition;
import oracle.olapi.data.source.RecursiveJoinDefinition;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.ValueDefinition;
import oracle.olapi.transaction.TransactionalObject;

final class SourcePrinterCatalog
extends DataDescriptorDefinitionVisitor {
    private Set m_VisitedObjects = new HashSet();
    private List m_NamedDefinitions = new ArrayList();
    private List m_NamedModels = new ArrayList();
    private Map m_ObjectToNameMap = new HashMap();

    public SourcePrinterCatalog(SourceDefinition sourceDefinition) {
        sourceDefinition.acceptVisitor(this, null);
    }

    private Map getObjectToNameMap() {
        return this.m_ObjectToNameMap;
    }

    private Set getVisitedObjects() {
        return this.m_VisitedObjects;
    }

    private List getNamedDefinitions() {
        return this.m_NamedDefinitions;
    }

    private List getNamedModels() {
        return this.m_NamedModels;
    }

    private boolean catalogDefinition(SourceDefinition sourceDefinition) {
        return this.catalogDefinition(sourceDefinition, false);
    }

    private boolean catalogDefinition(SourceDefinition sourceDefinition, boolean bl) {
        if (this.getObjectToNameMap().containsKey(sourceDefinition)) {
            return false;
        }
        if (bl || this.getVisitedObjects().contains(sourceDefinition)) {
            this.getNamedDefinitions().add(sourceDefinition);
            String string = "source" + sourceDefinition.getSource().getID().replace('!', '_').replace('.', '_').replace('[', '_').replace(']', '_');
            this.getObjectToNameMap().put(sourceDefinition, string);
            return false;
        }
        this.getVisitedObjects().add(sourceDefinition);
        return true;
    }

    private boolean catalogModel(Model model) {
        return this.catalogModel(model, false);
    }

    private boolean catalogModel(Model model, boolean bl) {
        if (this.getObjectToNameMap().containsKey(model)) {
            return false;
        }
        if (bl || this.getVisitedObjects().contains(model) || model.getAssignments().size() > 0) {
            this.getNamedModels().add(model);
            String string = "model" + model.getID().replace('!', '_').replace('.', '_').replace('[', '_').replace(']', '_');
            this.getObjectToNameMap().put(model, string);
            return false;
        }
        this.getVisitedObjects().add(model);
        return true;
    }

    public final Iterator getNamedDefinitionsIterator() {
        return this.getNamedDefinitions().iterator();
    }

    public final Iterator getNamedModelsIterator() {
        return this.getNamedModels().iterator();
    }

    public final String getDefinitionName(SourceDefinition sourceDefinition) {
        return (String)this.getObjectToNameMap().get(sourceDefinition);
    }

    public final String getModelName(Model model) {
        return (String)this.getObjectToNameMap().get(model);
    }

    public Object visitSourceDefinition(SourceDefinition sourceDefinition, Object object) {
        return null;
    }

    public Object visitDynamicDefinition(DynamicDefinition dynamicDefinition, Object object) {
        dynamicDefinition.getCurrent().acceptVisitor(this, object);
        return null;
    }

    public Object visitConstantListDefinition(ConstantListDefinition constantListDefinition, Object object) {
        if (!this.catalogDefinition(constantListDefinition)) {
            return null;
        }
        Iterator iterator = constantListDefinition.getElements().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SourceDefinition)) continue;
            SourceDefinition sourceDefinition = (SourceDefinition)e;
            sourceDefinition.acceptVisitor(this, object);
            sourceDefinition.acceptVisitor(this, object);
        }
        return null;
    }

    public final Object visitRangeDefinition(RangeDefinition rangeDefinition, Object object) {
        if (!this.catalogDefinition(rangeDefinition)) {
            return null;
        }
        rangeDefinition.getBottom().acceptVisitor(this, object);
        rangeDefinition.getTop().acceptVisitor(this, object);
        return null;
    }

    public final Object visitAliasDefinition(AliasDefinition aliasDefinition, Object object) {
        if (!this.catalogDefinition(aliasDefinition)) {
            return null;
        }
        aliasDefinition.getBase().acceptVisitor(this, object);
        return null;
    }

    public final Object visitDistinctDefinition(DistinctDefinition distinctDefinition, Object object) {
        if (!this.catalogDefinition(distinctDefinition)) {
            return null;
        }
        distinctDefinition.getBase().acceptVisitor(this, object);
        return null;
    }

    public final Object visitExtractDefinition(ExtractDefinition extractDefinition, Object object) {
        if (!this.catalogDefinition(extractDefinition)) {
            return null;
        }
        extractDefinition.getBase().acceptVisitor(this, object);
        return null;
    }

    public final Object visitJoinDefinition(JoinDefinition joinDefinition, Object object) {
        if (!this.catalogDefinition(joinDefinition)) {
            return null;
        }
        joinDefinition.getBase().acceptVisitor(this, object);
        joinDefinition.getJoined().acceptVisitor(this, object);
        joinDefinition.getComparison().acceptVisitor(this, object);
        return null;
    }

    public final Object visitPositionDefinition(PositionDefinition positionDefinition, Object object) {
        if (!this.catalogDefinition(positionDefinition)) {
            return null;
        }
        positionDefinition.getBase().acceptVisitor(this, object);
        return null;
    }

    public final Object visitValueDefinition(ValueDefinition valueDefinition, Object object) {
        if (!this.catalogDefinition(valueDefinition)) {
            return null;
        }
        valueDefinition.getBase().acceptVisitor(this, object);
        valueDefinition.getInput().acceptVisitor(this, object);
        return null;
    }

    public Object visitHiddenDefinition(HiddenDefinition hiddenDefinition, Object object) {
        this.catalogDefinition(hiddenDefinition, true);
        return null;
    }

    public Object visitRecursiveJoinDefinition(RecursiveJoinDefinition recursiveJoinDefinition, Object object) {
        if (!this.catalogDefinition(recursiveJoinDefinition)) {
            return null;
        }
        recursiveJoinDefinition.getBase().acceptVisitor(this, object);
        recursiveJoinDefinition.getJoined().acceptVisitor(this, object);
        recursiveJoinDefinition.getComparison().acceptVisitor(this, object);
        recursiveJoinDefinition.getParent().acceptVisitor(this, object);
        return null;
    }

    public Object visitNullDefinition(NullSourceDefinition nullSourceDefinition, Object object) {
        if (!this.catalogDefinition(nullSourceDefinition)) {
            return null;
        }
        nullSourceDefinition.getBase().acceptVisitor(this, object);
        return null;
    }

    public Object visitModelSolutionDefinition(ModelSolutionDefinition modelSolutionDefinition, Object object) {
        if (!this.catalogDefinition(modelSolutionDefinition)) {
            return null;
        }
        modelSolutionDefinition.getDefaultValuesDefinition().acceptVisitor(this, object);
        this.visitModel(modelSolutionDefinition.getModel());
        return null;
    }

    private void visitModel(Model model) {
        if (model instanceof CustomModel) {
            if (this.catalogModel(model)) {
                this.visitCustomModel((CustomModel)model);
            }
        } else {
            this.catalogModel(model, true);
        }
        this.visitModelAssignments(model);
    }

    private void visitCustomModel(CustomModel customModel) {
        TransactionalObject transactionalObject;
        customModel.getType().getDefinition().acceptVisitor(this, null);
        Iterator iterator = customModel.getInputs().iterator();
        while (iterator.hasNext()) {
            transactionalObject = (Source)iterator.next();
            transactionalObject.getDefinition().acceptVisitor(this, null);
        }
        iterator = customModel.getOutputs().iterator();
        while (iterator.hasNext()) {
            transactionalObject = (Source)iterator.next();
            transactionalObject.getDefinition().acceptVisitor(this, null);
        }
        iterator = customModel.getParentModels().iterator();
        while (iterator.hasNext()) {
            transactionalObject = (Model)iterator.next();
            this.visitModel((Model)transactionalObject);
        }
    }

    private void visitModelAssignments(Model model) {
        Iterator iterator = model.getAssignments().iterator();
        while (iterator.hasNext()) {
            Assignment assignment = (Assignment)iterator.next();
            assignment.getAssignedSource().getDefinition().acceptVisitor(this, null);
            Iterator iterator2 = assignment.getQualifications().iterator();
            while (iterator2.hasNext()) {
                Qualification qualification = (Qualification)iterator2.next();
                qualification.getQualifiedSource().getDefinition().acceptVisitor(this, null);
            }
        }
    }
}

