/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.olapi.data.source.AliasDefinition;
import oracle.olapi.data.source.ConstantListDefinition;
import oracle.olapi.data.source.CustomModel;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.DistinctDefinition;
import oracle.olapi.data.source.DynamicDefinition;
import oracle.olapi.data.source.ExtractDefinition;
import oracle.olapi.data.source.HiddenDefinition;
import oracle.olapi.data.source.JoinDefinition;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.ModelSolutionDefinition;
import oracle.olapi.data.source.NullSourceDefinition;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.ParameterizedSourceDefinition;
import oracle.olapi.data.source.PositionDefinition;
import oracle.olapi.data.source.RangeDefinition;
import oracle.olapi.data.source.RecursiveJoinDefinition;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.SourceDefinitionVisitor;
import oracle.olapi.data.source.ValueDefinition;
import oracle.olapi.metadata.mdm.MdmModel;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmSource;
import oracle.olapi.metadata.mdm.MdmSourceDefinition;
import oracle.olapi.transaction.Transaction;

public class SourceDefinitionTraverser
extends SourceDefinitionVisitor {
    protected DataDescriptorDefinitionVisitor _enterVisitor = null;
    protected DataDescriptorDefinitionVisitor _exitVisitor = null;
    protected SimpleTraversalVisitor _enterVisitFunction = null;
    protected SimpleTraversalVisitor _exitVisitFunction = null;
    protected Set _visitedObjects = new HashSet(100);
    protected Transaction _transaction = null;

    protected SourceDefinitionTraverser(Transaction transaction) {
        this._transaction = transaction;
    }

    public SourceDefinitionTraverser(Transaction transaction, DataDescriptorDefinitionVisitor dataDescriptorDefinitionVisitor) {
        this._transaction = transaction;
        this._enterVisitor = dataDescriptorDefinitionVisitor;
    }

    public SourceDefinitionTraverser(Transaction transaction, DataDescriptorDefinitionVisitor dataDescriptorDefinitionVisitor, DataDescriptorDefinitionVisitor dataDescriptorDefinitionVisitor2) {
        this._transaction = transaction;
        this._enterVisitor = dataDescriptorDefinitionVisitor;
        this._exitVisitor = dataDescriptorDefinitionVisitor2;
    }

    public SourceDefinitionTraverser(Transaction transaction, SimpleTraversalVisitor simpleTraversalVisitor) {
        this._transaction = transaction;
        this._enterVisitFunction = simpleTraversalVisitor;
    }

    public SourceDefinitionTraverser(Transaction transaction, SimpleTraversalVisitor simpleTraversalVisitor, SimpleTraversalVisitor simpleTraversalVisitor2) {
        this._transaction = transaction;
        this._enterVisitFunction = simpleTraversalVisitor;
        this._exitVisitFunction = simpleTraversalVisitor2;
    }

    public Transaction getTransaction() {
        return this._transaction;
    }

    public void setTransaction(Transaction transaction) {
        this._transaction = transaction;
    }

    public void reset() {
        this._visitedObjects.clear();
    }

    public void traverseDefinitionTree(SourceDefinition sourceDefinition) {
        this.visitDefinition(sourceDefinition);
    }

    public final void traverseDefinitionTree(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Source) {
                this.visitSource((Source)e);
                continue;
            }
            this.visitDefinition((SourceDefinition)e);
        }
    }

    protected void visitDefinition(SourceDefinition sourceDefinition) {
        if (sourceDefinition == null) {
            return;
        }
        if (this._visitedObjects.contains(sourceDefinition)) {
            return;
        }
        this._visitedObjects.add(sourceDefinition);
        if (this._enterVisitFunction != null) {
            this._enterVisitFunction.visitDefinition(sourceDefinition);
        }
        sourceDefinition.acceptVisitor(this, null);
        if (this._exitVisitFunction != null) {
            this._exitVisitFunction.visitDefinition(sourceDefinition);
        }
    }

    public Object visitAliasDefinition(AliasDefinition aliasDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitAliasDefinition(aliasDefinition, object);
        }
        this.visitDefinition(aliasDefinition.getBase());
        if (this._exitVisitor != null) {
            this._exitVisitor.visitAliasDefinition(aliasDefinition, object);
        }
        return null;
    }

    public Object visitDistinctDefinition(DistinctDefinition distinctDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitDistinctDefinition(distinctDefinition, object);
        }
        this.visitDefinition(distinctDefinition.getBase());
        if (this._exitVisitor != null) {
            this._exitVisitor.visitDistinctDefinition(distinctDefinition, object);
        }
        return null;
    }

    public Object visitNullDefinition(NullSourceDefinition nullSourceDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitNullDefinition(nullSourceDefinition, object);
        }
        this.visitDefinition(nullSourceDefinition.getBase());
        if (this._exitVisitor != null) {
            this._exitVisitor.visitNullDefinition(nullSourceDefinition, object);
        }
        return null;
    }

    public Object visitExtractDefinition(ExtractDefinition extractDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitExtractDefinition(extractDefinition, object);
        }
        this.visitDefinition(extractDefinition.getBase());
        if (this._exitVisitor != null) {
            this._exitVisitor.visitExtractDefinition(extractDefinition, object);
        }
        return null;
    }

    public Object visitParameterizedSourceDefinition(ParameterizedSourceDefinition parameterizedSourceDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitParameterizedSourceDefinition(parameterizedSourceDefinition, object);
        }
        if (this._enterVisitFunction != null) {
            this._enterVisitFunction.visitParameter(parameterizedSourceDefinition.getParameter());
        }
        if (this._exitVisitFunction != null) {
            this._exitVisitFunction.visitParameter(parameterizedSourceDefinition.getParameter());
        }
        if (this._exitVisitor != null) {
            this._exitVisitor.visitParameterizedSourceDefinition(parameterizedSourceDefinition, object);
        }
        return null;
    }

    public Object visitPositionDefinition(PositionDefinition positionDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitPositionDefinition(positionDefinition, object);
        }
        this.visitDefinition(positionDefinition.getBase());
        if (this._exitVisitor != null) {
            this._exitVisitor.visitPositionDefinition(positionDefinition, object);
        }
        return null;
    }

    public Object visitValueDefinition(ValueDefinition valueDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitValueDefinition(valueDefinition, object);
        }
        this.visitDefinition(valueDefinition.getBase());
        this.visitDefinition(valueDefinition.getInput());
        if (this._exitVisitor != null) {
            this._exitVisitor.visitValueDefinition(valueDefinition, object);
        }
        return null;
    }

    public Object visitJoinDefinition(JoinDefinition joinDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitJoinDefinition(joinDefinition, object);
        }
        this.visitDefinition(joinDefinition.getBase());
        this.visitDefinition(joinDefinition.getJoined());
        this.visitDefinition(joinDefinition.getComparison());
        if (this._exitVisitor != null) {
            this._exitVisitor.visitJoinDefinition(joinDefinition, object);
        }
        return null;
    }

    public Object visitRecursiveJoinDefinition(RecursiveJoinDefinition recursiveJoinDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitRecursiveJoinDefinition(recursiveJoinDefinition, object);
        }
        this.visitDefinition(recursiveJoinDefinition.getBase());
        this.visitDefinition(recursiveJoinDefinition.getJoined());
        this.visitDefinition(recursiveJoinDefinition.getComparison());
        this.visitDefinition(recursiveJoinDefinition.getParent());
        if (this._exitVisitor != null) {
            this._exitVisitor.visitRecursiveJoinDefinition(recursiveJoinDefinition, object);
        }
        return null;
    }

    public Object visitConstantListDefinition(ConstantListDefinition constantListDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitConstantListDefinition(constantListDefinition, object);
        }
        List list = constantListDefinition.getElements();
        Object var4_4 = null;
        if (!list.isEmpty()) {
            var4_4 = list.get(0);
        }
        if (var4_4 instanceof SourceDefinition) {
            for (int i = 0; i < list.size(); ++i) {
                this.visitDefinition((SourceDefinition)list.get(i));
            }
        }
        if (this._exitVisitor != null) {
            this._exitVisitor.visitConstantListDefinition(constantListDefinition, object);
        }
        return null;
    }

    public Object visitRangeDefinition(RangeDefinition rangeDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitRangeDefinition(rangeDefinition, object);
        }
        this.visitDefinition(rangeDefinition.getBottom());
        this.visitDefinition(rangeDefinition.getTop());
        if (this._exitVisitor != null) {
            this._exitVisitor.visitRangeDefinition(rangeDefinition, object);
        }
        return null;
    }

    public Object visitHiddenDefinition(HiddenDefinition hiddenDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitHiddenDefinition(hiddenDefinition, object);
        }
        if (hiddenDefinition instanceof MdmSourceDefinition) {
            MdmSource mdmSource = ((MdmSourceDefinition)hiddenDefinition).getMdmSource();
            if (this._enterVisitFunction != null) {
                this._enterVisitFunction.visitMdmObject(mdmSource);
            }
            ArrayList arrayList = new ArrayList();
            mdmSource.gatherReferencedSources(arrayList, this.getTransaction());
            this.visitSourceList(arrayList);
            if (this._exitVisitFunction != null) {
                this._exitVisitFunction.visitMdmObject(mdmSource);
            }
        }
        if (this._exitVisitor != null) {
            this._exitVisitor.visitHiddenDefinition(hiddenDefinition, object);
        }
        return null;
    }

    public Object visitDynamicDefinition(DynamicDefinition dynamicDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitDynamicDefinition(dynamicDefinition, object);
        }
        this.visitDefinition(dynamicDefinition.getCurrent(this.getTransaction()));
        if (this._exitVisitor != null) {
            this._exitVisitor.visitDynamicDefinition(dynamicDefinition, object);
        }
        return null;
    }

    public Object visitModelSolutionDefinition(ModelSolutionDefinition modelSolutionDefinition, Object object) {
        if (this._enterVisitor != null) {
            this._enterVisitor.visitModelSolutionDefinition(modelSolutionDefinition, object);
        }
        this.visitDefinition(modelSolutionDefinition.getDefaultValuesDefinition());
        this.visitModel(modelSolutionDefinition.getModel());
        if (this._exitVisitor != null) {
            this._exitVisitor.visitModelSolutionDefinition(modelSolutionDefinition, object);
        }
        return null;
    }

    public Object visitModel(Model model) {
        if (this._visitedObjects.contains(model)) {
            return null;
        }
        this._visitedObjects.add(model);
        if (model instanceof MdmModel) {
            this.visitMdmModel((MdmModel)model);
        } else {
            this.visitCustomModel((CustomModel)model);
        }
        return null;
    }

    public Object visitCustomModel(CustomModel customModel) {
        if (this._enterVisitFunction != null) {
            this._enterVisitFunction.visitModel(customModel);
        }
        this.visitSourceList(customModel.getInputs());
        this.visitSourceList(customModel.getOutputs());
        this.visitSource(customModel.getType());
        Iterator iterator = customModel.getParentModels().iterator();
        while (iterator.hasNext()) {
            this.visitModel((Model)iterator.next());
        }
        ArrayList arrayList = new ArrayList();
        customModel.gatherSourcesInAssignments(arrayList, this.getTransaction());
        this.visitSourceList(arrayList);
        if (this._exitVisitFunction != null) {
            this._exitVisitFunction.visitModel(customModel);
        }
        return null;
    }

    public Object visitMdmModel(MdmModel mdmModel) {
        if (this._enterVisitFunction != null) {
            this._enterVisitFunction.visitMdmObject(mdmModel);
        }
        ArrayList arrayList = new ArrayList();
        mdmModel.gatherReferencedSources(arrayList, this.getTransaction());
        this.visitSourceList(arrayList);
        if (this._exitVisitFunction != null) {
            this._exitVisitFunction.visitMdmObject(mdmModel);
        }
        return null;
    }

    public final void visitSourceList(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.visitSource((Source)iterator.next());
        }
    }

    public final void visitSource(Source source) {
        this.visitDefinition(source.getDefinition());
    }

    public static abstract class SimpleTraversalVisitor {
        public abstract void visitDefinition(SourceDefinition var1);

        public void visitParameter(Parameter parameter) {
        }

        public void visitModel(Model model) {
        }

        public void visitMdmObject(MdmObject mdmObject) {
        }
    }
}

