/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import oracle.olapi.data.source.BooleanSource;
import oracle.olapi.data.source.DataTypeDefinition;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;

public final class NumberSource
extends Source {
    NumberSource(SourceDefinition sourceDefinition) {
        super(sourceDefinition);
    }

    public final NumberSource abs() {
        return this.getSourceExpressionFactory().abs(this);
    }

    public final NumberSource appendValue(double d) {
        return this.appendValues(new double[]{d});
    }

    public final NumberSource appendValue(float f) {
        return this.appendValues(new float[]{f});
    }

    public final NumberSource appendValue(int n) {
        return this.appendValues(new int[]{n});
    }

    public final NumberSource appendValue(short s) {
        return this.appendValues(new short[]{s});
    }

    public final NumberSource appendValues(double[] dArray) {
        return (NumberSource)this.appendValue(this.getDataProvider().createListSource(dArray));
    }

    public final NumberSource appendValues(float[] fArray) {
        return (NumberSource)this.appendValue(this.getDataProvider().createListSource(fArray));
    }

    public final NumberSource appendValues(int[] nArray) {
        return (NumberSource)this.appendValue(this.getDataProvider().createListSource(nArray));
    }

    public final NumberSource appendValues(short[] sArray) {
        return (NumberSource)this.appendValue(this.getDataProvider().createListSource(sArray));
    }

    public final NumberSource arccos() {
        return this.getSourceExpressionFactory().arccos(this);
    }

    public final NumberSource arcsin() {
        return this.getSourceExpressionFactory().arcsin(this);
    }

    public final NumberSource arctan() {
        return this.getSourceExpressionFactory().arctan(this);
    }

    public final NumberSource average() {
        return this.average(true);
    }

    public final NumberSource average(boolean bl) {
        return this.getSourceExpressionFactory().average(this, bl);
    }

    public final NumberSource cos() {
        return this.getSourceExpressionFactory().cos(this);
    }

    public final NumberSource cosh() {
        return this.getSourceExpressionFactory().cosh(this);
    }

    Source createInstance(SourceDefinition sourceDefinition) {
        return new NumberSource(sourceDefinition);
    }

    public final NumberSource div(double d) {
        return this.div(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final NumberSource div(double d, boolean bl) {
        return this.div(this.getDataProvider().createListSource(new double[]{d}), bl);
    }

    public final NumberSource div(float f) {
        return this.div(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final NumberSource div(float f, boolean bl) {
        return this.div(this.getDataProvider().createListSource(new float[]{f}), bl);
    }

    public final NumberSource div(int n) {
        return this.div(this.getDataProvider().createListSource(new int[]{n}), false);
    }

    public final NumberSource div(int n, boolean bl) {
        return this.div(this.getDataProvider().createListSource(new int[]{n}), bl);
    }

    public final NumberSource div(NumberSource numberSource) {
        return this.getSourceExpressionFactory().div(this, numberSource, false);
    }

    public final NumberSource div(NumberSource numberSource, boolean bl) {
        return this.getSourceExpressionFactory().div(this, numberSource, bl);
    }

    public final NumberSource div(short s) {
        return this.div(this.getDataProvider().createListSource(new short[]{s}));
    }

    public final NumberSource div(short s, boolean bl) {
        return this.div(this.getDataProvider().createListSource(new short[]{s}), bl);
    }

    public final BooleanSource eq(double d) {
        return this.eq(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final BooleanSource eq(float f) {
        return this.eq(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final BooleanSource eq(int n) {
        return this.eq(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final BooleanSource eq(short s) {
        return this.eq(this.getDataProvider().createListSource(new short[]{s}));
    }

    public final BooleanSource ge(double d) {
        return this.ge(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final BooleanSource ge(float f) {
        return this.ge(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final BooleanSource ge(int n) {
        return this.ge(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final BooleanSource ge(short s) {
        return this.ge(this.getDataProvider().createListSource(new short[]{s}));
    }

    public Source getDataType() {
        if (this.getDefinition() instanceof DataTypeDefinition) {
            return this;
        }
        return this.getType().getDataType();
    }

    public final BooleanSource gt(double d) {
        return this.gt(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final BooleanSource gt(float f) {
        return this.gt(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final BooleanSource gt(int n) {
        return this.gt(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final BooleanSource gt(short s) {
        return this.gt(this.getDataProvider().createListSource(new short[]{s}));
    }

    public final NumberSource intpart() {
        return this.getSourceExpressionFactory().intpart(this);
    }

    public final BooleanSource le(double d) {
        return this.le(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final BooleanSource le(float f) {
        return this.le(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final BooleanSource le(int n) {
        return this.le(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final BooleanSource le(short s) {
        return this.le(this.getDataProvider().createListSource(new short[]{s}));
    }

    public final NumberSource log() {
        return this.getSourceExpressionFactory().log(this);
    }

    public final BooleanSource lt(double d) {
        return this.lt(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final BooleanSource lt(float f) {
        return this.lt(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final BooleanSource lt(int n) {
        return this.lt(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final BooleanSource lt(short s) {
        return this.lt(this.getDataProvider().createListSource(new short[]{s}));
    }

    public final NumberSource maximum() {
        return this.maximum(true);
    }

    public final NumberSource maximum(boolean bl) {
        return this.getSourceExpressionFactory().maximum(this, bl);
    }

    public final NumberSource minimum() {
        return this.minimum(true);
    }

    public final NumberSource minimum(boolean bl) {
        return this.getSourceExpressionFactory().minimum(this, bl);
    }

    public final NumberSource minus(double d) {
        return this.minus(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final NumberSource minus(float f) {
        return this.minus(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final NumberSource minus(int n) {
        return this.minus(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final NumberSource minus(NumberSource numberSource) {
        return this.getSourceExpressionFactory().minus(this, numberSource);
    }

    public final NumberSource minus(short s) {
        return this.minus(this.getDataProvider().createListSource(new short[]{s}));
    }

    public final BooleanSource ne(double d) {
        return this.ne(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final BooleanSource ne(float f) {
        return this.ne(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final BooleanSource ne(int n) {
        return this.ne(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final BooleanSource ne(short s) {
        return this.ne(this.getDataProvider().createListSource(new short[]{s}));
    }

    public final NumberSource negate() {
        return this.getSourceExpressionFactory().negate(this);
    }

    public final NumberSource plus(double d) {
        return this.plus(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final NumberSource plus(float f) {
        return this.plus(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final NumberSource plus(int n) {
        return this.plus(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final NumberSource plus(NumberSource numberSource) {
        return this.getSourceExpressionFactory().plus(this, numberSource);
    }

    public final NumberSource plus(short s) {
        return this.plus(this.getDataProvider().createListSource(new short[]{s}));
    }

    public final NumberSource positionOfValue(double d) {
        return this.positionOfValues(new double[]{d});
    }

    public final NumberSource positionOfValue(float f) {
        return this.positionOfValues(new float[]{f});
    }

    public final NumberSource positionOfValue(int n) {
        return this.positionOfValues(new int[]{n});
    }

    public final NumberSource positionOfValue(short s) {
        return this.positionOfValues(new short[]{s});
    }

    public final NumberSource positionOfValues(double[] dArray) {
        return this.positionOfValues(this.getDataProvider().createListSource(dArray));
    }

    public final NumberSource positionOfValues(float[] fArray) {
        return this.positionOfValues(this.getDataProvider().createListSource(fArray));
    }

    public final NumberSource positionOfValues(int[] nArray) {
        return this.positionOfValues(this.getDataProvider().createListSource(nArray));
    }

    public final NumberSource positionOfValues(short[] sArray) {
        return this.positionOfValues(this.getDataProvider().createListSource(sArray));
    }

    public final NumberSource pow(double d) {
        return this.pow(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final NumberSource pow(float f) {
        return this.pow(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final NumberSource pow(int n) {
        return this.pow(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final NumberSource pow(NumberSource numberSource) {
        return this.getSourceExpressionFactory().pow(this, numberSource);
    }

    public final NumberSource pow(short s) {
        return this.pow(this.getDataProvider().createListSource(new short[]{s}));
    }

    public final NumberSource rem(double d) {
        return this.rem(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final NumberSource rem(float f) {
        return this.rem(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final NumberSource rem(int n) {
        return this.rem(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final NumberSource rem(NumberSource numberSource) {
        return this.getSourceExpressionFactory().rem(this, numberSource);
    }

    public final NumberSource rem(short s) {
        return this.rem(this.getDataProvider().createListSource(new short[]{s}));
    }

    public final NumberSource removeValue(double d) {
        return this.removeValues(new double[]{d});
    }

    public final NumberSource removeValue(float f) {
        return this.removeValues(new float[]{f});
    }

    public final NumberSource removeValue(int n) {
        return this.removeValues(new int[]{n});
    }

    public final NumberSource removeValue(short s) {
        return this.removeValues(new short[]{s});
    }

    public final NumberSource removeValues(double[] dArray) {
        return (NumberSource)this.removeValues(this.getDataProvider().createListSource(dArray));
    }

    public final NumberSource removeValues(float[] fArray) {
        return (NumberSource)this.removeValues(this.getDataProvider().createListSource(fArray));
    }

    public final NumberSource removeValues(int[] nArray) {
        return (NumberSource)this.removeValues(this.getDataProvider().createListSource(nArray));
    }

    public final NumberSource removeValues(short[] sArray) {
        return (NumberSource)this.removeValues(this.getDataProvider().createListSource(sArray));
    }

    public final NumberSource round(double d) {
        return this.round(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final NumberSource round(float f) {
        return this.round(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final NumberSource round(int n) {
        return this.round(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final NumberSource round(NumberSource numberSource) {
        return this.getSourceExpressionFactory().round(this, numberSource);
    }

    public final NumberSource round(short s) {
        return this.round(this.getDataProvider().createListSource(new short[]{s}));
    }

    public final NumberSource selectValue(double d) {
        return this.selectValues(new double[]{d});
    }

    public final NumberSource selectValue(float f) {
        return this.selectValues(new float[]{f});
    }

    public final NumberSource selectValue(int n) {
        return this.selectValues(new int[]{n});
    }

    public final NumberSource selectValue(short s) {
        return this.selectValues(new short[]{s});
    }

    public final NumberSource selectValues(double[] dArray) {
        return (NumberSource)this.selectValues(this.getDataProvider().createListSource(dArray));
    }

    public final NumberSource selectValues(float[] fArray) {
        return (NumberSource)this.selectValues(this.getDataProvider().createListSource(fArray));
    }

    public final NumberSource selectValues(int[] nArray) {
        return (NumberSource)this.selectValues(this.getDataProvider().createListSource(nArray));
    }

    public final NumberSource selectValues(short[] sArray) {
        return (NumberSource)this.selectValues(this.getDataProvider().createListSource(sArray));
    }

    public final NumberSource sin() {
        return this.getSourceExpressionFactory().sin(this);
    }

    public final NumberSource sinh() {
        return this.getSourceExpressionFactory().sinh(this);
    }

    public final NumberSource sqrt() {
        return this.getSourceExpressionFactory().sqrt(this);
    }

    public final NumberSource stdev() {
        return this.stdev(true);
    }

    public final NumberSource stdev(boolean bl) {
        return this.getSourceExpressionFactory().stdev(this, bl);
    }

    public final NumberSource tan() {
        return this.getSourceExpressionFactory().tan(this);
    }

    public final NumberSource tanh() {
        return this.getSourceExpressionFactory().tanh(this);
    }

    public final NumberSource times(double d) {
        return this.times(this.getDataProvider().createListSource(new double[]{d}));
    }

    public final NumberSource times(float f) {
        return this.times(this.getDataProvider().createListSource(new float[]{f}));
    }

    public final NumberSource times(int n) {
        return this.times(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final NumberSource times(NumberSource numberSource) {
        return this.getSourceExpressionFactory().times(this, numberSource);
    }

    public final NumberSource times(short s) {
        return this.times(this.getDataProvider().createListSource(new short[]{s}));
    }

    public final NumberSource total() {
        return this.total(true);
    }

    public final NumberSource total(boolean bl) {
        return this.getSourceExpressionFactory().total(this, bl);
    }

    public final NumberSource lead(MdmLevelHierarchy mdmLevelHierarchy, int n) {
        return this.lag(mdmLevelHierarchy, -n);
    }

    public final NumberSource lag(MdmLevelHierarchy mdmLevelHierarchy, int n) {
        return this.getSourceExpressionFactory().lag(this, mdmLevelHierarchy, n);
    }

    public final NumberSource lagMonths(MdmLevelHierarchy mdmLevelHierarchy, int n) {
        return this.getSourceExpressionFactory().lagMonths(this, mdmLevelHierarchy, n);
    }

    public final NumberSource lagQuarters(MdmLevelHierarchy mdmLevelHierarchy, int n) {
        return this.lagMonths(mdmLevelHierarchy, 3 * n);
    }

    public final NumberSource lagYears(MdmLevelHierarchy mdmLevelHierarchy, int n) {
        return this.lagMonths(mdmLevelHierarchy, 12 * n);
    }

    public final NumberSource lagDays(MdmLevelHierarchy mdmLevelHierarchy, int n) {
        return this.getSourceExpressionFactory().lagDays(this, mdmLevelHierarchy, n);
    }

    public final NumberSource lagWeeks(MdmLevelHierarchy mdmLevelHierarchy, int n) {
        return this.lagDays(mdmLevelHierarchy, 7 * n);
    }

    public final NumberSource cumulativeTotal(MdmLevelHierarchy mdmLevelHierarchy, int n) {
        return this.cumulativeTotal(mdmLevelHierarchy, n, null);
    }

    public final NumberSource cumulativeTotal(MdmLevelHierarchy mdmLevelHierarchy, int n, MdmLevel mdmLevel) {
        return this.getSourceExpressionFactory().cumulativeTotal(this, mdmLevelHierarchy, n, mdmLevel);
    }

    public final NumberSource cumulativeAverage(MdmLevelHierarchy mdmLevelHierarchy, int n) {
        return this.cumulativeAverage(mdmLevelHierarchy, n, null);
    }

    public final NumberSource cumulativeAverage(MdmLevelHierarchy mdmLevelHierarchy, int n, MdmLevel mdmLevel) {
        return this.getSourceExpressionFactory().cumulativeAverage(this, mdmLevelHierarchy, n, mdmLevel);
    }

    public final NumberSource cumulativeMaximum(MdmLevelHierarchy mdmLevelHierarchy, int n) {
        return this.cumulativeMaximum(mdmLevelHierarchy, n, null);
    }

    public final NumberSource cumulativeMaximum(MdmLevelHierarchy mdmLevelHierarchy, int n, MdmLevel mdmLevel) {
        return this.getSourceExpressionFactory().cumulativeMaximum(this, mdmLevelHierarchy, n, mdmLevel);
    }

    public final NumberSource cumulativeMinimum(MdmLevelHierarchy mdmLevelHierarchy, int n) {
        return this.cumulativeMinimum(mdmLevelHierarchy, n, null);
    }

    public final NumberSource cumulativeMinimum(MdmLevelHierarchy mdmLevelHierarchy, int n, MdmLevel mdmLevel) {
        return this.getSourceExpressionFactory().cumulativeMinimum(this, mdmLevelHierarchy, n, mdmLevel);
    }

    public final NumberSource movingTotal(MdmLevelHierarchy mdmLevelHierarchy, int n, int n2) {
        return this.getSourceExpressionFactory().movingTotal(this, mdmLevelHierarchy, n, n2);
    }

    public final NumberSource movingAverage(MdmLevelHierarchy mdmLevelHierarchy, int n, int n2) {
        return this.getSourceExpressionFactory().movingAverage(this, mdmLevelHierarchy, n, n2);
    }

    public final NumberSource movingMaximum(MdmLevelHierarchy mdmLevelHierarchy, int n, int n2) {
        return this.getSourceExpressionFactory().movingMaximum(this, mdmLevelHierarchy, n, n2);
    }

    public final NumberSource movingMinimum(MdmLevelHierarchy mdmLevelHierarchy, int n, int n2) {
        return this.getSourceExpressionFactory().movingMinimum(this, mdmLevelHierarchy, n, n2);
    }

    public final NumberSource median() {
        return this.getSourceExpressionFactory().median(this);
    }

    public final NumberSource variance() {
        return this.getSourceExpressionFactory().variance(this);
    }

    public final NumberSource variancePop() {
        return this.getSourceExpressionFactory().variancePop(this);
    }

    public final NumberSource varianceSamp() {
        return this.getSourceExpressionFactory().varianceSamp(this);
    }

    public final NumberSource stdevPop() {
        return this.getSourceExpressionFactory().stdevPop(this);
    }

    public final NumberSource stdevSamp() {
        return this.getSourceExpressionFactory().stdevSamp(this);
    }

    public final NumberSource positionalPeriodsAgo(MdmLevelHierarchy mdmLevelHierarchy, MdmLevel mdmLevel, int n) {
        return this.getSourceExpressionFactory().positionalPeriodsAgo(this, mdmLevelHierarchy, mdmLevel, n);
    }
}

