/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.DerivedDefinition;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.transaction.Transaction;

public final class JoinDefinition
extends DerivedDefinition {
    private SourceDefinition m_Joined = null;
    private SourceDefinition m_Comparison = null;
    private int m_ComparisonRule = 0;
    private boolean m_Visible = true;

    public JoinDefinition(SourceDefinition sourceDefinition, SourceDefinition sourceDefinition2, SourceDefinition sourceDefinition3, int n, boolean bl, Transaction transaction) {
        super(sourceDefinition.getDataProvider()._getSourceIDProvider().createJoinID(), sourceDefinition, transaction);
        this.setJoined(sourceDefinition2);
        this.setComparison(sourceDefinition3);
        this.setComparisonRule(n);
        this.setVisible(bl);
    }

    public final Object acceptVisitor(DataDescriptorDefinitionVisitor dataDescriptorDefinitionVisitor, Object object) {
        return dataDescriptorDefinitionVisitor.visitJoinDefinition(this, object);
    }

    final void accumulateInputs(Set set, Transaction transaction, boolean bl, boolean bl2) {
        this.accumulateUnmatchedInputs(this.getBase(), this.getJoined(), set, bl, bl2, transaction);
        this.accumulateUnmatchedInputs(this.getJoined(), this.getBase(), set, bl, bl2, transaction);
        this.getComparison().accumulateInputs(set, transaction, bl, bl2);
    }

    final void accumulateOutputs(List list, Transaction transaction) {
        if (this.isVisible()) {
            list.add(this.getJoined().findOrCreateSource(transaction));
        }
        this.getBase().accumulateOutputs(list, transaction);
    }

    private void accumulateUnmatchedInputs(SourceDefinition sourceDefinition, SourceDefinition sourceDefinition2, Set set, boolean bl, boolean bl2, Transaction transaction) {
        SourceDefinition sourceDefinition3;
        Source source;
        HashSet hashSet = new HashSet();
        sourceDefinition.accumulateInputs(hashSet, transaction, false, true);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            source = (Source)iterator.next();
            sourceDefinition3 = sourceDefinition2.findMatchFor(source.getDefinition(), transaction);
            if (sourceDefinition3 != null) {
                throw new UnsupportedOperationException("Extraction input matched");
            }
            if (bl2) {
                // empty if block
            }
            set.add(source);
        }
        if (!bl) {
            return;
        }
        hashSet.clear();
        sourceDefinition.accumulateInputs(hashSet, transaction, true, false);
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            source = (Source)iterator.next();
            sourceDefinition3 = sourceDefinition2.findMatchFor(source.getDefinition(), transaction);
            if (sourceDefinition3 != null) continue;
            set.add(source);
        }
    }

    public Model findOrCreateExtractModel(Source source, Transaction transaction) {
        return this.getBase().findOrCreateExtractModel(source, transaction);
    }

    public final SourceDefinition getComparison() {
        return this.m_Comparison;
    }

    public final int getComparisonRule() {
        return this.m_ComparisonRule;
    }

    public final SourceDefinition getJoined() {
        return this.m_Joined;
    }

    public final boolean isVisible() {
        return this.m_Visible;
    }

    private void matchInputsToOutputs(SourceDefinition sourceDefinition, SourceDefinition sourceDefinition2, Transaction transaction) {
        Set set = sourceDefinition.getInputs();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Source source = (Source)iterator.next();
        }
    }

    private void setComparison(SourceDefinition sourceDefinition) {
        this.m_Comparison = sourceDefinition;
    }

    private void setComparisonRule(int n) {
        this.m_ComparisonRule = n;
    }

    private void setJoined(SourceDefinition sourceDefinition) {
        this.m_Joined = sourceDefinition;
    }

    private void setVisible(boolean bl) {
        this.m_Visible = bl;
    }
}

