/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.olapi.Debug;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.cursor.CursorManager;
import oracle.olapi.data.source.BooleanParameter;
import oracle.olapi.data.source.BooleanSource;
import oracle.olapi.data.source.CompoundCursorSpecification;
import oracle.olapi.data.source.ConstantListDefinition;
import oracle.olapi.data.source.CursorInfoSpecification;
import oracle.olapi.data.source.CursorManagerSpecification;
import oracle.olapi.data.source.CursorManagerSpecificationExpiredException;
import oracle.olapi.data.source.CursorSpecification;
import oracle.olapi.data.source.CustomModel;
import oracle.olapi.data.source.DateParameter;
import oracle.olapi.data.source.DateSource;
import oracle.olapi.data.source.DefaultSourceExpressionFactory;
import oracle.olapi.data.source.FunctionDefinition;
import oracle.olapi.data.source.FundamentalIdProvider;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.IncorrectDataValueException;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.NumberParameter;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.ParameterizedSourceDefinition;
import oracle.olapi.data.source.RangeDefinition;
import oracle.olapi.data.source.SQLCursorManager;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.SourceExpressionFactory;
import oracle.olapi.data.source.SourceIDProvider;
import oracle.olapi.data.source.SpecifiedCursorManager;
import oracle.olapi.data.source.StringParameter;
import oracle.olapi.data.source.StringSource;
import oracle.olapi.data.source.ValueCursorSpecification;
import oracle.olapi.metadata.MetadataProvider;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionProvider;
import oracle.olapi.transaction.TransactionalObject;
import oracle.olapi.transaction.TransactionalObjectInvalidException;

public abstract class DataProvider {
    private TransactionProvider _transactionProvider;
    private SourceIDProvider _sourceIDProvider;
    private FundamentalMetadataProvider _fundamentalMetadataProvider;
    private Map _metadataProviderMap;
    private SourceExpressionFactory m_SourceExpressionFactory = null;

    protected DataProvider(TransactionProvider transactionProvider, FundamentalIdProvider fundamentalIdProvider) {
        this._transactionProvider = transactionProvider;
        this._sourceIDProvider = new SourceIDProvider();
        this._metadataProviderMap = new HashMap();
        this._fundamentalMetadataProvider = new FundamentalMetadataProvider(this, fundamentalIdProvider);
        this.setSourceExpressionFactory(new DefaultSourceExpressionFactory(this));
    }

    public final SourceIDProvider _getSourceIDProvider() {
        return this._sourceIDProvider;
    }

    protected void _resetSourceIDProvider() {
        Debug.println("DataProvider: Resetting Object IDs.");
        this._sourceIDProvider = new SourceIDProvider();
    }

    public abstract void close();

    public final NumberSource createConstantSource(double d) {
        return this.createListSource(new double[]{d});
    }

    public final NumberSource createConstantSource(float f) {
        return this.createListSource(new float[]{f});
    }

    public final NumberSource createConstantSource(int n) {
        return this.createListSource(new int[]{n});
    }

    public final StringSource createConstantSource(String string) {
        return this.createListSource(new String[]{string});
    }

    public final DateSource createConstantSource(Date date) {
        return this.createListSource(new Date[]{date});
    }

    public final Source createConstantSource(Source source) {
        return this.createListSource(new Source[]{source});
    }

    public final NumberSource createConstantSource(short s) {
        return this.createListSource(new short[]{s});
    }

    public final BooleanSource createConstantSource(boolean bl) {
        return this.createListSource(new boolean[]{bl});
    }

    public final SpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification) throws CursorManagerSpecificationExpiredException {
        return this.createCursorManager(cursorManagerSpecification, null);
    }

    public SpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification, Source[] sourceArray) throws CursorManagerSpecificationExpiredException {
        return this.createCursorManager(cursorManagerSpecification, sourceArray, null);
    }

    public abstract SpecifiedCursorManager createCursorManager(CursorManagerSpecification var1, Source[] var2, Properties var3) throws CursorManagerSpecificationExpiredException;

    public final CursorManager createCursorManager(Source source) {
        CursorManager[] cursorManagerArray = this.createCursorManagers(new Source[]{source});
        return cursorManagerArray[0];
    }

    public final CursorManager[] createCursorManagers(Source[] sourceArray) {
        int[] nArray = new int[sourceArray.length];
        CursorInfoSpecification[] cursorInfoSpecificationArray = new CursorInfoSpecification[sourceArray.length];
        for (int i = 0; i < sourceArray.length; ++i) {
            nArray[i] = 1000;
            cursorInfoSpecificationArray[i] = this.createCursorInfoSpecification(sourceArray[i]);
        }
        return this.createCursorManagers(sourceArray, nArray, cursorInfoSpecificationArray);
    }

    public final CursorManager createCursorManager(Source source, int n, CursorInfoSpecification cursorInfoSpecification) {
        CursorManager[] cursorManagerArray = this.createCursorManagers(new Source[]{source}, new int[]{n}, new CursorInfoSpecification[]{cursorInfoSpecification});
        return cursorManagerArray[0];
    }

    public CursorManager[] createCursorManagers(Source[] sourceArray, int[] nArray, CursorInfoSpecification[] cursorInfoSpecificationArray) {
        return this.createCursorManagers(sourceArray, nArray, cursorInfoSpecificationArray, null);
    }

    public abstract CursorManager[] createCursorManagers(Source[] var1, int[] var2, CursorInfoSpecification[] var3, Properties var4);

    public final CursorInfoSpecification createCursorInfoSpecification(Source source) throws TransactionalObjectInvalidException {
        Transaction transaction = this.getTransactionProvider().getCurrentTransactionForDataRead();
        CursorInfoSpecification cursorInfoSpecification = this.createCursorInfoSpecification(source, transaction);
        cursorInfoSpecification.setTransaction(transaction);
        ((CursorSpecification)cursorInfoSpecification)._setDefaultFetchSize(100);
        return cursorInfoSpecification;
    }

    private final CursorInfoSpecification createCursorInfoSpecification(Source source, Transaction transaction) throws TransactionalObjectInvalidException {
        ArrayList arrayList = new ArrayList();
        source.getDefinition().accumulateOutputs(arrayList, transaction);
        if (arrayList.isEmpty()) {
            return new ValueCursorSpecification(source.getDefinition());
        }
        ArrayList<CursorSpecification> arrayList2 = new ArrayList<CursorSpecification>(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Source source2 = (Source)iterator.next();
            CursorSpecification cursorSpecification = (CursorSpecification)this.createCursorInfoSpecification(source2, transaction);
            arrayList2.add(cursorSpecification);
        }
        return new CompoundCursorSpecification(source.getDefinition(), arrayList2);
    }

    public final CursorManagerSpecification createCursorManagerSpecification(Source source) throws TransactionalObjectInvalidException {
        Transaction transaction = this.getTransactionProvider().getCurrentTransactionForDataRead();
        return new CursorManagerSpecification(source.getDefinition(), transaction);
    }

    public final NumberSource createListSource(double[] dArray) {
        ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(new Double(dArray[i]));
        }
        return (NumberSource)this.createListSource(arrayList, this.getFundamentalMetadataProvider().getDoubleDataType());
    }

    public final NumberSource createListSource(float[] fArray) {
        ArrayList<Float> arrayList = new ArrayList<Float>(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            arrayList.add(new Float(fArray[i]));
        }
        return (NumberSource)this.createListSource(arrayList, this.getFundamentalMetadataProvider().getFloatDataType());
    }

    public final NumberSource createListSource(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new Integer(nArray[i]));
        }
        return (NumberSource)this.createListSource(arrayList, this.getFundamentalMetadataProvider().getIntegerDataType());
    }

    public final StringSource createListSource(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (null == stringArray[i]) {
                throw new IncorrectDataValueException("null is not a valid String value");
            }
            arrayList.add(stringArray[i]);
        }
        return (StringSource)this.createListSource(arrayList, this.getFundamentalMetadataProvider().getStringDataType());
    }

    public final DateSource createListSource(Date[] dateArray) {
        ArrayList<Date> arrayList = new ArrayList<Date>(dateArray.length);
        for (int i = 0; i < dateArray.length; ++i) {
            arrayList.add(dateArray[i]);
        }
        return (DateSource)this.createListSource(arrayList, this.getFundamentalMetadataProvider().getDateDataType());
    }

    public final Source createListSource(Source[] sourceArray) {
        boolean bl = this.isServerVersionLaterThan(new int[]{10, 1, 0, 3});
        return this.createListSource(sourceArray, bl);
    }

    final Source createListSource(Source[] sourceArray, boolean bl) {
        Object object;
        TransactionalObject transactionalObject;
        Object object2;
        int n;
        Transaction transaction = this.getTransactionProvider().getCurrentTransactionForMetadataWrite();
        String[] stringArray = null;
        ArrayList<Object> arrayList = null;
        List[] listArray = null;
        if (bl) {
            stringArray = new String[sourceArray.length];
            listArray = new List[sourceArray.length];
        } else {
            arrayList = new ArrayList<Object>();
        }
        SourceDefinition sourceDefinition = null;
        int n2 = -1;
        for (n = 0; n < sourceArray.length; ++n) {
            object2 = sourceArray[n].getDefinition();
            ((SourceDefinition)object2).checkValidity(transaction);
            sourceDefinition = sourceDefinition == null ? ((SourceDefinition)object2).getType(transaction) : sourceDefinition.getCommonType((SourceDefinition)object2, transaction);
            if (bl) {
                List list;
                stringArray[n] = sourceArray[n].getID();
                listArray[n] = list = ((SourceDefinition)object2).getOutputs();
                if (n2 != -1 && list.size() >= n2) continue;
                n2 = list.size();
                continue;
            }
            arrayList.add(object2);
        }
        if (!bl) {
            object2 = new ConstantListDefinition(arrayList, sourceDefinition, this.getFundamentalMetadataProvider().getStringDataType()._getSourceDefinition(), transaction);
            return ((SourceDefinition)object2).findOrCreateSource(transaction);
        }
        if (sourceDefinition instanceof FunctionDefinition) {
            sourceDefinition = sourceDefinition.getType(transaction);
        }
        object2 = null;
        if (n2 > 0) {
            object2 = new Source[n2];
            for (int i = 0; i < n2; ++i) {
                transactionalObject = null;
                for (n = 0; n < sourceArray.length; ++n) {
                    object = listArray[n];
                    Source source = (Source)object.get(i);
                    transactionalObject = transactionalObject == null ? source.getDefinition() : ((SourceDefinition)transactionalObject).getCommonType(source.getDefinition(), transaction);
                }
                if (transactionalObject instanceof FunctionDefinition) {
                    transactionalObject = ((SourceDefinition)transactionalObject).getType(transaction);
                }
                object2[i] = ((SourceDefinition)transactionalObject).findOrCreateSource(transaction);
            }
        }
        StringSource stringSource = this.createListSource(stringArray);
        transactionalObject = this.createModel(new Source[]{stringSource}, sourceDefinition.findOrCreateSource(transaction), (Source[])object2);
        for (n = 0; n < sourceArray.length; ++n) {
            transactionalObject.assign(stringArray[n], sourceArray[n]);
        }
        object = (ConstantListDefinition)stringSource.getDefinition();
        ((ConstantListDefinition)object).setCalculationModel((Model)transactionalObject);
        return stringSource;
    }

    public final NumberSource createListSource(short[] sArray) {
        ArrayList<Short> arrayList = new ArrayList<Short>(sArray.length);
        for (int i = 0; i < sArray.length; ++i) {
            arrayList.add(new Short(sArray[i]));
        }
        return (NumberSource)this.createListSource(arrayList, this.getFundamentalMetadataProvider().getShortDataType());
    }

    public final BooleanSource createListSource(boolean[] blArray) {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(blArray.length);
        for (int i = 0; i < blArray.length; ++i) {
            arrayList.add(new Boolean(blArray[i]));
        }
        return (BooleanSource)this.createListSource(arrayList, this.getFundamentalMetadataProvider().getBooleanDataType());
    }

    public final Source createListSource(Object[][] objectArray) {
        Object object;
        Transaction transaction = this.getTransactionProvider().getCurrentTransactionForMetadataWrite();
        if (!this._checkTuplesValidity(objectArray)) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            object = new ArrayList(objectArray[i].length);
            for (int j = 0; j < objectArray[i].length; ++j) {
                ((ArrayList)object).add(objectArray[i][j]);
            }
            arrayList.add(object);
        }
        SourceDefinition sourceDefinition = this.getConstantDataType(objectArray[0][0])._getSourceDefinition();
        object = sourceDefinition;
        if (objectArray[0][0] instanceof Source) {
            object = this.getFundamentalMetadataProvider().getStringDataType()._getSourceDefinition();
        }
        ConstantListDefinition constantListDefinition = new ConstantListDefinition(arrayList, sourceDefinition, (SourceDefinition)object, transaction);
        return constantListDefinition.findOrCreateSource(transaction);
    }

    private boolean _checkTuplesValidity(Object[][] objectArray) {
        int n;
        int n2 = objectArray[0].length;
        for (n = 1; n < objectArray.length; ++n) {
            if (n2 == objectArray[n].length) continue;
            return false;
        }
        for (n = 0; n < n2; ++n) {
            FundamentalMetadataObject fundamentalMetadataObject = this.getConstantDataType(objectArray[0][n]);
            for (int i = 1; i < objectArray.length; ++i) {
                if (fundamentalMetadataObject == this.getConstantDataType(objectArray[i][n])) continue;
                return false;
            }
        }
        return true;
    }

    public final FundamentalMetadataObject getConstantDataType(Object object) {
        FundamentalMetadataObject fundamentalMetadataObject = null;
        if (object instanceof Short) {
            fundamentalMetadataObject = this.getFundamentalMetadataProvider().getShortDataType();
        } else if (object instanceof Integer) {
            fundamentalMetadataObject = this.getFundamentalMetadataProvider().getIntegerDataType();
        } else if (object instanceof Float) {
            fundamentalMetadataObject = this.getFundamentalMetadataProvider().getFloatDataType();
        } else if (object instanceof Double) {
            fundamentalMetadataObject = this.getFundamentalMetadataProvider().getDoubleDataType();
        } else if (object instanceof String) {
            fundamentalMetadataObject = this.getFundamentalMetadataProvider().getStringDataType();
        } else if (object instanceof Date) {
            fundamentalMetadataObject = this.getFundamentalMetadataProvider().getDateDataType();
        }
        return fundamentalMetadataObject;
    }

    private final Source createListSource(List list, FundamentalMetadataObject fundamentalMetadataObject) {
        Transaction transaction = this.getTransactionProvider().getCurrentTransactionForMetadataWrite();
        ConstantListDefinition constantListDefinition = new ConstantListDefinition(list, fundamentalMetadataObject._getSourceDefinition(), fundamentalMetadataObject._getSourceDefinition(), transaction);
        return constantListDefinition.findOrCreateSource(transaction);
    }

    public final CustomModel createModel(Source[] sourceArray, Source source, Source[] sourceArray2, Model[] modelArray) {
        Transaction transaction = this.getTransactionProvider().getCurrentTransactionForMetadataWrite();
        return new CustomModel(this, sourceArray, source, sourceArray2, modelArray, transaction);
    }

    public final CustomModel createModel(Source[] sourceArray, Source source, Source[] sourceArray2) {
        return this.createModel(sourceArray, source, sourceArray2, null);
    }

    public final CustomModel createModel(Source[] sourceArray, Source source, Model[] modelArray) {
        return this.createModel(sourceArray, source, null, modelArray);
    }

    public final CustomModel createModel(Source[] sourceArray, Source source) {
        return this.createModel(sourceArray, source, null, null);
    }

    public final CustomModel createModel(Source[] sourceArray) {
        return this.createModel(sourceArray, this.getFundamentalMetadataProvider().getNumberDataType().getSource());
    }

    public final CustomModel createModel(Source source, Source source2) {
        return this.createModel(new Source[]{source}, source2);
    }

    public final CustomModel createModel(Source source) {
        return this.createModel(new Source[]{source});
    }

    public final StringSource createParameterizedSource(StringParameter stringParameter) {
        return (StringSource)this.createParameterizedSource(stringParameter, this.getFundamentalMetadataProvider().getStringDataType());
    }

    public final DateSource createParameterizedSource(DateParameter dateParameter) {
        return (DateSource)this.createParameterizedSource(dateParameter, this.getFundamentalMetadataProvider().getDateDataType());
    }

    public final BooleanSource createParameterizedSource(BooleanParameter booleanParameter) {
        return (BooleanSource)this.createParameterizedSource(booleanParameter, this.getFundamentalMetadataProvider().getBooleanDataType());
    }

    public final NumberSource createParameterizedSource(NumberParameter numberParameter) {
        return (NumberSource)this.createParameterizedSource(numberParameter, this.getFundamentalMetadataProvider().getNumberDataType());
    }

    private final Source createParameterizedSource(Parameter parameter, FundamentalMetadataObject fundamentalMetadataObject) {
        if (!this.isServerVersionLaterThan(new int[]{10, 0, 0, 0})) {
            throw new UnsupportedOperationException();
        }
        Transaction transaction = this.getTransactionProvider().getCurrentTransactionForMetadataWrite();
        ParameterizedSourceDefinition parameterizedSourceDefinition = new ParameterizedSourceDefinition(parameter, fundamentalMetadataObject._getSourceDefinition(), transaction);
        return parameterizedSourceDefinition.findOrCreateSource(transaction);
    }

    public final NumberSource createRangeSource(int n, int n2) {
        return this.createRangeSource(this.createConstantSource(n), this.createConstantSource(n2));
    }

    public final NumberSource createRangeSource(int n, NumberSource numberSource) {
        return this.createRangeSource(this.createConstantSource(n), numberSource);
    }

    public final NumberSource createRangeSource(NumberSource numberSource, int n) {
        return this.createRangeSource(numberSource, this.createConstantSource(n));
    }

    public final NumberSource createRangeSource(NumberSource numberSource, NumberSource numberSource2) {
        Transaction transaction = this.getTransactionProvider().getCurrentTransactionForMetadataWrite();
        SourceDefinition sourceDefinition = numberSource.getDefinition();
        sourceDefinition.checkValidity(transaction);
        SourceDefinition sourceDefinition2 = numberSource2.getDefinition();
        sourceDefinition2.checkValidity(transaction);
        RangeDefinition rangeDefinition = new RangeDefinition(sourceDefinition, sourceDefinition2, transaction);
        return (NumberSource)rangeDefinition.findOrCreateSource(transaction);
    }

    public final Source getEmptySource() {
        return this._fundamentalMetadataProvider.getEmptyDataType().getSource();
    }

    public final FundamentalMetadataProvider getFundamentalMetadataProvider() {
        return this._fundamentalMetadataProvider;
    }

    public MetadataProvider getMetadataProvider(String string) {
        return (MetadataProvider)this._metadataProviderMap.get(string);
    }

    public final SourceExpressionFactory getSourceExpressionFactory() {
        return this.m_SourceExpressionFactory;
    }

    public final TransactionProvider getTransactionProvider() {
        return this._transactionProvider;
    }

    public final Source getVoidSource() {
        return this._fundamentalMetadataProvider.getVoidDataType().getSource();
    }

    public abstract void initialize() throws SQLException;

    public abstract boolean isOpen();

    public abstract boolean isServerVersionLaterThan(int[] var1);

    public void registerMetadataProvider(MetadataProvider metadataProvider) {
        this._metadataProviderMap.put(metadataProvider.getID(), metadataProvider);
    }

    public final void setSourceExpressionFactory(SourceExpressionFactory sourceExpressionFactory) {
        this.m_SourceExpressionFactory = sourceExpressionFactory;
        sourceExpressionFactory.setDataProvider(this);
    }

    public void unregisterMetadataProvider(MetadataProvider metadataProvider) {
        this._metadataProviderMap.remove(metadataProvider.getID());
    }

    public final SQLCursorManager createSQLCursorManager(Source source) throws TransactionalObjectInvalidException {
        SQLCursorManager[] sQLCursorManagerArray = this.createSQLCursorManagers(new Source[]{source});
        return sQLCursorManagerArray[0];
    }

    public abstract SQLCursorManager[] createSQLCursorManagers(Source[] var1);

    public abstract String getProperty(String var1);

    public abstract String getShortXMLTag();

    public abstract String getIntegerXMLTag();

    public abstract String getLongXMLTag();

    public abstract String getFloatXMLTag();

    public abstract String getDoubleXMLTag();

    public abstract String getStringXMLTag();

    public abstract String getBooleanXMLTag();

    public abstract String getDateXMLTag();
}

